<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL" />

   <xsl:param name="prefForm" />

   <xsl:param name="mediaPath" />

<!-- message d'erreur si l'annee saisie est incorrecte -->
   <xsl:param name="erreur" />

<!-- annee par defaut ou annee saisie par l'utlisateur -->
   <xsl:param name="annee" />

<!-- niveau slectionn prcdemment dans la liste -->
   <xsl:param name="niveau" />

   <xsl:template match="xml">
      <br />

      <table cellspacing="0" cellpadding="5" width="100%" border="0">
         <tr>
            <td nowrap="true" class="uportal-channel-table-header">Liste d'tudiants</td>

            <td width="5%"></td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action=default">
                  <img alt="Retour au sommaire" border="0" src="{$mediaPath}/back.gif" />
               </a>
            </td>

            <td class="uportal-label" nowrap="true">
               <a href="{$baseActionURL}?action=default">Retour au sommaire</a>
            </td>

            <td width="100%"></td>
         </tr>
      </table>

      <hr />

      <p align="justify" class="uportal-channel-text">Vous allez constituer une liste d'inscrits  un lment ou  un diplme Apoge  l'aide d'un arbre de recherche.</p>

      <form name="{$prefForm}formRechercheApogee" action="{$baseActionURL}" method="post">
         <table border="0" cellspacing="0" cellpadding="4">
            <tr>
               <td class="uportal-label">Anne universitaire</td>

               <td>
                  <input type="text" name="annee" size="4" maxlength="4" class="uportal-input-text" value="{$annee}" />

                  <xsl:if test="$erreur='annee'">
                     <div class="uportal-channel-table-caption">L'anne doit tre compose de 4 chiffres</div>
                  </xsl:if>
               </td>
            </tr>

            <tr>
               <td class="uportal-label">Type de liste</td>

               <td>
                  <select name="liste" class="uportal-button">
                     <option value="etapes">
                     <xsl:if test="$niveau='etapes'">
                        <xsl:attribute name="selected">selected</xsl:attribute>
                     </xsl:if>

                     Etape ou diplme</option>

                     <option value="elements">
                     <xsl:if test="$niveau='elements'">
                        <xsl:attribute name="selected">selected</xsl:attribute>
                     </xsl:if>

                     Elment pdagogique</option>
                  </select>
               </td>
            </tr>
         </table>

         <p align="justify" class="uportal-channel-text">Vous pouvez affiner votre recherche en cochant certains critres ci-dessous : par exemple "tape d'appartenance", pour visualiser  quelle anne de diplme l'tudiant est rattach, ou "rsultats de session1" pour extraire la liste des rsultats de la session 1 de l'anne universitaire slectionne...</p>

         <table border="0" cellspacing="3" cellpadding="4">
            <tr>
               <td class="uportal-label">
               <input type="checkbox" name="TEM_RESJ" value="O" />

               Rsultats de session 1</td>

               <td class="uportal-label">
               <input type="checkbox" name="TEM_RESS" value="O" />

               Rsultats de session 2</td>

               <td class="uportal-label">
               <input type="checkbox" name="TEM_ETP" value="O" />

               Etape d'appartenance</td>
            </tr>

            <tr>
               <td colspan="3">
               </td>
            </tr>

            <tr>
               <td colspan="3">
                  <input type="submit" value="Rechercher" class="uportal-button" />

                  <input type="hidden" value="selectListe" name="action" />
               </td>
            </tr>
         </table>
      </form>
   </xsl:template>
</xsl:stylesheet>

