package org.esupportail.portal.channels.gestion.CMonDossierWebEns;

import java.sql.SQLException;

import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;
import org.esupportail.portal.utils.channels.plugins.FatalError;
import org.esupportail.portal.utils.channels.plugins.RestrictedAction;
import org.esupportail.portal.utils.database.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * <p>CMonDossierWebEns</p>
 * <p>Description : Mon dossier Web : consultation des rsultats des tudiants par les enseignants</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class CMonDossierWebEns extends MainChannel {
	
	// log
	private static final Log log = LogFactory.getLog(CMonDossierWebEns.class);
	// id de l'utilisateur
	private String userId;	
	// code de l'tudiant trait
	private String cod_ind;
	// login de la personne traite
	private String loginEtu;
	// anne utilise pour les requtes
	private String annee;
	// niveau slectionn pour les listes (Composante/Diplome/Etape/Element)
	private String niveau;
	
	// servant mailTo
	private final static String toField ="to";//Mail.TO : pour viter la dpendence on n'utilise pas la constante
	private final static String ccField ="cc";//Mail.CC : pour viter la dpendence on n'utilise pas la constante
	private final static String bccField ="bcc";//Mail.BCC : pour viter la dpendence on n'utilise pas la constante

	public CMonDossierWebEns() throws PortalException {
		setConfigActions(Config.getInstance());	
	}
	
	/** 
	 *  Receive static channel data from the portal.
	 *  Satisfies implementation of IChannel Interface.
	 *
	 *  @param <b>ChannelStaticData</b> sd static channel data
	 */
	public void setStaticData(ChannelStaticData sd) {
		staticData = sd;
		userId = (String) staticData.getPerson().getAttribute(IPerson.USERNAME);
		// test d'accs au canal
		try {
			if (!RestrictedAction.filterAccess(this,"default",Config.getInstance().getGroupmapping(),false)){
				// si la personne connecte ne fait pas partie du groupe autoris, on regarde si elle n'a 
				// pas un login actif dans Apogee dans le cas o cette option est active 
				if (true && !(Config.getInstance().getLoginApogee() && checkCptApogee(userId))) {
					FatalError.fatalError(this, Config.getInstance().getMsgInterdit());
					log.error("CMonDossierWebEns::setStaticData: Acces refuse");
				}		
			}
		} catch (PortalException e) {
			log.error("CMonDossierWebEns::setStaticData: Erreur Controle d'acces " + e);
		} catch (FrameWorkException e) {
			log.error("CMonDossierWebEns::setStaticData: Erreur Controle d'acces " + e);
		}
	}
		
	public void setRuntimeData(ChannelRuntimeData rd) throws PortalException  {
		// gestion du back navigateur pour le servant CMailToServantFinished
		if (rd.getParameter("action") != null && !rd.getParameter("action").equals("sendMail")
			&& currentAction != null && currentAction.getName().equals("sendMail")) {
			rd.setParameter("CMailToServantFinished","1");
			currentAction.setServantfinish("resListe");
		}
		if (rd != null) {	
			// Destinataire du canal MailTo
			String[] att = new String[3];
			// la scolarit dans le cas du lien "Nous contacter"
			if (rd.getParameter("dest") != null && rd.getParameter("dest").equals("scolarite")) 
				att[0] = Config.getInstance().getAdrContact();
	        else // le titulaire du dossier consult dans le cas du lien sur le mail
				att[0] = rd.getParameter("mail");
	        att[1] = "false";
	        att[2] = "true";
	        rd.setParameterValues(toField,att);
		}
		super.setRuntimeData(rd);
	}
	
	/**
	 * @return
	 */
	public String getUserId() {
		return userId;
	}
	
	/** 
	 *  Initialise les static et les runtime data pour le servant
	 *  @param <b>IServant</b> servant servant  instancier
	 */
	public void initServant(IServant servant) throws PortalException {
		// servant Annuaire
		if (getActionParam("servantAnnuaire","name") != null)
			staticData.setParameter("serverView", getActionParam("servantAnnuaire","name").getValue()); 
		if (getActionParam("servantAnnuaire","type") != null)
			staticData.setParameter("returnServant",getActionParam("servantAnnuaire","type").getValue());
		if (getActionParam("servantAnnuaire","displayFiche") != null)
			staticData.setParameter("affFiche",getActionParam("servantAnnuaire","displayFiche").getValue());
		// servant MonDossierWeb
		if (this.currentAction.getName().equals("servantMonDossierWeb") || this.currentAction.getName().equals("servantMonDossierWebListe")
				|| this.currentAction.getName().equals("servantMonDossierWebCodEtu")) {
			staticData.setParameter("cod_ind",cod_ind);
			staticData.setParameter("loginEtu",loginEtu);
		}
		// servant RechercheApogee
		if (this.currentAction.getName().equals("servantRechercheApogee")) {
			if (annee != null) {
				staticData.setParameter("annee",annee);
			}	
			if (niveau != null) {
				staticData.setParameter("niveau",niveau);
			}
		}
		// Servant Envoi de mails
		if (this.currentAction.getName().equals("sendMail")) {
			// Destinataire
			String[] att = new String[3];
			// la scolarit dans le cas du lien "Nous contacter"
			if (runtimeData.getParameter("dest") != null && runtimeData.getParameter("dest").equals("scolarite")) 
				att[0] = Config.getInstance().getAdrContact();
	        else // le titulaire du dossier consult dans le cas du lien sur le mail
	        	att[0] = runtimeData.getParameter("mail");
	        att[1] = "false";
	        att[2] = "true";
	        runtimeData.setParameterValues(toField,att);
	        // Les champs copies sont dsactivs
	        att = new String[3];
	        att[0] = "";
	        att[1] = "false";
	        att[2] = "false";
	        runtimeData.setParameterValues(ccField,att);
	        att = new String[3];
	        att[0] = "";
	        att[1] = "false";
	        att[2] = "false";
	        runtimeData.setParameterValues(bccField,att);
	        // on fixe dynamiquement l'action de retour en fonction de l'action appelante
	        this.currentAction.setServantfinish(this.previousAction.getName());
		}
		super.initServant(servant);
	}
	
		/**
		 * Vrifie si le login pass en paramtre  une correspondance dans Apogee
		 * @return
		 */
	public boolean checkCptApogee(String login) throws FrameWorkException {
		Query qry = null;
		boolean error= false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select * from apogee.utilisateur where cod_uti = ? and tem_en_sve_uti = 'O'");
			qry.getStmt().setString(1, login.toUpperCase());
			qry.select();
			if (qry.getRs() != null) {
				while (qry.getRs().next()){
					return true;
				}
			}	
		}
		catch (SQLException e) {
			log.error("ListeCSV::getListe() : Erreur SQL " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return false;
	}
	
	
	/**
	 * @return Returns the cod_ind.
	 */
	public String getCod_ind() {
		return cod_ind;
	}
	
	/**
	 * @param cod_ind The cod_ind to set.
	 */
	public void setCod_ind(String cod_ind) {
		this.cod_ind = cod_ind;
	}
	
	/**
	 * @return Returns the loginEtu.
	 */
	public String getLoginEtu() {
		return loginEtu;
	}
	/**
	 * @param loginEtu The loginEtu to set.
	 */
	public void setLoginEtu(String loginEtu) {
		this.loginEtu = loginEtu;
	}
	
	/**
	 * @return Returns the annee.
	 */
	public String getAnnee() {
		return annee;
	}
	/**
	 * @param annee The annee to set.
	 */
	public void setAnnee(String annee) {
		this.annee = annee;
	}
	/**
	 * @return Returns the niveau.
	 */
	public String getNiveau() {
		return niveau;
	}
	/**
	 * @param niveau The niveau to set.
	 */
	public void setNiveau(String niveau) {
		this.niveau = niveau;
	}
}
