package org.esupportail.portal.channels.gestion.CMonDossierWebEns;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import java.util.regex.Pattern;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.esupportail.portal.channels.gestion.CRechercheApogee.CRechercheApogee;
import org.esupportail.portal.channels.gestion.CRechercheApogee.Niveau;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XMLEscaper;

/**
 * <p>Liste</p>
 * <p>Sub-channel pour l'dition de liste d'tudiants</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class Liste extends SubChannel {

	// log
	private static final Log log = LogFactory.getLog(Liste.class);	
	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// Niveau slectionn lors de la recherche Apogee
	private Niveau niveau;
	// message d'erreur
	private String erreur;
	// tmoin d'affichage des rsultats de juin
	protected String TEM_RESJ;
	// tmoin d'affichage des rsultats de septembre
	protected String TEM_RESS;
	// tmoin pour visualiser  quelle anne de diplme l'tudiant est rattach
	protected String TEM_ETP;
	// Anne en cours
	protected String anneeEnCours;
			
	/**
	 * Constructeur
	 * @param main
	 */
	public Liste(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
	}
	
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd); 
		
		// si l'utilisateur a fait un back  partir du servant MailTo, redirection sur la page d'accueil quand
		// tentative 'Nouvelle Recherche'
		if (runtimeData.getParameter("redirect") != null) {
			owner.redirect(runtimeData,runtimeData.getParameter("redirect"));
			return Boolean.FALSE;
		}
		
		return res;
	}
	
	/**
	 * setXML pour la liste des tudiants
	 * @return
	 * @throws FrameWorkException
	 * @throws PortalException
	 */
	public Boolean setXMLListe() throws FrameWorkException, PortalException {
		StringBuffer xml = new StringBuffer(START_XML);
		
		// si 'retour au sommaire' slectionn
		if (runtimeData.getParameter("sommaire") != null) {
			owner.redirect(runtimeData,runtimeData.getParameter("sommaire"));
			return Boolean.FALSE;
		}
				
		// rcupration du rsultat du servant RechercheApogee
		if (owner.getServantResults() != null && owner.getServantResults()[0] != null) {
			niveau = (Niveau) owner.getServantResults()[0];
		}	
			
		if (niveau != null && niveau.getId() != null) {
			xml.append("<result id=\"").append(niveau.getId()).append("\" ");		
			xml.append("vers=\"").append(niveau.getVers()).append("\" ");
			xml.append("lib=\"").append(niveau.getLibelle()).append("\" ");
			xml.append("annee=\"").append(owner.getAnnee()).append("\" ");
			xml.append("/>");	
			xml.append(getListe(niveau.getId(),owner.getAnnee()));				
			// passage de l'id de l'tape  la feuille de style	
			this.getXSLParameter().put("idEtape",niveau.getId());
			// passage des diffrentes tmoins 
			if (TEM_RESJ != null)
				this.getXSLParameter().put("TEM_RESJ",TEM_RESJ);
			if (TEM_RESS != null)
				this.getXSLParameter().put("TEM_RESS",TEM_RESS);
			if (TEM_ETP != null)
				this.getXSLParameter().put("TEM_ETP",TEM_ETP);
		}
		else {
			try {
				// on redirige vers le menu de slection si la personne a abandone sa recherche
				owner.redirect(runtimeData,"selectListe");
			} catch (PortalException e) {
				log.error("Liste::setXMLListe : " + e);
			}
			return Boolean.FALSE;
		}
		xml.append(END_XML);
		setXML(xml.toString());
		// pour permettre le bon fonctionnement du lien de tlchargement
		addDownloadXslParameter();
		return Boolean.TRUE;
	}
	
	/**
	 * init appel pour la slection de la liste et de l'anne 
	 * 
	 * @param rd
	 * @return
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean selection(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		// on rinitialise le rsultat de la recherche
		niveau = null;
		// passage du msg d'erreur et de l'anne saisie en paramtre de la feuille xsl
		if (this.getErreur() != null)
			this.getXSLParameter().put("erreur",this.getErreur());
		if (this.getAnnee() != null)
			this.getXSLParameter().put("annee",this.getAnnee());
		// passage du niveau slectionn
		if (owner.getNiveau() != null)
			this.getXSLParameter().put("niveau",owner.getNiveau());
		
		// initialisation du message d'erreur
		setErreur("");
		// vrification de l'anne saisie et redirection sur le servant RechercheApogee si ok
		if (rd.getParameter("annee") != null && !rd.getParameter("annee").equals("")) {
			owner.setAnnee(rd.getParameter("annee"));
			// test de la validit de l'anne
			if (!Pattern.compile("^[0-9]{4}").matcher(owner.getAnnee()).find()) {
				try {
					setErreur("annee");
					owner.redirect(rd,"selectListe");
					return Boolean.FALSE;
				} catch (PortalException e) {
					log.error("Liste::selection : echec redirect ");
				}
			}
			else {
				// on fixe le choix de la liste (Composante/Diplome/Etape/Element)
				owner.setNiveau(rd.getParameter("liste"));
				// affichage des rsultats de juin
				TEM_RESJ = runtimeData.getParameter("TEM_RESJ");
				// affichage des rsultats de septembre
				TEM_RESS = runtimeData.getParameter("TEM_RESS");
				// autres tmoins
				TEM_ETP = runtimeData.getParameter("TEM_ETP");
				owner.redirect(rd,"servantRechercheApogee");
				return Boolean.FALSE;
			}			
		}
		return res;
	}
	
	/**
	 * @return Returns the annee.
	 * @throws FrameWorkException
	 */
	public String getAnnee() throws FrameWorkException, PortalException {
		String anneeEnCours = null;
		if (owner.getAnnee() == null) {
			CRechercheApogee ra = new CRechercheApogee();
			anneeEnCours = ra.getAnneeEnCours();
			this.anneeEnCours = anneeEnCours;
		}	
		else
			anneeEnCours = owner.getAnnee();
		return anneeEnCours;
	}
	
	/**
	 * @param id identifiant du niveau
	 * @param annee anne slectionne
	 * @return retourne la liste des tudiants sous forme de flux xml 
	 * 
	 */
	public StringBuffer getListe(String id, String annee) throws FrameWorkException {
		StringBuffer res = new StringBuffer("<liste>");
		Query qry = null;
		boolean error= false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			if (owner.getNiveau() != null && owner.getNiveau().equals("etapes"))
				selectListeEtape(qry,id,annee);
			else if (owner.getNiveau() != null && owner.getNiveau().equals("elements"))
				selectListeElement(qry,id,annee);
			if (qry.getRs() != null) {
				while (qry.getRs().next()){
					res.append("<etudiant dossier=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_etu"))).append("\" ");
					res.append("nom=\"").append(XMLEscaper.escape(qry.getRs().getString("lib_nom_pat_ind"))).append("\" ");
					res.append("cod_ind=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_ind"))).append("\" ");
					res.append("prenom=\"").append(XMLEscaper.escape(qry.getRs().getString("lib_pr1_ind"))).append("\" ");
					res.append("naissance=\"").append(XMLEscaper.escape(qry.getRs().getString("DATE_NAI_IND"))).append("\" ");
					if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
						res.append("note1=\"").append(XMLEscaper.escape(qry.getRs().getString("NOTEJ"))).append("\" ");
						if (qry.getRs().getString("RESJ") != null && !qry.getRs().getString("RESJ").equals(" "))
							res.append("resultat1=\"").append(XMLEscaper.escape(qry.getRs().getString("RESJ"))).append("\" ");
					}
					if (TEM_RESS != null && TEM_RESS.equals("O")) {
						res.append("note2=\"").append(XMLEscaper.escape(qry.getRs().getString("NOTES"))).append("\" ");
						if (qry.getRs().getString("RESS") != null && !qry.getRs().getString("RESS").equals(" "))
							res.append("resultat2=\"").append(XMLEscaper.escape(qry.getRs().getString("RESS"))).append("\" ");
					}
					if (owner.getNiveau() != null && owner.getNiveau().equals("etapes"))
						res.append("IAE=\"").append(XMLEscaper.escape(qry.getRs().getString("IAE"))).append("\" ");
					if (TEM_ETP != null && TEM_ETP.equals("O")) { 
						res.append("cod_etp=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_etp"))).append("\" ");
						res.append("cod_vrs_vet=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_vrs_vet"))).append("\" ");
						res.append("lib_etp=\"").append(XMLEscaper.escape(qry.getRs().getString("lib_etp"))).append("\" ");
					}	
					res.append("/>");
				}
			}
		}
		catch (SQLException e) {
			log.error("Liste::getListe() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("Liste::getListe() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		res.append("</liste>");
		return res;
	}
	
	
	/**
	 * 
	 * Construction et excution du select pour rcuprer la liste des tudiants d'une tape
	 * @param Query query
	 * @param id identifiant du niveau
	 * @param annee anne slectionne
	 * @throws SQLException
	 */
	public void selectListeEtape(Query qry, String id, String annee) throws SQLException {
		// select gnral
		String select = "select i.cod_ind,i.cod_etu, i.lib_nom_pat_ind, i.lib_pr1_ind," +
						"to_char(i.date_nai_ind,'DD/MM/YYYY') \"DATE_NAI_IND\", " + 
						"decode(rj.tem_iae_ko_vet,0,'O','N') \"IAE\" " ;
		// select tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			select += " ,rj.cod_etp,rj.cod_vrs_vet,e.lib_etp "; 
		// select rsultats Juin
		if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
			select += ", nvl(decode(to_char(rj.not_vet),null,rj.not_sub_vet,to_char(rj.not_vet)),' ') \"NOTEJ\" " + 
					  ", nvl(rj.cod_tre,' ') \"RESJ\" ";   		
		}	
		// select rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O")) {
			select += ", nvl(decode(to_char(rs.not_vet),null,rs.not_sub_vet,to_char(rs.not_vet)),' ') \"NOTES\" " +
					  ", nvl(rs.cod_tre,' ') \"RESS\" ";    		
		}	
		// from gnral
		String from = "from apogee.individu i , apogee.resultat_vet rj ";
		// from rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O"))
			from += " left outer join apogee.resultat_vet rs on ( rs.cod_ind = rj.cod_ind " + 
					" and rs.tem_iae_ko_vet in ('0','2') " +
					" and rs.cod_etp = rj.cod_etp " +
					" and rs.cod_vrs_vet = rj.cod_vrs_vet " +
					" and rs.cod_anu = rj.cod_anu " +
					" and rs.cod_ses = '2' " + 
					"and rs.cod_adm = '1') ";
		// from tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			from += " , apogee.etape e ";
		// where gnral
		String where = "where rj.tem_iae_ko_vet in ('0','2') " +
						" and rj.cod_etp = ? " +
						" and rj.cod_anu = ? " +
						" and rj.cod_ses in ('0','1') and rj.cod_adm = '1' " +
						" and i.cod_ind = rj.cod_ind ";
		// where tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			where += " and e.cod_etp = rj.cod_etp ";
		// ordre de tri
		String order = "order by i.lib_nom_pat_ind,i.lib_pr1_ind,i.date_nai_ind ";
		//log("requete : "+ select + from + where + order);
		qry.setSql(select + from + where + order); 
		qry.getStmt().setString(1, id);
		qry.getStmt().setString(2, annee);
		qry.select();
	}
	
	/**
	 * 
	 * Construction et excution du select pour rcuprer la liste des tudiants d'un lment
	 * @param Query query
	 * @param id identifiant du niveau
	 * @param annee anne slectionne
	 * @throws SQLException
	 */
	public void selectListeElement(Query qry, String id, String annee) throws SQLException {
		// select gnral
		String select = "select i.cod_ind,i.cod_etu, i.lib_nom_pat_ind, i.lib_pr1_ind," +
						"to_char(i.date_nai_ind,'DD/MM/YYYY') \"DATE_NAI_IND\" "; 
		// select tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			select += " ,ice.cod_etp,ice.cod_vrs_vet,e.lib_etp ";
		// select rsultats Juin
		if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
			select += ", nvl(decode(to_char(rj.not_elp),null,rj.not_sub_elp,to_char(rj.not_elp)),' ') \"NOTEJ\"" + 
					  ", nvl(rj.cod_tre,' ') \"RESJ\" ";   		
		}	
		// select rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O")) {
			select += ", nvl(decode(to_char(rs.not_elp),null,rs.not_sub_elp,to_char(rs.not_elp)),' ') \"NOTES\"" + 
					  ", nvl(rs.cod_tre,' ') \"RESS\" ";   		
		}	
		// from gnral
		String from = "from apogee.individu i, apogee.ind_contrat_elp ice " ;
		// from rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O"))
			from += " left outer join apogee.resultat_elp rs on ( rs.cod_ind = ice.cod_ind " +
					 " and rs.cod_elp = ice.cod_elp and rs.cod_anu = ice.cod_anu " +
					 " and rs.cod_ses = '2' and rs.cod_adm = '1' ) ";
		// from tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			from += " , apogee.etape e ";
		// from rsultats Juin		
		if (TEM_RESJ != null && TEM_RESJ.equals("O"))
			from += " , apogee.resultat_elp rj ";
		// where gnral
		String where = "where ice.cod_elp = ? " + 
						" and ice.cod_anu = ? " +
						" and ice.tem_prc_ice = 'N' and i.cod_ind = ice.cod_ind "; 
		// where tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			where += " and e.cod_etp = ice.cod_etp ";
		// where rsultats Juin
		if (TEM_RESJ != null && TEM_RESJ.equals("O"))
			where += " and rj.cod_ind = ice.cod_ind " +
					 " and rj.cod_elp = ice.cod_elp and rj.cod_anu = ice.cod_anu " +
					 " and rj.cod_ses <= '1' and rj.cod_adm = '1' ";
		// ordre de tri
		String order = "order by i.lib_nom_pat_ind,i.lib_pr1_ind,i.date_nai_ind";
		//log("requete sql : " + select + from + where + order);
		qry.setSql(select + from + where + order); 
		qry.getStmt().setString(1, id);
		qry.getStmt().setString(2, annee);
		qry.select();
	}
		
	/**
	 * 
	 * init appel  la suite de la slection d'un tudiant dans la liste rsultat du servant RechercheApogee 
	 * @param ChannelRuntimeData rd 
	 *
	 */
	public Boolean dossierEtu(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd); 
		owner.setCod_ind(this.runtimeData.getParameter("cod_ind"));
		owner.setLoginEtu(this.runtimeData.getParameter("login"));
		// on redirige vers le servant MonDossierWeb
		owner.redirect(rd,"servantMonDossierWebListe");
		return Boolean.FALSE;
	}
	
	/**
	 * @return Returns the msgErreur.
	 */
	public String getErreur() {
		return erreur;
	}
	
	/**
	 * @param msgErreur The msgErreur to set.
	 */
	public void setErreur(String erreur) {
		this.erreur = erreur;
	}
	
}
