package org.esupportail.portal.channels.gestion.CMonDossierWebEns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.IMimeResponse;

/**
 * ListeCSV<br>
 * <br>
 * Cette action prend en charge le tlchargement de la liste des tudiants au format CSV<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 * 
 */
public class ListeCSV extends Liste implements IMimeResponse {

	// log
	private static final Log log = LogFactory.getLog(ListeCSV.class);
	// Classe principale de la channel
	private CMonDossierWebEns owner;
		
	/**
	 * Constructeur
	 * @param main
	 */
	public ListeCSV(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
	}
	
	/**
	 * Retourne le type MIME du document
	 * @return Le type MIME
	 */
	public String getContentType() {
		return "application/octet-stream";
	}

	/**
	 * Retourne un InputStream correspondant au fichier  tlcharger
	 * @return Le flux de donnes
	 */
	public InputStream getInputStream() throws IOException {
		return null; // construction du fichier  la vole sinon retourner un InputStream valide vers un fichier
	}

	/**
	 * Mthode qui construit le flux csv
	 * @param out Un OutputStream vers le navigateur du client
	 */
	public void downloadData(OutputStream out) throws IOException {
		String csv = null;
		// on rcupre les tmoins 'Rsultat de juin/septembre' et 'Etape d'appartenance' 		 
		TEM_RESJ = runtimeData.getParameter("TEM_RESJ");
		TEM_RESS = runtimeData.getParameter("TEM_RESS");
		TEM_ETP = runtimeData.getParameter("TEM_ETP");
		try {
			// liste des tudiants au format csv 
			csv = getListe(runtimeData.getParameter("id"),owner.getAnnee(),owner.getNiveau()).toString();
		} catch (FrameWorkException e) {
			log.error("ListeCSV::downloadData : " + e);
		}
		out.write(csv.getBytes());
		out.close();
	}
	
	/**
	 * @param id identifiant du niveau
	 * @param annee anne slectionne
	 * @param niveau niveau pour lequel on veut la liste (Etapes ou Elements)
	 * @return retourne la liste des tudiants sous forme de flux csv 
	 * 
	 */
	public StringBuffer getListe(String id, String annee, String niveau) throws FrameWorkException {
		StringBuffer res = new StringBuffer();
		Query qry = null;
		boolean error= false;
		
		// construction de l'en-tte des colonnes 
		res.append("Dossier;Nom;Pr\u00E9nom;Naissance");
		// tmoin IAE uniquement pour les tapes
		if (niveau != null && niveau.equals("etapes"))
			res.append(";IAE?");
		if (TEM_ETP != null && TEM_ETP.equals("O")) {
			res.append(";Code;Version;Etape");
		}
		if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
			res.append(";Note1");
			if (niveau != null && niveau.equals("etapes"))
				res.append(";Rsultat1");
		}	
		if (TEM_RESS != null && TEM_RESS.equals("O")) {
			res.append(";Note2");
			if (niveau != null && niveau.equals("etapes"))
				res.append(";Rsultat2");
		}	
		res.append("\r\n");
		try {
			qry = Config.getInstance().getConnexionDefault();
			if (niveau != null && niveau.equals("etapes"))
				selectListeEtape(qry,id,annee);
			else if (niveau != null && niveau.equals("elements"))
				selectListeElement(qry,id,annee);
			if (qry.getRs() != null) {
				while (qry.getRs().next()){
					res.append(qry.getRs().getString("cod_etu")).append(";");
					res.append(qry.getRs().getString("lib_nom_pat_ind")).append(";");
					res.append(qry.getRs().getString("lib_pr1_ind")).append(";");
					res.append(qry.getRs().getString("DATE_NAI_IND")).append(";");
					if (niveau != null && niveau.equals("etapes"))
						res.append(qry.getRs().getString("IAE")).append(";");
					if (TEM_ETP != null && TEM_ETP.equals("O")) { 
						res.append(qry.getRs().getString("cod_etp")).append(";");
						res.append(qry.getRs().getString("cod_vrs_vet")).append(";");
						res.append(qry.getRs().getString("lib_etp")).append(";");
					}
					if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
						res.append("\"").append(qry.getRs().getString("NOTEJ").replace(',','.')).append("\";");
						if (niveau != null && niveau.equals("etapes"))
							res.append(qry.getRs().getString("RESJ")).append(";");
					}
					if (TEM_RESS != null && TEM_RESS.equals("O")) {
						res.append("\"").append(qry.getRs().getString("NOTES").replace(',','.')).append("\";");
						if (niveau != null && niveau.equals("etapes"))
							res.append(qry.getRs().getString("RESS")).append(";");
					}
					res.append("\r\n");
				}
			}
		}
		catch (SQLException e) {
			log.error("ListeCSV::getListe() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("Liste::getListe() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return res;
	}

	/**
	 * Retourne le nom du fichier
	 * @return Le nom du fichier
	 */
	public String getName() {
		return runtimeData.getParameter("id")+".csv"; // nom du fichier  tlcharger
	}

	/**
	 * Retourne la liste des headers HTTP  envoyer au navigateur
	 * @return La liste des headers
	 */
	public Map getHeaders() {
		  HashMap map = new HashMap(); 
          map.put("Content-disposition", "attachment; filename=" + getName()); 
          return map;

	}

	/**
	 * Mthode appele si une erreur se produit durant le tlchargement
	 * @param e L'exception leve
	 */
	public void reportDownloadError(Exception e) {
		log.error("ListeCSV::reportingDownloadError() : " + e);
		
	}
	
}
