package org.esupportail.portal.channels.gestion.CMonDossierWebEns.Nancy2;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.database.Query;
import org.esupportail.portal.channels.gestion.CRechercheApogee.Niveau;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.CMonDossierWebEns;
import org.jasig.portal.utils.XMLEscaper;

/**
 * <p>Liste</p>
 * <p>Sub-channel pour l'dition de liste d'tudiants  (gestion des adresses mail Nancy2)</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class Liste extends org.esupportail.portal.channels.gestion.CMonDossierWebEns.Liste {

	// log
	private static final Log log = LogFactory.getLog(Liste.class);
	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// Niveau slectionn lors de la recherche Apogee
	private Niveau niveau;
	
	/**
	 * Constructeur
	 * @param main
	 */
	public Liste(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns) main;
	}
		
	/**
	 * @param id identifiant du niveau
	 * @param annee anne slectionne
	 * @return retourne la liste des tudiants sous forme de flux xml 
	 * 
	 */
	public StringBuffer getListe(String id, String annee) throws FrameWorkException {
		StringBuffer res = new StringBuffer("<liste>");
		Query qry = null;
		boolean error= false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			//qry = Config.getInstance().getConnexion("default");
			if (owner.getNiveau() != null && owner.getNiveau().equals("etapes"))
				selectListeEtape(qry,id,annee);
			else if (owner.getNiveau() != null && owner.getNiveau().equals("elements"))
				selectListeElement(qry,id,annee);
			if (qry.getRs() != null) {
				while (qry.getRs().next()){
					res.append("<etudiant dossier=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_etu"))).append("\" ");
					res.append("nom=\"").append(XMLEscaper.escape(qry.getRs().getString("lib_nom_pat_ind"))).append("\" ");
					res.append("cod_ind=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_ind"))).append("\" ");
					res.append("login=\"").append(XMLEscaper.escape(qry.getRs().getString("nom_login"))).append("\" ");
					res.append("prenom=\"").append(XMLEscaper.escape(qry.getRs().getString("lib_pr1_ind"))).append("\" ");
					res.append("naissance=\"").append(XMLEscaper.escape(qry.getRs().getString("DATE_NAI_IND"))).append("\" ");
					res.append("mail=\"");
					if (Config.getInstance().getExtMail() != null && !Config.getInstance().getExtMail().equals("") 
							&& getAnnee().equals(anneeEnCours))
						res.append(XMLEscaper.escape(qry.getRs().getString("nom_login"))+Config.getInstance().getExtMail());
					res.append("\" ");
					if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
						res.append("note1=\"").append(XMLEscaper.escape(qry.getRs().getString("NOTEJ"))).append("\" ");
						if (qry.getRs().getString("RESJ") != null && !qry.getRs().getString("RESJ").equals(" "))
							res.append("resultat1=\"").append(XMLEscaper.escape(qry.getRs().getString("RESJ"))).append("\" ");							
					}
					if (TEM_RESS != null && TEM_RESS.equals("O")) {
						res.append("note2=\"").append(XMLEscaper.escape(qry.getRs().getString("NOTES"))).append("\" ");
						if (qry.getRs().getString("RESS") != null && !qry.getRs().getString("RESS").equals(" "))
							res.append("resultat2=\"").append(XMLEscaper.escape(qry.getRs().getString("RESS"))).append("\" ");
					}
					if (owner.getNiveau() != null && owner.getNiveau().equals("etapes"))
						res.append("IAE=\"").append(XMLEscaper.escape(qry.getRs().getString("IAE"))).append("\" ");
					if (TEM_ETP != null && TEM_ETP.equals("O")) { 
						res.append("cod_etp=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_etp"))).append("\" ");
						res.append("cod_vrs_vet=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_vrs_vet"))).append("\" ");
						res.append("lib_etp=\"").append(XMLEscaper.escape(qry.getRs().getString("lib_etp"))).append("\" ");
					}	
					res.append("/>");
				}
				// si l'action correspondant au servant mailTo est prsent dans le fichier de config, on l'utilise pour les envois de mail
				if (owner.getAction("sendMail") != null)
					this.getXSLParameter().put("servantMailTo","1");
			}
		}
		catch (SQLException e) {
			log.error("Liste::getListe() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("Liste::getListe() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		res.append("</liste>");
		return res;
	}
	
	/**
	 * 
	 * Construction et excution du select pour rcuprer la liste des tudiants d'une tape
	 * @param Query query
	 * @param id identifiant du niveau
	 * @param annee anne slectionne
	 * @throws SQLException
	 */
	public void selectListeEtape(Query qry, String id, String annee) throws SQLException {
		// select gnral
		String select = "select i.cod_ind,i.cod_etu, i.lib_nom_pat_ind, i.lib_pr1_ind," +
						"to_char(i.date_nai_ind,'DD/MM/YYYY') \"DATE_NAI_IND\", " + 
						"m.nom_login,  " + 
						"decode(rj.tem_iae_ko_vet,0,'O','N') \"IAE\" " ;
		// select tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			select += " ,rj.cod_etp,rj.cod_vrs_vet,e.lib_etp "; 
		// select rsultats Juin
		if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
			select += ", nvl(decode(to_char(rj.not_vet),null,rj.not_sub_vet,to_char(rj.not_vet)),' ') \"NOTEJ\" " + 
					  ", nvl(rj.cod_tre,' ') \"RESJ\" ";   		
		}	
		// select rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O")) {
			select += ", nvl(decode(to_char(rs.not_vet),null,rs.not_sub_vet,to_char(rs.not_vet)),' ') \"NOTES\" " +
					  ", nvl(rs.cod_tre,' ') \"RESS\" ";    		
		}	
		// from gnral
		String from = "from apogee.individu i left outer join apogee.mel_login m on " +	
					  "(m.cod_nne_ind = i.cod_nne_ind and m.cod_cle_nne_ind = i.cod_cle_nne_ind), " +
					  "apogee.resultat_vet rj ";
		// from rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O"))
			from += " left outer join apogee.resultat_vet rs on ( rs.cod_ind = rj.cod_ind " + 
					" and rs.tem_iae_ko_vet in ('0','2') " +
					" and rs.cod_etp = rj.cod_etp " +
					" and rs.cod_vrs_vet = rj.cod_vrs_vet " +
					" and rs.cod_anu = rj.cod_anu " +
					" and rs.cod_ses = '2' " + 
					"and rs.cod_adm = '1') ";
		// from tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			from += " , apogee.etape e ";
		// where gnral
		String where = "where rj.tem_iae_ko_vet in ('0','2') " +
						" and rj.cod_etp = ? " +
						" and rj.cod_anu = ? " +
						" and rj.cod_ses in ('0','1') and rj.cod_adm = '1' " +
						" and i.cod_ind = rj.cod_ind ";
		// where tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			where += " and e.cod_etp = rj.cod_etp ";
		// ordre de tri
		String order = "order by i.lib_nom_pat_ind,i.lib_pr1_ind,i.date_nai_ind ";
		//log("requete : "+ select + from + where + order);
		qry.setSql(select + from + where + order); 
		qry.getStmt().setString(1, id);
		qry.getStmt().setString(2, annee);
		qry.select();
	}
	
	/**
	 * 
	 * Construction et excution du select pour rcuprer la liste des tudiants d'un lment
	 * @param Query query
	 * @param id identifiant du niveau
	 * @param annee anne slectionne
	 * @throws SQLException
	 */
	public void selectListeElement(Query qry, String id, String annee) throws SQLException {
		// select gnral
		String select = "select i.cod_ind,i.cod_etu, i.lib_nom_pat_ind, i.lib_pr1_ind," +
						"to_char(i.date_nai_ind,'DD/MM/YYYY') \"DATE_NAI_IND\", " + 
						"m.nom_login  " ;
		// select tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			select += " ,ice.cod_etp,ice.cod_vrs_vet,e.lib_etp ";
		// select rsultats Juin
		if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
			select += ", nvl(decode(to_char(rj.not_elp),null,rj.not_sub_elp,to_char(rj.not_elp)),' ') \"NOTEJ\"" + 
					  ", nvl(rj.cod_tre,' ') \"RESJ\" ";   		
		}	
		// select rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O")) {
			select += ", nvl(decode(to_char(rs.not_elp),null,rs.not_sub_elp,to_char(rs.not_elp)),' ') \"NOTES\"" + 
					  ", nvl(rs.cod_tre,' ') \"RESS\" ";   		
		}	
		// from gnral
		String from = "from apogee.individu i left outer join apogee.mel_login m on " +	
		  			  "(m.cod_nne_ind = i.cod_nne_ind and m.cod_cle_nne_ind = i.cod_cle_nne_ind), apogee.ind_contrat_elp ice " ;
		// from rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O"))
			from += " left outer join apogee.resultat_elp rs on ( rs.cod_ind = ice.cod_ind " +
					 " and rs.cod_elp = ice.cod_elp and rs.cod_anu = ice.cod_anu " +
					 " and rs.cod_ses = '2' and rs.cod_adm = '1' ) ";
		// from tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			from += " , apogee.etape e ";
		// from rsultats Juin		
		if (TEM_RESJ != null && TEM_RESJ.equals("O"))
			from += " , apogee.resultat_elp rj ";
		// where gnral
		String where = "where ice.cod_elp = ? " + 
						" and ice.cod_anu = ? " +
						" and ice.tem_prc_ice = 'N' and i.cod_ind = ice.cod_ind "; 
		// where tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			where += " and e.cod_etp = ice.cod_etp ";
		// where rsultats Juin
		if (TEM_RESJ != null && TEM_RESJ.equals("O"))
			where += " and rj.cod_ind = ice.cod_ind " +
					 " and rj.cod_elp = ice.cod_elp and rj.cod_anu = ice.cod_anu " +
					 " and rj.cod_ses <= '1' and rj.cod_adm = '1' ";
		// ordre de tri
		String order = "order by i.lib_nom_pat_ind,i.lib_pr1_ind,i.date_nai_ind";
		//log("requete sql : " + select + from + where + order);
		qry.setSql(select + from + where + order); 
		qry.getStmt().setString(1, id);
		qry.getStmt().setString(2, annee);
		qry.select();
	}

}
