package org.esupportail.portal.channels.gestion.CMonDossierWebEns.Nancy2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.CMonDossierWebEns;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.PortalException;
// gnration xls
import jxl.*; 
import jxl.write.*;
import jxl.write.biff.RowsExceededException;

// C:\esupdev\excel\jexcelapi\tutorial.html
// C:\esupdev\excel\jexcelapi\docs\index.html
// http://jexcelapi.sourceforge.net/

/**
 * ListeXLS<br>
 * <br>
 * Cette action prend en charge le tlchargement de la liste des tudiants au format XLS (gestion de l'adresse mail Nancy2)<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 * 
 */
public class ListeXLS extends Liste implements IMimeResponse {

	// log
	private static final Log log = LogFactory.getLog(ListeXLS.class);
	// Classe principale de la channel
	private CMonDossierWebEns owner;
		
	/**
	 * Constructeur
	 * @param main
	 */
	public ListeXLS(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns) main;
	}
	
	/**
	 * Retourne le type MIME du document
	 * @return Le type MIME
	 */
	public String getContentType() {
		return "application/octet-stream";
	}

	/**
	 * Retourne un InputStream correspondant au fichier  tlcharger
	 * @return Le flux de donnes
	 */
	public InputStream getInputStream() throws IOException {
		return null; // construction du fichier  la vole sinon retourner un InputStream valide vers un fichier
	}

	/**
	 * Mthode qui construit le flux csv
	 * @param out Un OutputStream vers le navigateur du client
	 */
	public void downloadData(OutputStream out) throws IOException {
		WritableWorkbook workbook;
		
		// on rcupre les tmoins 'Rsultat de juin/septembre' et 'Etape d'appartenance' 		 
		TEM_RESJ = runtimeData.getParameter("TEM_RESJ");
		TEM_RESS = runtimeData.getParameter("TEM_RESS");
		TEM_ETP = runtimeData.getParameter("TEM_ETP");
		
		try {
			workbook = Workbook.createWorkbook(out);
			this.getListe(workbook, runtimeData.getParameter("id"),owner.getAnnee(),owner.getNiveau());
		} catch (IOException e) {
			// TODO Auto-generated catch block
			log.error("ListeXLS::downloadData : " + e);
		} catch (RowsExceededException e) {
			// TODO Auto-generated catch block
			log.error("ListeXLS::downloadData : " + e);
		} catch (WriteException e) {
			// TODO Auto-generated catch block
			log.error("ListeXLS::downloadData : " + e);
		} catch (FrameWorkException e) {
			log.error("ListeXLS::downloadData : " + e);
		} catch (PortalException e) {
			// TODO Bloc catch auto-gnr
			log.error("ListeXLS::downloadData : " + e);
		}
	}
	
	/**
	 * @param wb workBook Excel
	 * @param id identifiant du niveau
	 * @param annee anne slectionne
	 * @param niveau niveau pour lequel on veut la liste (Etapes ou Elements)
	 * @return retourne la liste des tudiants sous forme de flux csv 
	 * @throws WriteException
	 * @throws RowsExceededException
	 * @throws IOException
	 * @throws PortalException 
	 * 
	 */
	public void getListe(WritableWorkbook wb, String id, String annee, String niveau) throws FrameWorkException, RowsExceededException, WriteException, IOException, PortalException {
		
		Query qry = null;
		boolean error= false;
		
		WritableSheet sheet = wb.createSheet("First Sheet", 0);
		// en-tte
		WritableFont arial10font = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
		WritableCellFormat arial10format = new WritableCellFormat (arial10font);
		Label label = new Label(0, 0, "Dossier", arial10format); 
		sheet.addCell(label);
		label = new Label(1, 0, "Nom", arial10format);
		sheet.addCell(label);
		label = new Label(2, 0, "Pr\u00E9nom", arial10format);
		sheet.addCell(label);
		label = new Label(3, 0, "Naissance", arial10format);
		sheet.addCell(label);
		// tmoin colonne
		int col = 4;
		if (Config.getInstance().getExtMail() != null && !Config.getInstance().getExtMail().equals("") && getAnnee().equals(anneeEnCours)) {
			label = new Label(col++, 0, "Messagerie", arial10format);
			sheet.addCell(label); 
		}
		// tmoin IAE uniquement pour les tapes
		if (niveau != null && niveau.equals("etapes")) {
			label = new Label(col++, 0, "IAE?", arial10format);
			sheet.addCell(label);
		}	
		if (TEM_ETP != null && TEM_ETP.equals("O")) {
			label = new Label(col++, 0, "Code", arial10format);
			sheet.addCell(label);
			label = new Label(col++, 0, "Version", arial10format);
			sheet.addCell(label);
			label = new Label(col++, 0, "Etape", arial10format);		
			sheet.addCell(label);
		}
		if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
			label = new Label(col++, 0, "Note1", arial10format);		
			sheet.addCell(label);
			if (niveau != null && niveau.equals("etapes")) {
				label = new Label(col++, 0, "Rsultat1", arial10format);		
				sheet.addCell(label);
			}	
		}	
		if (TEM_RESS != null && TEM_RESS.equals("O")) {
			label = new Label(col++, 0, "Note2", arial10format);
			sheet.addCell(label);	
			if (niveau != null && niveau.equals("etapes")) {
				label = new Label(col++, 0, "Resultat2", arial10format);
				sheet.addCell(label);
			}	
		}
		// Liste des tudiants
		try {
			qry = org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config.getInstance().getConnexionDefault();
			if (niveau != null && niveau.equals("etapes"))
				selectListeEtape(qry,id,annee);
			else if (niveau != null && niveau.equals("elements"))
				selectListeElement(qry,id,annee);
			if (qry.getRs() != null) {
				int row = 1;
				while (qry.getRs().next()){
					col = 0;
					label = new Label(col++, row, qry.getRs().getString("cod_etu"));
					sheet.addCell(label);
					label = new Label(col++, row, qry.getRs().getString("lib_nom_pat_ind"));
					sheet.addCell(label);
					label = new Label(col++, row, qry.getRs().getString("lib_pr1_ind"));
					sheet.addCell(label);
					label = new Label(col++, row, qry.getRs().getString("DATE_NAI_IND"));
					sheet.addCell(label);
					if (Config.getInstance().getExtMail() != null && !Config.getInstance().getExtMail().equals("") && getAnnee().equals(anneeEnCours)) {
						label = new Label(col++, row, qry.getRs().getString("nom_login")+Config.getInstance().getExtMail());
						sheet.addCell(label);
					}	
					if (niveau != null && niveau.equals("etapes")) {
						label = new Label(col++, row, qry.getRs().getString("IAE"));
						sheet.addCell(label);
					}
					if (TEM_ETP != null && TEM_ETP.equals("O")) { 
						label = new Label(col++, row, qry.getRs().getString("cod_etp"));
						sheet.addCell(label);
						label = new Label(col++, row, qry.getRs().getString("cod_vrs_vet"));
						sheet.addCell(label);
						label = new Label(col++, row, qry.getRs().getString("lib_etp"));
						sheet.addCell(label);
					}
					if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
						label = new Label(col++, row, qry.getRs().getString("NOTEJ").replace(',','.'));
						sheet.addCell(label);
						if (niveau != null && niveau.equals("etapes")) {
							label = new Label(col++, row, qry.getRs().getString("RESJ"));
							sheet.addCell(label);
						}	
					}
					if (TEM_RESS != null && TEM_RESS.equals("O")) {
						label = new Label(col++, row, qry.getRs().getString("NOTES").replace(',','.'));
						sheet.addCell(label);
						if (niveau != null && niveau.equals("etapes")) {
							label = new Label(col++, row, qry.getRs().getString("RESS"));
							sheet.addCell(label);
						}	
					}
					row++;
				}
			}
		}
		catch (SQLException e) {
			log.error("ListeXLS::getListe() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("ListeXLS::getListe() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		// All sheets and cells added. Now write out the workbook 
		wb.write(); 
		wb.close(); 
	}
	
	/**
	 * Retourne le nom du fichier
	 * @return Le nom du fichier
	 */
	public String getName() {
		return runtimeData.getParameter("id")+".xls"; // nom du fichier  tlcharger
	}

	/**
	 * Retourne la liste des headers HTTP  envoyer au navigateur
	 * @return La liste des headers
	 */
	public Map getHeaders() {
		  HashMap map = new HashMap(); 
          map.put("Content-disposition", "attachment; filename=" + getName()); 
          return map;

	}

	/**
	 * Mthode appele si une erreur se produit durant le tlchargement
	 * @param e L'exception leve
	 */
	public void reportDownloadError(Exception e) {
		log.error("ListeXLS::reportingDownloadError() : " + e);
		
	}
	
}
