package org.esupportail.portal.channels.gestion.CMonDossierWebEns;

import java.sql.SQLException;

import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.connectors.ApogeeConnector;
import org.esupportail.portal.utils.channels.plugins.*;
import org.esupportail.portal.utils.connectors.ConnectorException;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>RenderStatic</p>
 * <p>Sub-channel pour les pages statiques de la channel CMonDossierWeb</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 *
 */
public class RenderStatic extends SubChannel {

	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// Objet Personne slectionn dans le servant Annuaire
	private Personne pers;
	// log
	private static final Log log = LogFactory.getLog(RenderStatic.class);
		
	/**
	 * Constructeur
	 * @param main
	 */
	public RenderStatic(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
	}

	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd); 
		if (Config.getInstance().getAdrContact() != null) 
			this.getXSLParameter().put("contact",Config.getInstance().getAdrContact());
		// si l'action correspondant au servant mailTo est prsent dans le fichier de config, on l'utilise pour les envois de mail
		if (owner.getAction("sendMail") != null) {
			this.getXSLParameter().put("servantMailTo","1");
		}
		// si 'autre dossier' slectionn
		if (runtimeData.getParameter("autre") != null) {
			owner.redirect(runtimeData,runtimeData.getParameter("autre"));
			return Boolean.FALSE;
		}
		
		return res;
	}
		
	/**
	 * init appel au retour du servant Annuaire
	 * 
	 * @param rd
	 * @return
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean rechCOD_IND(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd); 
	
		// rcupration du login d'une personne 
		String pers_id = null;
		if (owner.getServantResults() != null && owner.getServantResults().length >= 1) {
			pers = (Personne)(owner.getServantResults()[0]);
			pers_id = pers.getIdentifiant();
		}
		
		if (pers_id != null) {
			owner.setCod_ind(getCodInd(pers_id));
			owner.setLoginEtu(pers_id);
			// on redirige vers le servant MonDossierWeb si on a pu trouver le cod_ind
			if (owner.getCod_ind() == null)
				Message.message(mainChannel, rd, new MessageBean("Erreur : impossible de trouver cet \u00E9tudiant dans APOGEE",Message.ERROR), "default"); 
			else
			  owner.redirect(rd,"servantMonDossierWeb");
		}	
		else if (runtimeData.getParameter("initRechApo") != null && runtimeData.getParameter("initRechApo").equals("1")) {
			owner.redirect(rd,"selectListe");
		}
		else 
			owner.redirect(rd,"default");

		return Boolean.FALSE;
	}	
	
	/**
	 * init appel apres la recherche par num Etudiant
	 * 
	 * @param rd
	 * @return
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean rechNumEtu(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		int cod_etu = 0;
		if (rd.getParameter("cod_etu") != null) {
			// Rcupration du cod_ind  partir de cod_etu (numro tudiant)
			try {
				cod_etu = new Integer(rd.getParameter("cod_etu")).intValue();
			}
			catch(NumberFormatException e) {
				this.getXSLParameter().put("erreur","1");
			}
			owner.setCod_ind(getCodIndFromCodEtu(cod_etu));
			if (owner.getCod_ind() == null) 
				this.getXSLParameter().put("erreur","1");
			else {
				// Rcupration du login 
				owner.setLoginEtu(geLoginFromCodInd(owner.getCod_ind()));
				owner.redirect(rd,"servantMonDossierWebCodEtu");
			}
		}
		return Boolean.TRUE;
	}
	
	/**
	 * 
	 * @param cod_etu
	 * @return le cod_ind
	 * @throws FrameWorkException
	 */
	public String getCodIndFromCodEtu(int cod_etu) throws FrameWorkException {
		String codInf = null;
		Query qry = null;
		boolean error = false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select cod_ind from apogee.individu where cod_etu = ?");
			qry.getStmt().setInt(1, cod_etu);				
			qry.select();			   
			while (qry.getRs().next()){
				codInf = qry.getRs().getString("cod_ind");
			}
		}
		catch (SQLException e) {
			log.error("RenderStatic::getCodIndFromCodEtu() : Erreur SQL " + e);
			error = true;
			throw new FrameWorkException();
		}
		catch (Exception e) {
			log.error("RenderStatic::getCodIndFromCodEtu() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return codInf;
	}
	
	/**
	 * 
	 * @param cod_ind
	 * @return le login de la personne
	 * @todo A faire en utilisant le connecteur Apogee
	 * @throws FrameWorkException
	 */
	public String geLoginFromCodInd(String cod_ind) throws FrameWorkException {
		String login = null;
		Query qry = null;
		boolean error = false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select NOM_LOGIN from apogee.MEL_LOGIN where COD_IND = ?");
			qry.getStmt().setString(1, cod_ind);				
			qry.select();			   
			while (qry.getRs().next()){
				login = qry.getRs().getString("NOM_LOGIN");
			}
		}
		catch (SQLException e) {
			log.error("RenderStatic::geLoginFromCodInd() : Erreur SQL " + e);
			error = true;
			throw new FrameWorkException();
		}
		catch (Exception e) {
			log.error("RenderStatic::geLoginFromCodInd() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return login;	
	}
	
	
	/**
	 * Rcupration du cod_ind 
	 * 
	 */
	public String getCodInd(String pers_id) {
		String cod_ind = null;
		// on rcupre le cod_ind via le connecteur Apogee
		try {
			cod_ind = ApogeeConnector.getCOD_INDFromLogin(pers_id);
		} 
		catch (ConnectorException e1) {
			return null;
		}
		return cod_ind;
	}
	
}
