<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">
   </xsl:param>

   <xsl:param name="mediaPath" />

   <xsl:param name="prefForm">
   </xsl:param>

   <xsl:param name="servantMailTo">none</xsl:param>

   <xsl:param name="contact">none</xsl:param>

   <xsl:template match="/xml">
      <br />

      <br />

      <table border="0" width="100%">
         <tr>
            <td class="uportal-channel-text" align="justify" nowrap="nowrap">Ce canal regroupe l'ensemble des fonctionnalits qui ont t dveloppes spcialement pour les enseignants.</td>
			<xsl:choose>
			<xsl:when test="$contact!='none'">
			<td width="5%"></td>
            <td class="uportal-channel-subtitle" nowrap="true" align="right" width="100%">
               <xsl:choose>
                  <xsl:when test="$servantMailTo=1">
                     <a href="{$baseActionURL}?action=sendMail&amp;dest=scolarite">Nous contacter</a>
                  </xsl:when>

                  <xsl:otherwise>
                     <a href="mailto:{$contact}">Nous contacter</a>
                  </xsl:otherwise>
               </xsl:choose>
            </td>
             </xsl:when>
             
            </xsl:choose>
         </tr>
      </table>

      <br />

      <table>
         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action=servantAnnuaire">
                  <img src="{$mediaPath}/folder.gif" border="0" alt="Dossier Etudiant" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" align="justify">
               <a href="{$baseActionURL}?action=servantAnnuaire">Le dossier tudiant</a>
            </td>
         </tr>

         <tr>
            <td></td>

            <td class="uportal-channel-text" align="justify">   
            Il vous permettra d'accder aux informations individuelles d'un tudiant concernant son tat civil, ses inscriptions, ses rsultats. Chaque tudiant peut accder au mme type d'information en ce qui le concerne.<br/><br/> 
            Pour ce faire, vous pouvez soit <a href="{$baseActionURL}?action=servantAnnuaire"><b>rechercher l'tudiant dans l'annuaire</b></a>, soit <a href="{$baseActionURL}?action=rechNumEtu"><b>saisir directement son numro tudiant</b></a>.
            </td>
         </tr>
         <tr>
            <td></td>

            <td class="uportal-channel-text" align="justify">
            <br/>    
            <b>Remarques : </b>
            <ul>
                <li>L'annuaire ne contient que les tudiants actuellement inscrits pour l'anne universitaire en cours.</li>
                <li>La recherche par numro tudiant permet de retrouver une personne quelle que soit son anne d'inscription. 
                Si vous ne connaissez pas ce numro mais sa dernire formation suivie, vous pouvez retrouver l'tudiant en passant par la partie "Liste d'inscrits aux diplmes...".
                </li>
            </ul>
            </td>
         </tr>
      </table>

      <br />

      <table>
         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action=selectListe">
                  <img src="{$mediaPath}/group.gif" border="0" alt="Liste d'inscrits" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" align="justify">
               <a href="{$baseActionURL}?action=selectListe&amp;CAnnuaireServantFinished&amp;initRechApo=1&amp;monDossierWebFinished">La liste d'inscrits aux diplmes ou aux enseignements</a>
            </td>
         </tr>

         <tr>
            <td></td>

            <td class="uportal-channel-text" align="justify">Elle vous propose de constituer des listes d'tudiants par lment pdagogique. Les listes pourront ensuite tre rcupres sous Excel ou d'autres logiciels de bureautique.</td>
         </tr>
      </table>
   </xsl:template>
</xsl:stylesheet>

