<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />
   <xsl:param name="baseActionURL" />
   <xsl:param name="prefForm" />
   <xsl:param name="mediaPath" />
   <xsl:param name="baseDownloadURL" />
   <xsl:param name="idEtape" />
   <!-- diffrents tmoins de la selection de la liste passes en param a la liste csv -->
   <xsl:param name="TEM_RESJ" />
   <xsl:param name="TEM_RESS" />
   <xsl:param name="TEM_ETP" />
   
   	<xsl:template match="xml">
   	<br/>
   	<table cellspacing="0" cellpadding="5" width="100%" border="0">
         <tr>
            <td nowrap="true" class="uportal-channel-table-header">Inscrits</td>

            <td width="5%"></td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action=selectListe&amp;redirect=selectListe&amp;monDossierWebFinished">
                  <img src="{$mediaPath}/find.gif" border="0" alt="Nouvelle recherche" />
               </a>
            </td>

            <td class="uportal-label" nowrap="true">
               <a href="{$baseActionURL}?action=selectListe&amp;redirect=selectListe&amp;monDossierWebFinished">Nouvelle recherche</a>
            </td>

            <td width="5%"></td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action=default&amp;redirect=default&amp;monDossierWebFinished">
                  <img src="{$mediaPath}/back.gif" border="0" alt="Retour au sommaire" />
               </a>
            </td>

            <td class="uportal-label" nowrap="true">
               <a href="{$baseActionURL}?action=default&amp;redirect=default&amp;monDossierWebFinished">Retour au sommaire</a>
            </td>

            <td width="100%"></td>
         </tr>
      </table>
      
     <hr />
      
     <p class="uportal-channel-strong" align="justify">Attention : </p>
   	<p align="justify">
   	<ul class="uportal-channel-text">
   	<li>
	Les mails des tudiants sont valids  la date de l'extraction et pourront ne plus l'tre lors d'une utilisation ultrieure (l'tudiant aura pu rsilier son inscription par exemple). Dans ce cas, vous recevrez un message vous indiquant que l'adresse lectronique que vous utilisez est invalide.
   	</li>
   	<li>
   	La colonne IAE ? vous indique si l'tudiant a ralis une inscription administrative pour l'tape. Dans le cas contraire, il s'agit d'une dette ou d'un crdit. 
   	</li>
   	</ul>
   	</p>
   	 <xsl:call-template name="resultat"/>
   </xsl:template>
   	
     <xsl:template name="resultat">
     <xsl:if test="count(result) = 1">
     	<table cellspacing="0" cellpadding="3" border="0">
     	<tr class="uportal-background-semidark">
     	<td nowrap="true" class="uportal-channel-strong">Anne universitaire : </td>
     	<td class="uportal-text" nowrap="true"><xsl:value-of select="result/@annee" /></td>
     	<td>|</td>
     	<td nowrap="true" class="uportal-channel-strong">Libell : </td>
     	<td class="uportal-text" nowrap="true"><xsl:value-of select="result/@id" />/<xsl:value-of select="result/@vers" /></td>
     	<td class="uportal-text" nowrap="true"><xsl:value-of select="result/@lib" /></td>
     	<td>|</td>
     	<td nowrap="true" class="uportal-channel-strong">Nombre d'inscrits : </td>
     	<td class="uportal-text" nowrap="true"><xsl:value-of select="count(liste/etudiant)" /></td>
     	<td>|</td>
     	<!--<td nowrap="true" class="uportal-channel-strong"><a href="{$baseDownloadURL}?action=listeCSV&amp;id={$idEtape}&amp;TEM_RESJ={$TEM_RESJ}&amp;TEM_RESS={$TEM_RESS}&amp;TEM_ETP={$TEM_ETP}">Fichier Excel</a></td>-->
     	<td nowrap="true" class="uportal-channel-strong">
        	<a href="{$baseDownloadURL}?action=listeXLS&amp;id={$idEtape}&amp;TEM_RESJ={$TEM_RESJ}&amp;TEM_RESS={$TEM_RESS}&amp;TEM_ETP={$TEM_ETP}">Fichier Excel</a>
        </td>	
     	<td nowrap="true" class="uportal-channel-strong" valign="absmiddle"><a href="{$baseDownloadURL}?action=listeXLS&amp;id={$idEtape}&amp;TEM_RESJ={$TEM_RESJ}&amp;TEM_RESS={$TEM_RESS}&amp;TEM_ETP={$TEM_ETP}"><img src="{$mediaPath}docxls.gif" border="0" alt="Fichier Excel"/></a></td>
     	</tr>
     	</table>    	
     
		<br/>
     
      <xsl:choose>
      	<xsl:when test="count(liste/etudiant)=0">
      		<table cellpadding="5" cellspacing="0" border="0">
	  			<tr>
					<td class="uportal-text">
            			Pas de liste disponible
            		</td>
				</tr>	
			</table>		
		</xsl:when>
		<xsl:otherwise>
               <table cellpadding="5" cellspacing="0" border="0">
               <tr>
               	  <td>&#160;</td>	
                  <td class="uportal-channel-strong">
                     Dossier
                  </td>
                  <td class="uportal-channel-strong">
                     Nom
                  </td>

                  <td class="uportal-channel-strong">
                     Prnom
                  </td>

                  <td class="uportal-channel-strong">
                     Naissance
                  </td>

                  <!--<td class="uportal-channel-strong">
                     Messagerie
                  </td>-->
                  <xsl:if test="count(liste/etudiant/@IAE) > 0">
                  	<td class="uportal-channel-strong">
                  		IAE ?
                  	</td>
                  </xsl:if>
                  <xsl:if test="count(liste/etudiant/@cod_etp) > 0">
                  	<td class="uportal-channel-strong">
                  		Code
                  	</td>
                  	<td class="uportal-channel-strong">
                  		Version
                  	</td>
                  	<td class="uportal-channel-strong">
                  		Etape
                  	</td>
                  </xsl:if>	
                  <xsl:if test="count(liste/etudiant/@note1) > 0">
                  	<td class="uportal-channel-strong">
                  		Note1
                  	</td>
                  	<xsl:if test="count(liste/etudiant/@resultat1) > 0">
                  	<td class="uportal-channel-strong">
                  		Rsultat1
                  	</td>
                  	</xsl:if>
                  </xsl:if>	
                  <xsl:if test="count(liste/etudiant/@note2) > 0">
                  	<td class="uportal-channel-strong">
                  		Note2
                  	</td>
                    <xsl:if test="count(liste/etudiant/@resultat2) > 0">
                  	<td class="uportal-channel-strong">
                  		Rsultat2
                  	</td>
                  	</xsl:if>
                  </xsl:if>	
               </tr>
               <xsl:for-each select="liste/etudiant">
                  <tr onMouseOver="javascript:this.className='uportal-background-highlight'" onMouseOut="javascript:this.className='uportal-background-content'">
                     <td valign="absmiddle">
                     <a href="{$baseActionURL}?action=dossierEtuListe&amp;cod_ind={@cod_ind}&amp;login={@login}&amp;redirect=dossierEtuListe&amp;monDossierWebFinished">
                     <img alt="Dossier Etudiant" border="0" src="{$mediaPath}/folderopen.gif" />
                     </a>
                     </td>
                     <td class="uportal-text">
                     <a href="{$baseActionURL}?action=dossierEtuListe&amp;cod_ind={@cod_ind}&amp;login={@login}&amp;redirect=dossierEtuListe&amp;monDossierWebFinished">
                        <xsl:value-of select="@dossier" />
                        </a>
                     </td>
                     <td class="uportal-text">
                        <xsl:value-of select="@nom" />
                     </td>

                     <td class="uportal-text">
                        <xsl:value-of select="@prenom" />
                     </td>

                     <td class="uportal-text">
                        <xsl:value-of select="@naissance" />
                     </td>

                     <!--<td class="uportal-text">
                     	<a href="mailto:{@mail}">
                        <xsl:value-of select="@mail" />
                        </a>
                     </td>-->
                     <xsl:if test="@IAE">	
                  		<td class="uportal-text">
                  			<xsl:value-of select="@IAE"/>
                  		</td>
	                  </xsl:if>	
	                  <xsl:if test="@cod_etp">
                  		<td class="uportal-text">
                  			<xsl:value-of select="@cod_etp"/>
                  		</td>
                  		<td class="uportal-text">
                  			<xsl:value-of select="@cod_vrs_vet"/>
                  		</td>
                  		<td class="uportal-text">
                  			<xsl:value-of select="@lib_etp"/>
                  		</td>
                  </xsl:if>	
                     <xsl:if test="@note1">
                  	<td class="uportal-text">
                  		<xsl:value-of select="@note1"/>
                  	</td>
                  	<xsl:if test="count(@resultat1) > 0">
                  	<td class="uportal-text">
                  		<xsl:value-of select="@resultat1"/>
                  	</td>
                  	</xsl:if>
                  </xsl:if>	
                  <xsl:if test="@note2">
                  	<td class="uportal-text">
                  		<xsl:value-of select="@note2"/>
                  	</td>
                  	<xsl:if test="count(@resultat2) > 0">
                  	<td class="uportal-text">
                  		<xsl:value-of select="@resultat2"/>
                  	</td>
                  	</xsl:if>
                  </xsl:if>
                  
                  </tr>
               </xsl:for-each>
            </table>
          </xsl:otherwise>  
         </xsl:choose> 
      </xsl:if>
     </xsl:template>
</xsl:stylesheet>