<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL" />

   <xsl:param name="prefForm" />

   <xsl:param name="mediaPath" />

<!-- message d'erreur si le cod_ind saisi est incorrecte -->
   <xsl:param name="erreur" />
   
<!-- cod_etu saisi par l'utlisateur -->
   <xsl:param name="COD_ETU" />   

   <xsl:template match="xml">
      <br />

      <table cellspacing="0" cellpadding="5" width="100%" border="0">
         <tr>
            <td nowrap="true" class="uportal-channel-table-header">Recherche par numro tudiant</td>

            <td width="5%"></td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action=default">
                  <img alt="Retour au sommaire" border="0" src="{$mediaPath}/back.gif" />
               </a>
            </td>

            <td class="uportal-label" nowrap="true">
               <a href="{$baseActionURL}?action=default">Retour au sommaire</a>
            </td>

            <td width="100%"></td>
         </tr>
      </table>

      <hr />

      <p align="justify" class="uportal-channel-text">Saisissez le numro tudiant de la personne recherche.</p>

      <form name="{$prefForm}formRechDossierWeb" action="{$baseActionURL}" method="post">
         <table border="0" cellspacing="0" cellpadding="4">
            <tr>
               <td class="uportal-label">Numro Etudiant</td>

               <td>
                  <input type="text" name="cod_etu" size="12" maxlength="12" class="uportal-input-text" value="{$COD_ETU}" />                 
               </td>
               <xsl:if test="$erreur='1'">
                   <td class="uportal-channel-table-caption">
                     Aucun tudiant ne correspond au numro saisi
                    </td> 
                  </xsl:if>
            </tr>
            <tr>
               <td colspan="3">
                  <input type="submit" value="Rechercher" class="uportal-button" />
                  <input type="hidden" value="rechNumEtu" name="action" />
               </td>
            </tr>
                       
         </table>
     </form>
   </xsl:template>
</xsl:stylesheet>

