package org.esupportail.portal.channels.gestion.CMonDossierWebEns.dossierEtudiant;

import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.CMonDossierWebEns;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.esupportail.portal.utils.connectors.ApogeeConnector;
import org.esupportail.portal.utils.connectors.ConnectorException;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * <p>DossierEtudiant</p>
 * <p>Sub-channel pour les recherches de la partie "Dossier Etudiant"</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class DossierEtudiant extends SubChannel {
	
	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// log
	private static final Log log = LogFactory.getLog(DossierEtudiant.class);
	// Boolen indiquant une erreur
	private boolean erreur;
	
	/**
	 * Constructeur
	 * @param main
	 */
	public DossierEtudiant(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
	}
	
	/**
	 * init utilis lors de la recherche via l'annuaire
	 * @param rd
	 * @return
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean rechCOD_IND(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		String redirectAction = null;
		// Gestion de l'action 'Retour' du servant Annuaire
		if (rd.getParameter("retour") != null)
			redirectAction = "default";
		// Gestion de l'action 'Retour' du servant MonDossierWeb
		if (rd.getParameter("sommaire") != null)
			redirectAction = rd.getParameter("sommaire");
		// Gestion de l'action 'Autre dossier' du servant MonDossierWeb
		if (rd.getParameter("autre") != null)
			redirectAction = rd.getParameter("autre");
		if (redirectAction != null) {
			owner.redirect(rd,redirectAction);
			return Boolean.FALSE;
		}
		// Rcupration du login d'une personne 
		if (owner.getServantResults() != null) {
			if (owner.getServantResults().length < 1) {
				Message.message(mainChannel, rd, new MessageBean("Aucun \u00E9tudiant s\u00E9l\u00E9ctionn\u00E9",Message.WARNING), "servantAnnuaire");
				return Boolean.FALSE;
			}	
			Personne pers = (Personne)(owner.getServantResults()[0]);
			String pers_id = pers.getIdentifiant();
			if (pers_id != null) {
				owner.setCod_ind(getCodInd(pers_id));
				owner.setLoginEtu(pers_id);
				// Redirection vers l'action grant le servant MonDossierWeb si on a pu trouver le cod_ind
				if (owner.getCod_ind() != null) 
					owner.redirect(rd,"dispatcherMonDossierWeb");
				else
					Message.message(mainChannel, rd, new MessageBean("Erreur : impossible de trouver cet \u00E9tudiant dans APOGEE",Message.ERROR), "default");
				return Boolean.FALSE;
			}
		}
		return res;
	}	
	
	/**
	 * init utilis lors de la recherche par numro d'tudiant
	 * @param rd
	 * @return
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean rechNumEtu(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		int cod_etu = 0;
		if (rd.getParameter("cod_etu") != null) {
			// Rcupration du cod_ind  partir de cod_etu (numro tudiant)
			try {
				cod_etu = new Integer(rd.getParameter("cod_etu")).intValue();
			}
			catch(NumberFormatException e) {
				setErreur(true);
			}
			owner.setCod_ind(getCodIndFromCodEtu(cod_etu));
			if (owner.getCod_ind() == null) 
				setErreur(true);
			else { // Rcupration du login
				owner.setLoginEtu(geLoginFromCodInd(owner.getCod_ind()));
				owner.redirect(rd,"dispatcherMonDossierWeb");
				return Boolean.FALSE;
			}
		} // Gestion de l'action 'Retour' du servant Dossier Web
		else if (rd.getParameter("sommaire") != null) {  
			owner.redirect(rd,rd.getParameter("sommaire"));
			return Boolean.FALSE;
		}	
		return res;
	}
	
	/**
	 * setXML  
	 * @return
	 * @throws FrameWorkException
	 * @throws PortalException
	 */
	public Boolean setXML() {
		this.getXSLParameter().put("erreur",isErreur()+"");
		setErreur(false);
		return Boolean.TRUE;
	}
	
	/**
	 * @param cod_etu
	 * @return le cod_ind
	 * @throws FrameWorkException
	 */
	public String getCodIndFromCodEtu(int cod_etu) throws FrameWorkException {
		String codInf = null;
		Query qry = null;
		boolean error = false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select cod_ind from apogee.individu where cod_etu = ?");
			qry.getStmt().setInt(1, cod_etu);				
			qry.select();			   
			while (qry.getRs().next()){
				codInf = qry.getRs().getString("cod_ind");
			}
		}
		catch (SQLException e) {
			log.error("DossierEtudiant::getCodIndFromCodEtu() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("DossierEtudiant::getCodIndFromCodEtu() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return codInf;
	}
	
	/**
	 * @param cod_ind
	 * @return le login de la personne
	 * @todo A faire en utilisant le connecteur Apogee
	 * @throws FrameWorkException
	 */
	public String geLoginFromCodInd(String cod_ind) throws FrameWorkException {
		String login = null;
		Query qry = null;
		boolean error = false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select NOM_LOGIN from apogee.MEL_LOGIN where COD_IND = ?");
			qry.getStmt().setString(1, cod_ind);				
			qry.select();			   
			while (qry.getRs().next()){
				login = qry.getRs().getString("NOM_LOGIN");
			}
		}
		catch (SQLException e) {
			log.error("DossierEtudiant::geLoginFromCodInd() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("DossierEtudiant::geLoginFromCodInd() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return login;	
	}
	
	/**
	 * Rcupration du cod_ind 
	 * 
	 */
	public String getCodInd(String pers_id) {
		String cod_ind = null;
		// on rcupre le cod_ind via le connecteur Apogee
		try {
			cod_ind = ApogeeConnector.getCOD_INDFromLogin(pers_id);
		} 
		catch (ConnectorException e1) {
			return null;
		}
		return cod_ind;
	}

	/**
	 * @return Renvoie erreur.
	 */
	public boolean isErreur() {
		return erreur;
	}

	/**
	 * @param erreur erreur  dfinir.
	 */
	public void setErreur(boolean erreur) {
		this.erreur = erreur;
	}
	
}