package org.esupportail.portal.channels.gestion.CMonDossierWebEns.listeInscrits;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.CMonDossierWebEns;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.PortalException;
// gnration xls
import jxl.*; 
import jxl.write.*;
import jxl.write.biff.RowsExceededException;

/**
 * ListeInscritsXLS<br>
 * <br>
 * Cette action prend en charge le tlchargement de la liste des tudiants au format XLS <br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 * 
 */
public class ListeInscritsXLS extends ListeInscrits implements IMimeResponse {

	// Log
	private static final Log log = LogFactory.getLog(ListeInscritsXLS.class);
	// Classe principale de la channel
	private CMonDossierWebEns owner;
		
	/**
	 * Constructeur
	 * @param main
	 */
	public ListeInscritsXLS(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns) main;
	}
	
	public java.lang.Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		super.init(rd);
		return java.lang.Boolean.FALSE;
	}
	
	/**
	 * Retourne le type MIME du document
	 * @return Le type MIME
	 */
	public String getContentType() {
		return "application/octet-stream";
	}

	/**
	 * Retourne un InputStream correspondant au fichier  tlcharger
	 * @return Le flux de donnes
	 */
	public InputStream getInputStream() throws IOException {
		return null; // construction du fichier  la vole sinon retourner un InputStream valide vers un fichier
	}

	/**
	 * Mthode qui construit le flux csv
	 * @param out Un OutputStream vers le navigateur du client
	 */
	public void downloadData(OutputStream out) throws IOException {
		WritableWorkbook workbook;
		try {
			workbook = Workbook.createWorkbook(out);
			code = runtimeData.getParameter("code");
			version = runtimeData.getParameter("version");
			this.getListe(workbook);
		} catch (Exception e) {
			log.error("ListeInscritsXLS::downloadData : " + e);
		} 
	}
	
	/**
	 * @param wb workBook Excel
	 * @return retourne la liste des tudiants sous forme de flux csv 
	 * @throws WriteException
	 * @throws RowsExceededException
	 * @throws IOException
	 * 
	 */
	public void getListe(WritableWorkbook wb) throws FrameWorkException, RowsExceededException, WriteException, IOException {
		Query qry = null;
		boolean error= false;
		String niveau = owner.getListe().getNiveau();
		WritableSheet sheet = wb.createSheet(getLibelleObjet()+"", 0);
		// en-tte
		WritableFont arial10font = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
		WritableCellFormat arial10format = new WritableCellFormat (arial10font);
		Label label = new Label(0, 0, "Dossier", arial10format); 
		sheet.addCell(label);
		label = new Label(1, 0, "Nom", arial10format);
		sheet.addCell(label);
		label = new Label(2, 0, "Pr\u00E9nom", arial10format);
		sheet.addCell(label);
		label = new Label(3, 0, "Naissance", arial10format);
		sheet.addCell(label);
		// tmoin colonne
		int col = 4;
		// tmoin IAE uniquement pour les tapes
		if (niveau != null && niveau.equals("etape")) {
			label = new Label(col++, 0, "IAE?", arial10format);
			sheet.addCell(label);
		}	
		if (TEM_ETP != null && TEM_ETP.equals("O")) {
			label = new Label(col++, 0, "Code", arial10format);
			sheet.addCell(label);
			label = new Label(col++, 0, "Version", arial10format);
			sheet.addCell(label);
			label = new Label(col++, 0, "Etape", arial10format);		
			sheet.addCell(label);
		}
		if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
			label = new Label(col++, 0, "Note1", arial10format);		
			sheet.addCell(label);
			if (niveau != null && niveau.equals("etape")) {
				label = new Label(col++, 0, "Rsultat1", arial10format);		
				sheet.addCell(label);
			}	
		}	
		if (TEM_RESS != null && TEM_RESS.equals("O")) {
			label = new Label(col++, 0, "Note2", arial10format);
			sheet.addCell(label);	
			if (niveau != null && niveau.equals("etape")) {
				label = new Label(col++, 0, "Resultat2", arial10format);
				sheet.addCell(label);
			}	
		}
		// Liste des tudiants
		try {
			qry = org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config.getInstance().getConnexionDefault();
			if (niveau != null && niveau.equals("etape"))
				selectListeEtape(qry);
			else if (niveau != null && niveau.equals("element"))
				selectListeElement(qry);
			if (qry.getRs() != null) {
				int row = 1;
				while (qry.getRs().next()){
					col = 0;
					label = new Label(col++, row, qry.getRs().getString("cod_etu"));
					sheet.addCell(label);
					label = new Label(col++, row, qry.getRs().getString("lib_nom_pat_ind"));
					sheet.addCell(label);
					label = new Label(col++, row, qry.getRs().getString("lib_pr1_ind"));
					sheet.addCell(label);
					label = new Label(col++, row, qry.getRs().getString("DATE_NAI_IND"));
					sheet.addCell(label);
					if (niveau != null && niveau.equals("etape")) {
						label = new Label(col++, row, qry.getRs().getString("IAE"));
						sheet.addCell(label);
					}
					if (TEM_ETP != null && TEM_ETP.equals("O")) { 
						label = new Label(col++, row, qry.getRs().getString("cod_etp"));
						sheet.addCell(label);
						label = new Label(col++, row, qry.getRs().getString("cod_vrs_vet"));
						sheet.addCell(label);
						label = new Label(col++, row, qry.getRs().getString("lib_etp"));
						sheet.addCell(label);
					}
					if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
						label = new Label(col++, row, qry.getRs().getString("NOTEJ").replace(',','.'));
						sheet.addCell(label);
						if (niveau != null && niveau.equals("etape")) {
							label = new Label(col++, row, qry.getRs().getString("RESJ"));
							sheet.addCell(label);
						}	
					}
					if (TEM_RESS != null && TEM_RESS.equals("O")) {
						label = new Label(col++, row, qry.getRs().getString("NOTES").replace(',','.'));
						sheet.addCell(label);
						if (niveau != null && niveau.equals("etape")) {
							label = new Label(col++, row, qry.getRs().getString("RESS"));
							sheet.addCell(label);
						}	
					}
					row++;
				}
			}
		}
		catch (SQLException e) {
			log.error("ListeInscritsXLS::getListe() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("ListeInscritsXLS::getListe() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		// All sheets and cells added. Now write out the workbook 
		wb.write(); 
		wb.close(); 
	}
	
	/**
	 * Retourne le nom du fichier
	 * @return Le nom du fichier
	 */
	public String getName() {
		String name = code;
		if (version != null && !version.equals(""))
			name += "_" + version;
		return name + ".xls"; // nom du fichier  tlcharger
	}

	/**
	 * Retourne la liste des headers HTTP  envoyer au navigateur
	 * @return La liste des headers
	 */
	public Map getHeaders() {
		  HashMap map = new HashMap(); 
          map.put("Content-disposition", "attachment; filename=" + getName()); 
          return map;
	}

	/**
	 * Mthode appele si une erreur se produit durant le tlchargement
	 * @param e L'exception leve
	 */
	public void reportDownloadError(Exception e) {
		log.error("ListeInscritsXLS::reportingDownloadError() : " + e);
	}
	
}