<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html" indent="yes"/>
    <xsl:param name="baseActionURL"/>
    <xsl:param name="prefForm"/>
    <xsl:param name="mediaPath"/>
    <xsl:template match="xml">
        <br/>
        <table cellspacing="0" cellpadding="5" width="100%" border="0">
            <tr>             
	        <td class="uportal-channel-table-header" nowrap="true">
	        <xsl:choose>
	            <xsl:when test="objets/@typeFils='diplome'">Liste des Diplmes</xsl:when>
	            <xsl:when test="objets/@typeFils='etape'">Liste des Etapes</xsl:when>
	            <xsl:when test="objets/@typeFils='element' or objets/@typeFils='ssElement'">Liste des Elments</xsl:when>
	            <xsl:otherwise>Liste des Composantes</xsl:otherwise>
	        </xsl:choose>    
	        </td>
	        <td width="5%">&#160;</td>
                <td valign="absmiddle">
                    <a href="{$baseActionURL}?action=rechArbo">
                        <img src="{$mediaPath}/find.gif" border="0" alt="Nouvelle recherche"/>
                    </a>
                </td>
                <td class="uportal-label" nowrap="true">
                    <a href="{$baseActionURL}?action=rechArbo&amp;monDossierWebFinished">Nouvelle recherche</a>
                </td>
                <td width="5%">&#160;</td>
                <td valign="absmiddle">
                    <a href="{$baseActionURL}?action=default">
                        <img src="{$mediaPath}/back.gif" border="0" alt="Retour au sommaire"/>
                    </a>
                </td>
                <td class="uportal-label" nowrap="true">
                    <a href="{$baseActionURL}?action=default&amp;monDossierWebFinished">Retour au sommaire</a>
                </td>
                <td width="100%">&#160;</td>
            </tr>
        </table>
        <hr/>
        <!-- Chemin parcouru dans l'arbre de recherche -->
        <table border="0" width="100%">
        <tr height="30">
           <td>
              <table border="0" cellspacing="0" cellpadding="5">
                 <tr>
                    <xsl:for-each select="chemin/objet">
                       <td class="uportal-channel-table-header">  
                       <xsl:choose>
                           <xsl:when test="position()=last()">
                               <xsl:choose>
                               <xsl:when test="@libelle!=''">
                                  <xsl:value-of select="@libelle" />
                               </xsl:when>
                               <xsl:otherwise>
                                   Liste des Composantes
                               </xsl:otherwise>    
                               </xsl:choose>       
                           </xsl:when>
                           <xsl:otherwise>
                               <a href="{$baseActionURL}?action=arboApogee&amp;code={@code}&amp;version={@version}&amp;typeFils={@typeFils}&amp;position={@position}&amp;monDossierWebFinished">
                                   <xsl:choose>
                                   <xsl:when test="@libelle!=''">
                                      <xsl:value-of select="@libelle" />
                                   </xsl:when>
                                   <xsl:otherwise>
                                       Liste des Composantes
                                   </xsl:otherwise>    
                                   </xsl:choose>       
                               </a>                           
                           </xsl:otherwise>
                       </xsl:choose>    
            		   </td>
            		   <td class="uportal-channel-table-header">&gt;</td>
                    </xsl:for-each>
                 </tr>
              </table>
           </td>
         </tr>
        </table>
        <br/>
        <!-- Affichage de la liste resultat -->
        <xsl:choose>
            <xsl:when test="count(objets/objet)=0">
                <table>
                    <tr>
                        <td class="uportal-channel-error">Aucun rsultat disponible</td>
                    </tr>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <!-- Formulaire permettant de gerer les codes contenant des #
                     Interpreter comme des ancres si passage en GET -->
                <form name="{$prefForm}_params" action="{$baseActionURL}" method="post">
                  <input type="hidden" name="action"/>
                  <input type="hidden" name="typeFils"/>
                  <input type="hidden" name="code"/>
                  <input type="hidden" name="version"/>
                  <input type="hidden" name="position"/>
                  <input type="hidden" name="monDossierWebFinished" value="1"/>
                </form>    
                <table border="0" cellspacing="0" cellpadding="4">
                    <xsl:for-each select="objets/objet">
                        <tr>
                           <td valign="absmiddle">
                               <img src="{$mediaPath}/folder.gif" />
                           </td>
                           <td class="uportal-label">
                              <a href="#" onclick="javascript:document.{$prefForm}_params.action.value='{@action}';document.{$prefForm}_params.typeFils.value='{@typeFils}';document.{$prefForm}_params.code.value='{@code}';document.{$prefForm}_params.version.value='{@version}';document.{$prefForm}_params.position.value='{@position}';document.{$prefForm}_params.submit()">
                                 <xsl:value-of select="@libelle" />
                              </a> 
                           </td>
                           <xsl:if test="@hasFils='true' and (/xml/objets/@typeFils='element' or /xml/objets/@typeFils='ssElement')">
                           <td class="uportal-channel-table-header">&gt;</td>    
                           <td class="uportal-channel-text">
                               <a href="#" onclick="javascript:document.{$prefForm}_params.action.value='resListe';document.{$prefForm}_params.code.value='{@code}';document.{$prefForm}_params.version.value='{@version}';document.{$prefForm}_params.submit()">Slectionner</a>    
                           </td>    
                           </xsl:if>    
                        </tr>
                    </xsl:for-each>
                </table>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
