<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no"/>
   <xsl:param name="baseActionURL"/>
   <xsl:param name="prefForm"/>
   <xsl:param name="mediaPath"/>
   <!-- message d'erreur si l'annee saisie est incorrecte -->
   <xsl:param name="erreur"/>
   <!-- annee par defaut ou annee saisi par l'utlisateur -->
   <xsl:param name="annee"/>
   <!-- code saisi par l'utilisateur -->
   <xsl:param name="code"/>
   <!-- version saisie par l'utilisateur -->
   <xsl:param name="version"/>
   <!-- criteres complementaires -->
   <xsl:param name="TEM_RESJ"/>
   <xsl:param name="TEM_RESS"/>
   <xsl:param name="TEM_ETP"/>
   <!-- niveau selectionne precedemment dans la liste -->
   <xsl:param name="niveau"/>
   <!-- Recherche par code -->
   <xsl:param name="rechCode"/>
   <xsl:template match="xml">
      <br/>
      <table cellspacing="0" cellpadding="5" width="100%" border="0">
         <tr>
            <td nowrap="true" class="uportal-channel-table-header">Liste d'tudiants</td>
            <td width="5%"></td>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action=default">
                  <img alt="Retour au sommaire" border="0" src="{$mediaPath}/back.gif"/>
               </a>
            </td>
            <td class="uportal-label" nowrap="true">
               <a href="{$baseActionURL}?action=default">Retour au sommaire</a>
            </td>
            <td width="100%"></td>
         </tr>
      </table>
      <hr/>
      <xsl:choose>
         <xsl:when test="$rechCode=1">
            <p align="justify" class="uportal-channel-text">Vous allez constituer une liste
               d'inscrits  un lment ou  une tape Apoge  l'aide de son code (et ventuellement
               de sa version dans le cas d'une tape).</p>
         </xsl:when>
         <xsl:otherwise>
            <p align="justify" class="uportal-channel-text">Vous allez constituer une liste
               d'inscrits  un lment ou  un diplme Apoge  l'aide d'un arbre de recherche.</p>
         </xsl:otherwise>
      </xsl:choose>
      <form name="{$prefForm}formRechercheApogee" action="{$baseActionURL}" method="post">
         <table border="0" cellspacing="0" cellpadding="4">
            <tr>
               <td class="uportal-label">Anne universitaire</td>
               <td>
                  <input type="text" name="annee" size="4" maxlength="4" class="uportal-input-text"
                     value="{$annee}"/>
                  <xsl:if test="$erreur='annee'">
                     <div class="uportal-channel-table-caption">L'anne doit tre compose de 4
                        chiffres</div>
                  </xsl:if>
               </td>
            </tr>
            <tr>
               <td class="uportal-label">Type de liste</td>
               <td>
                  <select name="liste" class="uportal-button">
                     <xsl:if test="$rechCode=1">
                        <xsl:attribute name="onChange">displayVersion()</xsl:attribute>
                     </xsl:if>
                     <option value="etape">
                        <xsl:if test="$niveau='etape'">
                           <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:choose>
                           <xsl:when test="$rechCode=1"> Etape </xsl:when>
                           <xsl:otherwise> Etape ou diplme </xsl:otherwise>
                        </xsl:choose>
                     </option>
                     <option value="element">
                        <xsl:if test="$niveau='element'">
                           <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if> Elment pdagogique</option>
                  </select>
               </td>
            </tr>
            <xsl:if test="$rechCode=1">
               <tr>
                  <td class="uportal-label">Code</td>
                  <td>
                     <input type="text" name="code" class="uportal-input-text" value="{$code}"/>
                     <xsl:if test="$erreur='code'">
                        <div class="uportal-channel-table-caption">Vous devez saisir un code ne contenant ni ', ni "</div>
                     </xsl:if>
                  </td>
               </tr>
               <tr id="{$prefForm}version">
                  <td class="uportal-label">Version</td>
                  <td>
                     <input type="text" name="version" class="uportal-input-text" value="{$version}"/>
                     <xsl:if test="$erreur='version'">
                        <div class="uportal-channel-table-caption">La version doit tre compose de
                           3 chiffres</div>
                     </xsl:if>
                  </td>
               </tr>
            </xsl:if>
         </table>
         <p align="justify" class="uportal-channel-text">Vous pouvez complter votre recherche en
            cochant certains critres ci-dessous : par exemple "tape d'appartenance", pour
            visualiser  quelle anne de diplme l'tudiant est rattach, ou "rsultats de session1"
            pour extraire la liste des rsultats de la session 1 de l'anne universitaire
            slectionne...</p>
         <table border="0" cellspacing="0" cellpadding="4">
            <tr>
               <td class="uportal-label">
                  <input type="checkbox" name="TEM_RESJ" value="O">
                     <xsl:if test="$TEM_RESJ='O'">
                        <xsl:attribute name="checked">checked</xsl:attribute>
                     </xsl:if>
                  </input> Rsultats de session 1</td>
               <td class="uportal-label">
                  <input type="checkbox" name="TEM_RESS" value="O">
                     <xsl:if test="$TEM_RESS='O'">
                        <xsl:attribute name="checked">checked</xsl:attribute>
                     </xsl:if>
                  </input> Rsultats de session 2</td>
               <td class="uportal-label">
                  <input type="checkbox" name="TEM_ETP" value="O">
                     <xsl:if test="$TEM_ETP='O'">
                        <xsl:attribute name="checked">checked</xsl:attribute>
                     </xsl:if>
                  </input> Etape d'appartenance</td>
            </tr>
            <tr>
               <td colspan="3"/>
            </tr>
            <tr>
               <td colspan="3">
                  <input type="submit" value="Rechercher" class="uportal-button"/>
                  <xsl:choose>
                     <xsl:when test="$rechCode=1">
                        <input type="hidden" value="rechCode" name="action"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <input type="hidden" value="rechArbo" name="action"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </td>
            </tr>
         </table>
      </form>
      <xsl:if test="$rechCode=1">
         <script language="javascript"> function displayVersion() { if (document.<xsl:value-of
               select="$prefForm"/>formRechercheApogee.liste.value == 'etape')
               document.getElementById("<xsl:value-of select="$prefForm"/>version").style.display =
            ''; else document.getElementById("<xsl:value-of select="$prefForm"
            />version").style.display = 'none'; } displayVersion(); </script>
      </xsl:if>
   </xsl:template>
</xsl:stylesheet>
