package org.esupportail.portal.channels.gestion.CMonDossierWebEns.arboApogee;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.CMonDossierWebEns;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

public class ArboApogee extends SubChannel {

	// Log
	private static final Log log = LogFactory.getLog(ArboApogee.class);	
	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// Objet courant
	private Objet objCourant;
	// Objet pere
	private Objet objPere;
	// Type de liste  construire (etape ou element)
	private String typeListe;
	// Map contenant le chemin lors de la recherche
	private TreeMap chemin;
			
	/**
	 * Constructeur
	 * @param main
	 */
	public ArboApogee(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
		chemin = new TreeMap();
	}
	
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		// Code de l'objet courant
		String code = (rd.getParameter("code") != null) ? rd.getParameter("code") : ""; 
		// Version de l'objet courant
		String version = (rd.getParameter("version") != null) ? rd.getParameter("version") : "";
		// Type des fils de l'objet courant 
		String typeFils = (rd.getParameter("typeFils") != null) ? rd.getParameter("typeFils") : "";
		// Position dans le chemin
		Integer position = (rd.getParameter("position") != null) ? new Integer(rd.getParameter("position")) : new Integer(0);
		// Initialisations
		if (code.equals("")) {
			typeListe = (rd.getParameter("liste") != null) ? rd.getParameter("liste") : "";
			chemin.clear();
		}
		// Objet Courant
		objCourant = null;
		if (typeFils.equals("diplome"))
			objCourant = ObjetDAO.getDiplomes(code,owner.getAnnee());
		else if (typeFils.equals("etape")) {
			objCourant = ObjetDAO.getEtapes(code,version,owner.getAnnee());
		 	if (objCourant.getListeFils().size() == 1) { 
				try {
					Iterator i = objCourant.getListeFils().iterator();
					while (i.hasNext()) {
						Objet obj = (Objet) i.next();
						rd.setParameter("code",obj.getCode());
					 	rd.setParameter("version",obj.getVersion());
					 	rd.setParameter("typeFils",obj.getTypeFils());
					}
					if (typeListe.equals("etape"))
						owner.redirect(rd,"resListe");
					else	
						owner.redirect(rd,"arboApogee");
					return Boolean.FALSE;
				} catch (PortalException e) {
					log.error("ArboApogee::init : " + e);
				}
			}
		}	
		else if (typeFils.equals("element")) 
			objCourant = ObjetDAO.getElements(code,version);
		else if (typeFils.equals("ssElement"))
			objCourant = ObjetDAO.getSousElements(code);
		else 
			objCourant = ObjetDAO.getComposantes();
		objCourant.setCode(code);
		objCourant.setVersion(version);
		objCourant.setTypeFils(typeFils);
		objCourant.setPosition(position);
		// Mise  jour du chemin parcouru
		updateChemin();
		return res;
	}
	
	/**
	* Mise  jour du chemin parcouru
	*/
	public void updateChemin() {
		objPere = (Objet) chemin.get(objCourant.getPosition());
		Integer position = objCourant.getPosition();
		// Ajout de l'objet courant	
		chemin.put(getPositionChemin(),objCourant);
		// Adaptation du chemin en fonction de la position rcupr en paramtre
		if (position.intValue() != 0) {
			SortedMap cheminEnCours = chemin.headMap(new Integer(position.intValue() + 1));
			chemin = new TreeMap(cheminEnCours);
		}
	}
	
	/**
	 * Retourne la position o insrer l'objet dans le chemin 
	 * - La position de l'objet s'il est dj prsent
	 * - La taille du chemin sinon
	 */
	public Integer getPositionChemin() {
		Set ensemble = chemin.keySet();
		Iterator iterateur = ensemble.iterator();
		int i = 0;
		while(iterateur.hasNext()){
		      Object o = iterateur.next();
		      Objet objTest = (Objet)(chemin.get(o));
		      if (objTest.getPosition().equals(objCourant.getPosition()) && objTest.getLibelle().equals(objPere.getLibelle())) { 
		    	  objCourant.setPosition(new Integer(i));
		    	  return objCourant.getPosition();
		      }		
		      i++;
		}
		// Mise  jour de la position de l'objet courant si ajout
		objCourant.setPosition(new Integer(chemin.size()));
		return objCourant.getPosition();
	}
	
	/**
	 * Dtermination du chemin parcouru
	 * @return le flux xml dcrivant le chemin
	 */
	public StringBuffer getXmlChemin() {
		StringBuffer res = new StringBuffer();
		Set ensemble = chemin.keySet();
		Iterator iterateur = ensemble.iterator();
		res.append("<chemin>");
		while(iterateur.hasNext()){
		      Object o = iterateur.next();
		      Objet objet = (Objet)(chemin.get(o));
		      res.append("<objet code=\"").append(objet.getCode()).append("\" version=\"");
		      res.append(objet.getVersion()).append("\" libelle=\"").append(objet.getLibelle());
		      res.append("\" typeFils=\"").append(objet.getTypeFils()).append("\" position=\"");
		      res.append(objet.getPosition().intValue()).append("\"/>");
		}      
		res.append("</chemin>");
		return res;
	}
	
	public Boolean setXML() throws FrameWorkException {	
		StringBuffer xml = new StringBuffer(START_XML);
		xml.append(getXmlChemin());
		xml.append("<objets typeFils=\"").append(objCourant.getTypeFils()).append("\">");
		List listObj = objCourant.getListeFils();
		Iterator i = listObj.iterator();
		while (i.hasNext()) {
			Objet obj = (Objet) i.next();
			xml.append("<objet code=\"").append(obj.getCode()).append("\" version=\"").append(obj.getVersion());
			xml.append("\" libelle=\"").append(obj.getLibelle()).append("\" hasFils=\"").append(obj.getHasFils()).append("\" ");
			xml.append("typeFils=\"").append(obj.getTypeFils()).append("\" ");
			// Action du lien
			String action = "";
			if (typeListe.equals("etape")) 
				action = (objCourant.getTypeFils().equals(typeListe) && !obj.getCode().equals("")) ? "resListe" : "arboApogee" ;
			else 
				action = (obj.getHasFils()) ? "arboApogee" : "resListe"; 
			xml.append("action=\"").append(action).append("\" ");
			xml.append("position=\"").append(objCourant.getPosition().intValue()+1).append("\" ");
			xml.append("/>");
		}
		xml.append("</objets>");
		xml.append(END_XML);
		setXML(xml.toString());
		return Boolean.TRUE;
	}
	
}