package org.esupportail.portal.channels.gestion.CMonDossierWebEns.arboApogee;

import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.database.Query;

public class ObjetDAO {
	
	// Log
	private static final Log log = LogFactory.getLog(ObjetDAO.class);
	
	/**
	 * Mthode qui retourne les composantes 
	 * 
	 */
	public static Objet getComposantes() throws FrameWorkException {
		Objet res = new Objet();
		List listObj = new Vector();
		Query qry = null;
		boolean error= false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select cod_cmp, lib_cmp from composante where tem_en_sve_cmp = 'O' order by lib_cmp");
			qry.select();			
			while (qry.getRs().next()){
				Objet obj = new Objet(qry.getRs().getString("cod_cmp"),"",qry.getRs().getString("lib_cmp"),"diplome");
				listObj.add(obj);		
			}
			res.setLibelle("");
			res.setListeFils(listObj);
		}
		catch (SQLException e) {
			log.error("ObjetDAO::getComposantes() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("ObjetDAO::getComposantes() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return res;
	}
	
	/**
	 * Mthode qui retourne les diplomes d'une composante
	 * @param code
	 * @param anneeEnCours
	 * @throws FrameWorkException
	 */
	public static Objet getDiplomes(String code, String anneeEnCours) throws FrameWorkException {
		Objet res = new Objet();
		List listObj = new Vector();
		Query qry = null;
		boolean error= false;
		// Code et libell de la composante pre
		String cod_cmp = "";
		String lib_cmp = "";
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select distinct chv.cod_cmp, lib_cmp, vfv.cod_dip, vfv.cod_vrs_vdi, vdi.lib_web_vdi " + 
						"from cmp_habiliter_vdi chv, vdi_fractionner_vet vfv, version_diplome vdi, composante " +
						"where (? >= vfv.DAA_DEB_RCT_VET and vfv.DAA_FIN_RCT_VET >= ?) " +
						"and chv.cod_dip = vfv.cod_dip and chv.cod_vrs_vdi = vfv.cod_vrs_vdi " + 
						"and chv.TEM_EN_SVE_CVD = 'O' and vdi.cod_dip = vfv.cod_dip " + 
						"and vdi.cod_vrs_vdi = vfv.cod_vrs_vdi and chv.cod_cmp = ? and chv.cod_cmp = composante.cod_cmp " +
						"order by vdi.lib_web_vdi ");
			qry.getStmt().setString(1, anneeEnCours);
			qry.getStmt().setString(2, anneeEnCours);
			qry.getStmt().setString(3, code);
			qry.select();		
			while (qry.getRs().next()){
				Objet obj = new Objet(qry.getRs().getString("cod_dip"),qry.getRs().getString("cod_vrs_vdi"),qry.getRs().getString("lib_web_vdi"),"etape");
				listObj.add(obj);
				cod_cmp = qry.getRs().getString("cod_cmp");
				lib_cmp = qry.getRs().getString("lib_cmp");
			}
			res.setLibelle(lib_cmp);
			res.setListeFils(listObj);
		}
		catch (SQLException e) {
			log.error("ObjetDAO::getDiplomes() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("ObjetDAO::getDiplomes() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return res;
	}
	
	/**
	 * Mthode qui retourne les tapes d'un diplome
	 * @param code
	 * @param version
	 * @param anneeEnCours
	 * @throws FrameWorkException
	 */
	public static Objet getEtapes(String code, String version, String anneeEnCours) throws FrameWorkException {
		Objet res = new Objet();
		List listObj = new Vector();
		Query qry = null;
		boolean error= false;
		String lic_vdi = "";
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select vfv.cod_etp, vfv.cod_vrs_vet, e.lib_etp, vdi.lic_vdi " + 
				   "from vdi_fractionner_vet vfv, etape e, version_diplome vdi  " + 
				   "where (? >= vfv.DAA_DEB_RCT_VET and vfv.DAA_FIN_RCT_VET >= ?) " + 
				   "and e.cod_etp = vfv.cod_etp " +
				   "and vdi.cod_dip = vfv.cod_dip and vdi.cod_vrs_vdi = vfv.cod_vrs_vdi " +
				   "and vdi.cod_dip = ? and vdi.cod_vrs_vdi = ? " + 
				   "order by e.lib_etp ");
			qry.getStmt().setString(1, anneeEnCours);
			qry.getStmt().setString(2, anneeEnCours);
			qry.getStmt().setString(3, code);
			qry.getStmt().setString(4, version);
			qry.select();		
			while (qry.getRs().next()){
				Objet obj = new Objet(qry.getRs().getString("cod_etp"),qry.getRs().getString("cod_vrs_vet"),qry.getRs().getString("lib_etp"),"element");
				listObj.add(obj);
				lic_vdi = qry.getRs().getString("lic_vdi");
			}
			res.setLibelle(lic_vdi);
			res.setListeFils(listObj);
		}
		catch (SQLException e) {
			log.error("ObjetDAO::getEtapes() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("ObjetDAO::getEtapes() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return res;
	}
	
	/**
	 * Mthode qui retourne les lments d'une tape
	 * @param code
	 * @param version
	 * @throws FrameWorkException
	 */
	public static Objet getElements(String code, String version) throws FrameWorkException {
		Objet res = new Objet();
		List listObj = new Vector();
		Query qry = null;
		boolean error= false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			String sql = "select e.cod_elp, e.lib_elp, le.cod_lse " + 
				     "from vet_regroupe_lse vrl, liste_elp le, elp_regroupe_elp ere, element_pedagogi e " + 
				     "where vrl.cod_etp = ? " + 
				     "and vrl.cod_vrs_vet = ? " +
				     "and vrl.DAT_FRM_REL_LSE_VET is null " +
				     "and le.cod_lse = vrl.cod_lse " + 
				     "and le.ETA_LSE = 'O' " + 
				     "and ere.cod_lse = le.cod_lse " + 
				     "and ere.eta_lse = 'O' " + 
				     "and ere.DATE_FERMETURE_LIEN is null " + 
				     "and ere.eta_elp_fils = 'O' " + 
				     "and ere.tem_sus_elp_fils = 'N' " + 
				     "and e.cod_elp = ere.cod_elp_fils ";
			// Non affichage des lments fictifs
			String[] listeFictif = Config.getInstance().getListeFictif();
			if (listeFictif != null && listeFictif.length >= 1) {
				sql += "and e.cod_nel not in (";
				for (int i = 0; i < listeFictif.length ; i++) {
					sql += "'" + listeFictif[i].toUpperCase() + "'";
					if (i < (listeFictif.length-1))
						sql += ",";
				}
				sql += ") ";
			}	
			sql += "order by e.lib_elp ";
			qry.setSql(sql);
			qry.getStmt().setString(1, code);
			qry.getStmt().setString(2, version);
			qry.select();		
			while (qry.getRs().next()){
				Objet obj = new Objet(qry.getRs().getString("cod_elp"),qry.getRs().getString("cod_lse"),qry.getRs().getString("lib_elp"),"ssElement");
				obj.setHasFils(hasSubElements(qry.getRs().getString("cod_elp")));
				listObj.add(obj);
			}
			qry.setSql("select lib_etp from etape where cod_etp = ?");
			qry.getStmt().setString(1, code);
			qry.select();
			String lib_etp = "";
			while (qry.getRs().next()){
				lib_etp = qry.getRs().getString("lib_etp");
			}
			res.setLibelle(lib_etp);
			res.setListeFils(listObj);
		}
		catch (SQLException e) {
			log.error("ObjetDAO::getElements() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("ObjetDAO::getElements() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return res;
	}	
	
	/**
	 * Mthode qui retourne les sous-lments d'un lment
	 * @param code
	 * @throws FrameWorkException
	 */
	public static Objet getSousElements(String code) throws FrameWorkException {
		Objet res = new Objet();
		List listObj = new Vector();
		Query qry = null;
		boolean error= false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			String sql = "select e.cod_elp, e.lib_elp " + 
				     "from elp_regroupe_elp ere, element_pedagogi e " + 
				     "where ere.cod_elp_pere = ? " + 
				     "and ere.eta_lse = 'O' " +
				     "and ere.DATE_FERMETURE_LIEN is null " +
				     "and ere.eta_elp_fils = 'O' " + 
				     "and ere.tem_sus_elp_fils = 'N' " +
				     "and ere.eta_elp_pere = 'O' " +
				     "and ere.tem_sus_elp_pere = 'N' " +
				     "and e.cod_elp = ere.cod_elp_fils ";
			// Non affichage des lments fictifs
			String[] listeFictif = Config.getInstance().getListeFictif();
			if (listeFictif != null && listeFictif.length >= 1) {
				sql += "and e.cod_nel not in (";
				for (int i = 0; i < listeFictif.length ; i++) {
					sql += "'" + listeFictif[i].toUpperCase() + "'";
					if (i < (listeFictif.length-1))
						sql += ",";
				}
				sql += ")";
			}
			sql += "order by e.lib_elp ";
			qry.setSql(sql);
			qry.getStmt().setString(1, code);
			qry.select();		
			while (qry.getRs().next()){
				Objet obj = new Objet(qry.getRs().getString("cod_elp"),"",qry.getRs().getString("lib_elp"),"ssElement");
				obj.setHasFils(hasSubElements(qry.getRs().getString("cod_elp")));
				listObj.add(obj);
			}
			String lib_elp = "";
			qry.setSql("select lib_elp from element_pedagogi where cod_elp = ?");
			qry.getStmt().setString(1, code);
			qry.select();
			while (qry.getRs().next()){
				lib_elp = qry.getRs().getString("lib_elp");
			}
			res.setLibelle(lib_elp);
			res.setListeFils(listObj);
		}
		catch (SQLException e) {
			log.error("ObjetDAO::getSousElements() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("ObjetDAO::getSousElements() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return res;
	}
	
	public static boolean hasSubElements(String cod_elp) throws FrameWorkException {
		Query qry = null;
		boolean error= false;
		boolean res = false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select count(*) nb " + 
				   "from elp_regroupe_elp ere " + 
				   "where ere.cod_elp_pere = ? " + 
				   "and ere.eta_lse = 'O' " +
				   "and ere.DATE_FERMETURE_LIEN is null " +
				   "and ere.eta_elp_fils = 'O' " + 
				   "and ere.tem_sus_elp_fils = 'N' " +
				   "and ere.eta_elp_pere = 'O' " +
				   "and ere.tem_sus_elp_pere = 'N' ");
			qry.getStmt().setString(1, cod_elp);
			qry.select();		
			while (qry.getRs().next()){
				if (qry.getRs().getInt("nb") > 0)
					res = true;
			}
		}
		catch (SQLException e) {
			log.error("ObjetDAO::hasSubElements() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("ObjetDAO::hasSubElements() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return res;
	}
	
}