package org.esupportail.portal.channels.gestion.CMonDossierWebEns.listeInscrits;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.CMonDossierWebEns;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XMLEscaper;

/**
 * <p>ListeInscrits</p>
 * <p>Sub-channel pour l'dition de liste d'tudiants</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class ListeInscrits extends SubChannel {

	// Log
	private static final Log log = LogFactory.getLog(ListeInscrits.class);	
	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// Code
	protected String code;
	// Version
	protected String version;
	// Libell
	private String libelle;
	// Action prcdente
	protected String previousAction;
	// Tmoin d'affichage des rsultats de juin
	protected String TEM_RESJ;
	// Tmoin d'affichage des rsultats de septembre
	protected String TEM_RESS;
	// Tmoin pour visualiser  quelle anne de diplme l'tudiant est rattach
	protected String TEM_ETP;
			
	/**
	 * Constructeur
	 * @param main
	 */
	public ListeInscrits(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
		setPreviousAction("");
	}
	
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		// Initialisation des tmoins de la classe
		TEM_RESJ = owner.getListe().getTEM_RESJ();
		TEM_RESS = owner.getListe().getTEM_RESS();
		TEM_ETP = owner.getListe().getTEM_ETP();
		// Initialisation de previousAction
		if (owner.getPreviousAction() != null && (owner.getPreviousAction().getName().equals("arboApogee")
				|| owner.getPreviousAction().getName().equals("rechCode"))) {
				setPreviousAction(owner.getPreviousAction().getName());
		}
		// Gestion Nouvelle recherche
		if (runtimeData.getParameter("mode") != null && runtimeData.getParameter("mode").equals("nouvRech")) {
			if (getPreviousAction().equals("arboApogee"))
				setPreviousAction("rechArbo");
			owner.redirect(rd,getPreviousAction());
			return Boolean.FALSE;
		}
		// Rcupration du code, de la version et du libell de l'objet pour lequel on tablit la liste
		if (runtimeData.getParameter("code") != null && !owner.getPreviousAction().getName().equals("dispatcherMonDossierWeb")) {
			code = runtimeData.getParameter("code").toUpperCase(); // Code en maj dans Apogee
			version = runtimeData.getParameter("version");
			libelle = getLibelleObjet();
		}
		return res;
	}
			
	/**
	 * Retourne le libell de l'tape ou de l'lment
	 * @return
	 * @throws FrameWorkException 
	 */
	public String getLibelleObjet() throws FrameWorkException {
		String res = "";
		Query qry = null;
		boolean error = false;
		String niveau = owner.getListe().getNiveau();
		try {
			qry = Config.getInstance().getConnexionDefault();
			if (niveau != null && niveau.equals("etape")) {
				qry.setSql("select lib_etp from etape where cod_etp = ?");
				qry.getStmt().setString(1, code);
				qry.select();
				while(qry.getRs().next()) {
					res = qry.getRs().getString("lib_etp");
				}
			}
			else {
				qry.setSql("select e.lib_elp " + 
						   "from element_pedagogi e " +
						   "where e.cod_elp = ? ");
				qry.getStmt().setString(1, code);
				qry.select();
				while(qry.getRs().next()) {
					res = qry.getRs().getString("lib_elp");
				}
			}
		}
		catch (SQLException e) {
			log.error("ListeInscrits::getLibelleObjet() : Erreur SQL " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return res;
	}
	
	
	/**
	 * setXML pour la liste des tudiants 
	 * @return
	 * @throws FrameWorkException
	 */
	public Boolean setXMLListe() throws FrameWorkException {
		StringBuffer xml = new StringBuffer(START_XML);
		if (code != null) {
			xml.append("<result id=\"").append(XMLEscaper.escape(code)).append("\" ");		
			if (version == null)
				xml.append("vers=\"\" ");
			else	
				xml.append("vers=\"").append(XMLEscaper.escape(version)).append("\" ");
			xml.append("lib=\"").append(XMLEscaper.escape(libelle)).append("\" ");
			xml.append("annee=\"").append(owner.getAnnee()).append("\" ");
			xml.append("/>");	
			xml.append(getListe());				
			// Passage de l'id de l'tape  la feuille de style	
			this.getXSLParameter().put("idEtape",code);
			// Passage des diffrentes tmoins 
			if (TEM_RESJ != null)
				this.getXSLParameter().put("TEM_RESJ",TEM_RESJ);
			if (TEM_RESS != null)
				this.getXSLParameter().put("TEM_RESS",TEM_RESS);
			if (TEM_ETP != null)
				this.getXSLParameter().put("TEM_ETP",TEM_ETP);
		}
		xml.append(END_XML);
		setXML(xml.toString());
		// Pour permettre le bon fonctionnement du lien de tlchargement
		addDownloadXslParameter();
		return Boolean.TRUE;
	}
	
	/**
	 * @return retourne la liste des tudiants sous forme de flux xml 
	 * 
	 */
	public StringBuffer getListe() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<liste>");
		Query qry = null;
		boolean error= false;
		try {
			String niveau = owner.getListe().getNiveau(); 
			qry = Config.getInstance().getConnexionDefault();
			if (niveau != null && niveau.equals("etape"))
				selectListeEtape(qry);
			else if (niveau != null && niveau.equals("element"))
				selectListeElement(qry);
			if (qry.getRs() != null) {
				while (qry.getRs().next()){
					res.append("<etudiant dossier=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_etu"))).append("\" ");
					res.append("nom=\"").append(XMLEscaper.escape(qry.getRs().getString("lib_nom_pat_ind"))).append("\" ");
					res.append("cod_ind=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_ind"))).append("\" ");
					res.append("prenom=\"").append(XMLEscaper.escape(qry.getRs().getString("lib_pr1_ind"))).append("\" ");
					res.append("naissance=\"").append(XMLEscaper.escape(qry.getRs().getString("DATE_NAI_IND"))).append("\" ");
					if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
						res.append("note1=\"").append(XMLEscaper.escape(qry.getRs().getString("NOTEJ"))).append("\" ");
						if (qry.getRs().getString("RESJ") != null && !qry.getRs().getString("RESJ").equals(" "))
							res.append("resultat1=\"").append(XMLEscaper.escape(qry.getRs().getString("RESJ"))).append("\" ");
					}
					if (TEM_RESS != null && TEM_RESS.equals("O")) {
						res.append("note2=\"").append(XMLEscaper.escape(qry.getRs().getString("NOTES"))).append("\" ");
						if (qry.getRs().getString("RESS") != null && !qry.getRs().getString("RESS").equals(" "))
							res.append("resultat2=\"").append(XMLEscaper.escape(qry.getRs().getString("RESS"))).append("\" ");
					}
					if (niveau != null && niveau.equals("etape"))
						res.append("IAE=\"").append(XMLEscaper.escape(qry.getRs().getString("IAE"))).append("\" ");
					if (TEM_ETP != null && TEM_ETP.equals("O")) { 
						res.append("cod_etp=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_etp"))).append("\" ");
						res.append("cod_vrs_vet=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_vrs_vet"))).append("\" ");
						res.append("lib_etp=\"").append(XMLEscaper.escape(qry.getRs().getString("lib_etp"))).append("\" ");
					}	
					res.append("/>");
				}
			}
		}
		catch (SQLException e) {
			log.error("ListeInscrits::getListe() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("ListeInscrits::getListe() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		res.append("</liste>");
		return res;
	}
	
	
	/**
	 * 
	 * Construction et excution du select pour rcuprer la liste des tudiants d'une tape
	 * @param Query query
	 * @throws SQLException
	 */
	public void selectListeEtape(Query qry) throws SQLException {
		// select gnral
		String select = "select i.cod_ind,i.cod_etu, i.lib_nom_pat_ind, i.lib_pr1_ind," +
						"to_char(i.date_nai_ind,'DD/MM/YYYY') \"DATE_NAI_IND\", " + 
						"decode(rj.tem_iae_ko_vet,0,'O','N') \"IAE\" " ;
		// select tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			select += " ,rj.cod_etp,rj.cod_vrs_vet,e.lib_etp "; 
		// select rsultats Juin
		if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
			select += ", nvl(decode(to_char(rj.not_vet),null,rj.not_sub_vet,to_char(rj.not_vet)),' ') \"NOTEJ\" " + 
					  ", nvl(rj.cod_tre,' ') \"RESJ\" ";   		
		}	
		// select rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O")) {
			select += ", nvl(decode(to_char(rs.not_vet),null,rs.not_sub_vet,to_char(rs.not_vet)),' ') \"NOTES\" " +
					  ", nvl(rs.cod_tre,' ') \"RESS\" ";    		
		}	
		// from gnral
		String from = "from apogee.individu i , apogee.resultat_vet rj ";
		// from rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O"))
			from += " left outer join apogee.resultat_vet rs on ( rs.cod_ind = rj.cod_ind " + 
					" and rs.tem_iae_ko_vet in ('0','2') " +
					" and rs.cod_etp = rj.cod_etp " +
					" and rs.cod_vrs_vet = rj.cod_vrs_vet " +
					" and rs.cod_anu = rj.cod_anu " +
					" and rs.cod_ses = '2' " + 
					"and rs.cod_adm = '1') ";
		// from tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			from += " , apogee.etape e ";
		// where gnral
		String where = "where rj.tem_iae_ko_vet in ('0','2') " +
						" and rj.cod_etp = ? " +
						" and rj.cod_vrs_vet = ? " + 
						" and rj.cod_anu = ? " +
						" and rj.cod_ses in ('0','1') and rj.cod_adm = '1' " +
						" and i.cod_ind = rj.cod_ind ";
		// where tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			where += " and e.cod_etp = rj.cod_etp ";
		// ordre de tri
		String order = "order by i.lib_nom_pat_ind,i.lib_pr1_ind,i.date_nai_ind ";
		//log("requete : "+ select + from + where + order);
		qry.setSql(select + from + where + order); 
		qry.getStmt().setString(1, code);
		qry.getStmt().setString(2, version);
		qry.getStmt().setString(3, owner.getAnnee());
		qry.select();
	}
	
	/**
	 * 
	 * Construction et excution du select pour rcuprer la liste des tudiants d'un lment
	 * @param Query query
	 * @throws SQLException
	 */
	public void selectListeElement(Query qry) throws SQLException {
		// select gnral
		String select = "select i.cod_ind,i.cod_etu, i.lib_nom_pat_ind, i.lib_pr1_ind," +
						"to_char(i.date_nai_ind,'DD/MM/YYYY') \"DATE_NAI_IND\" "; 
		// select tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			select += " ,ice.cod_etp,ice.cod_vrs_vet,e.lib_etp ";
		// select rsultats Juin
		if (TEM_RESJ != null && TEM_RESJ.equals("O")) {
			select += ", nvl(decode(to_char(rj.not_elp),null,rj.not_sub_elp,to_char(rj.not_elp)),' ') \"NOTEJ\"" + 
					  ", nvl(rj.cod_tre,' ') \"RESJ\" ";   		
		}	
		// select rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O")) {
			select += ", nvl(decode(to_char(rs.not_elp),null,rs.not_sub_elp,to_char(rs.not_elp)),' ') \"NOTES\"" + 
					  ", nvl(rs.cod_tre,' ') \"RESS\" ";   		
		}	
		// from gnral
		String from = "from apogee.individu i, apogee.ind_contrat_elp ice " ;
		// from rsultats Septembre
		if (TEM_RESS != null && TEM_RESS.equals("O"))
			from += " left outer join apogee.resultat_elp rs on ( rs.cod_ind = ice.cod_ind " +
					 " and rs.cod_elp = ice.cod_elp and rs.cod_anu = ice.cod_anu " +
					 " and rs.cod_ses = '2' and rs.cod_adm = '1' ) ";
		// from tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			from += " , apogee.etape e ";
		// from rsultats Juin		
		if (TEM_RESJ != null && TEM_RESJ.equals("O"))
			from += " , apogee.resultat_elp rj ";
		// where gnral
		String where = "where ice.cod_elp = ? " + 
						" and ice.cod_anu = ? " +
						" and ice.tem_prc_ice = 'N' and i.cod_ind = ice.cod_ind "; 
		// where tape
		if (TEM_ETP != null && TEM_ETP.equals("O"))
			where += " and e.cod_etp = ice.cod_etp ";
		// where rsultats Juin
		if (TEM_RESJ != null && TEM_RESJ.equals("O"))
			where += " and rj.cod_ind = ice.cod_ind " +
					 " and rj.cod_elp = ice.cod_elp and rj.cod_anu = ice.cod_anu " +
					 " and rj.cod_ses <= '1' and rj.cod_adm = '1' ";
		// ordre de tri
		String order = "order by i.lib_nom_pat_ind,i.lib_pr1_ind,i.date_nai_ind";
		//log("requete sql : " + select + from + where + order);
		qry.setSql(select + from + where + order); 
		qry.getStmt().setString(1, code);
		qry.getStmt().setString(2, owner.getAnnee());
		qry.select();
	}
	
	/**
	 * @return Renvoie previousAction.
	 */
	public String getPreviousAction() {
		return previousAction;
	}

	/**
	 * @param previousAction previousAction  dfinir.
	 */
	public void setPreviousAction(String previousAction) {
		this.previousAction = previousAction;
	}
	
}