package org.esupportail.portal.channels.gestion.CMonDossierWebEns;

import java.sql.SQLException;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.listeInscrits.Liste;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;
import org.esupportail.portal.utils.channels.plugins.FatalError;
import org.esupportail.portal.utils.channels.plugins.RestrictedAction;
import org.esupportail.portal.utils.database.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * <p>CMonDossierWebEns</p>
 * <p>Description : Mon dossier Web : consultation des rsultats des tudiants par les enseignants</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class CMonDossierWebEns extends MainChannel {
	
	// log
	private static final Log log = LogFactory.getLog(CMonDossierWebEns.class);
	// Code de l'tudiant trait
	private String cod_ind;
	// Login de la personne traite
	private String loginEtu;
	// Anne utilise pour les requtes
	private String annee;
	// Description de la liste des inscrits
	private Liste liste;

	public CMonDossierWebEns() throws PortalException {
		setConfigActions(Config.getInstance());	
	}
	
	public void setStaticData(ChannelStaticData sd) {
		staticData = sd;
		String userId = (String) staticData.getPerson().getAttribute(IPerson.USERNAME);
		// Test d'accs au canal
		try {
			if (!RestrictedAction.filterAccess(this,"default",Config.getInstance().getGroupmapping(),false)){
				// Si la personne connecte ne fait pas partie du groupe autoris, on regarde si elle n'a 
				// pas un login actif dans Apogee dans le cas o cette option est active 
				if (true && !(Config.getInstance().getLoginApogee() && checkCptApogee(userId))) {
					FatalError.fatalError(this, Config.getInstance().getMsgInterdit());
				}		
			}
		} catch (Exception e) {
			log.error("CMonDossierWebEns::setStaticData: Erreur Controle d'acces " + e);
		}
	}
	
	/**
	 * Vrifie si le login pass en paramtre  une correspondance dans Apogee
	 * @return
	 */
	public boolean checkCptApogee(String login) throws FrameWorkException {
		Query qry = null;
		boolean error = false;
		boolean res = false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select * from apogee.utilisateur where cod_uti = ? and tem_en_sve_uti = 'O'");
			qry.getStmt().setString(1, login.toUpperCase());
			qry.select();
			if (qry.getRs() != null) {
				while (qry.getRs().next()){
					res = true;
				}
			}	
		}
		catch (SQLException e) {
			log.error("CMonDossierWebEns::checkCptApogee() : Erreur SQL " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		return res;
	}
		
	/** 
	 *  Initialise les static et les runtime data pour le servant
	 *  @param <b>IServant</b> servant servant  instancier
	 */
	public void initServant(IServant servant) throws PortalException {
		// Servant Annuaire
		if (getCurrentAction().getName().equals("servantAnnuaire"))
			initServantAnnuaire();
		// Servant MonDossierWeb
		if (getCurrentAction().getName().equals("servantMonDossierWeb"))
			initServantMonDossierWeb();
		// Servant Envoi de mails
		if (getCurrentAction().getName().equals("sendMail")) 
			initServantMailTo();
		super.initServant(servant);
	}
	
	/**
	 * Initialisation des static data pour le servant Annuaire
	 */
	public void initServantAnnuaire() {
		if (getActionParam("servantAnnuaire","name") != null)
			staticData.setParameter("serverView", getActionParam("servantAnnuaire","name").getValue()); 
		if (getActionParam("servantAnnuaire","type") != null)
			staticData.setParameter("returnServant",getActionParam("servantAnnuaire","type").getValue());
		if (getActionParam("servantAnnuaire","displayFiche") != null)
			staticData.setParameter("affFiche",getActionParam("servantAnnuaire","displayFiche").getValue());
	}
	
	/**
	 * Initialisation des static data pour le servant MonDossierWeb
	 */
	public void initServantMonDossierWeb() {
		staticData.setParameter("cod_ind",cod_ind);
		staticData.setParameter("loginEtu",loginEtu);
	}
	
	/**
	 * Initialisation des static data pour le servant MailTo
	 */
	public void initServantMailTo() {
		// Pour viter la dpendance, on n'utilise pas les constantes Mail.TO, Mail.CC, Mail.BCC 
		String toField ="to";
		String ccField ="cc"; 
		String bccField ="bcc";
		// Destinataire
		String[] att = new String[3];
		att[0] = "";
		// La scolarit dans le cas du lien "Nous contacter"
		if (runtimeData.getParameter("dest") != null && runtimeData.getParameter("dest").equals("scolarite")) 
			att[0] = Config.getInstance().getAdrContact();
        else if (runtimeData.getParameter("mail") != null)// Le titulaire du dossier consult dans le cas du lien sur le mail
        	att[0] = runtimeData.getParameter("mail");
        att[1] = "false";
        att[2] = "true";
        runtimeData.setParameterValues(toField,att);
        // Les champs copies sont dsactivs
        att = new String[3];
        att[0] = "";
        att[1] = "false";
        att[2] = "false";
        runtimeData.setParameterValues(ccField,att);
        att = new String[3];
        att[0] = "";
        att[1] = "false";
        att[2] = "false";
        runtimeData.setParameterValues(bccField,att);
        // Action de retour en fonction de l'action appelante
        getCurrentAction().setServantfinish(getPreviousAction().getName());
	}
	
	/**
	 * @return Returns the cod_ind.
	 */
	public String getCod_ind() {
		return cod_ind;
	}
	
	/**
	 * @param cod_ind The cod_ind to set.
	 */
	public void setCod_ind(String cod_ind) {
		this.cod_ind = cod_ind;
	}
	
	/**
	 * @return Returns the loginEtu.
	 */
	public String getLoginEtu() {
		return loginEtu;
	}
	/**
	 * @param loginEtu The loginEtu to set.
	 */
	public void setLoginEtu(String loginEtu) {
		this.loginEtu = loginEtu;
	}
	
	/**
	 * @return Returns the annee.
	 */
	public String getAnnee() {
		return annee;
	}
	
	/**
	 * @param annee The annee to set.
	 */
	public void setAnnee(String annee) {
		this.annee = annee;
	}
	
	/**
	 * @return Renvoie liste.
	 */
	public Liste getListe() {
		return liste;
	}

	/**
	 * @param liste liste  dfinir.
	 */
	public void setListe(Liste liste) {
		this.liste = liste;
	}
}