package org.esupportail.portal.channels.gestion.CMonDossierWebEns;

import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.jasig.portal.PortalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>RenderStatic</p>
 * <p>Sub-channel pour les pages statiques de la channel CMonDossierWebEns</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class RenderStatic extends SubChannel {

	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// log
	private static final Log log = LogFactory.getLog(RenderStatic.class);
		
	/**
	 * Constructeur
	 * @param main
	 */
	public RenderStatic(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
	}
	
	/**
	 * setXML  
	 * @return
	 * @throws FrameWorkException
	 * @throws PortalException
	 */
	public Boolean setXML() {
		if (Config.getInstance().getAdrContact() != null) 
			this.getXSLParameter().put("contact",Config.getInstance().getAdrContact());
		// Si l'action correspondant au servant mailTo est prsent dans le fichier de config,
		// on l'utilise pour les envois de mail
		if (owner.getAction("sendMail") != null) {
			this.getXSLParameter().put("servantMailTo","1");
		}
		return Boolean.TRUE;
	}
		
}