package org.esupportail.portal.channels.gestion.CMonDossierWebEns.listeInscrits;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.CMonDossierWebEns;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.Config;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * <p>RechercheListe</p>
 * <p>Sub-channel pour la slection de la liste d'tudiants  construire</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class RechercheListe extends SubChannel {

	// Log
	private static final Log log = LogFactory.getLog(RechercheListe.class);	
	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// Message d'erreur
	private String erreur;
	// Mode de recherche
	private String mode;
			
	/**
	 * Constructeur
	 * @param main
	 */
	public RechercheListe(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
		owner.setListe(new Liste());
	}
	
	/**
	 * init appel pour la recherche arborescente 
	 * @param rd
	 * @return
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean rechArbo(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		setMode("arbo");
		if (recherche(rd) != null) {
			owner.redirect(rd,recherche(rd));
			return Boolean.FALSE;
		}
		return res;
	}
	
	/**
	 * init appel pour la recherche par code 
	 * @param rd
	 * @return
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean rechCode(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		setMode("code");
		if (recherche(rd) != null) {
			if (rd.getParameter("code") != null && (rd.getParameter("code").indexOf("\"") != -1 || rd.getParameter("code").indexOf("'") != -1)) {
					setErreur("code");
					return res;
			}		
			if (rd.getParameter("version") != null && owner.getListe().getNiveau().equals("etape") &&
				!Pattern.compile("^[0-9]{3}").matcher(rd.getParameter("version")).find()) {
					setErreur("version");
					return res;
			}
			owner.redirect(rd,recherche(rd));
			return Boolean.FALSE;
		}
		return res;
	}
	
	/**
	 * Oprations communes aux recherches par arbo et code
	 * @param rd
	 * @return l'action  entreprendre ensuite
	 */
	private String recherche(ChannelRuntimeData rd) {
		String action = null;
		// Vrification de l'anne saisie et redirection sur le servant RechercheApogee si ok
		if (rd.getParameter("annee") != null && !rd.getParameter("annee").equals("")) {
			owner.setAnnee(rd.getParameter("annee"));
			// Choix de la liste (Composante/Diplome/Etape/Element)
			owner.getListe().setNiveau(rd.getParameter("liste"));
			// Affichage des rsultats de juin
			owner.getListe().setTEM_RESJ(runtimeData.getParameter("TEM_RESJ"));
			// Affichage des rsultats de septembre
			owner.getListe().setTEM_RESS(runtimeData.getParameter("TEM_RESS"));
			// Affichage de l'tape d'appartenance
			owner.getListe().setTEM_ETP(runtimeData.getParameter("TEM_ETP"));
			// Test de la validit de l'anne
			if (!Pattern.compile("^[0-9]{4}").matcher(owner.getAnnee()).find()) {
				setErreur("annee");
				return null;
			} // Test code saisi
			else if (rd.getParameter("code") != null && rd.getParameter("code").length() == 0) {
				setErreur("code");
				return null;
			}	
			else {
				if (getMode().equals("arbo"))
					action = "arboApogee";	
				else if (getMode().equals("code"))
					action = "resListe";			
			}			
		}
		return action;
	}
	
	/**
	 * setXML  
	 * @return
	 * @throws FrameWorkException 
	 */
	public Boolean setXML() throws FrameWorkException {
		// Passage du msg d'erreur et de l'anne saisie en paramtre de la feuille xsl
		if (this.getErreur() != null) {
			this.getXSLParameter().put("erreur",this.getErreur());
			setErreur(null);
		}	
		try {
			if (this.getAnnee() != null)
				this.getXSLParameter().put("annee",this.getAnnee());
		} catch (Exception e) {
			log.error("RechercheListe::setXML() : Erreur " + e);
		}
		// Passage code et version slectionns
		if (runtimeData.getParameter("code") != null)
			this.getXSLParameter().put("code",runtimeData.getParameter("code"));
		if (runtimeData.getParameter("version") != null)
			this.getXSLParameter().put("version",runtimeData.getParameter("version"));
		// Passage du niveau slectionn
		if (owner.getListe().getNiveau() != null)
			this.getXSLParameter().put("niveau",owner.getListe().getNiveau());
		// Passage des critres slectionns
		if (runtimeData.getParameter("TEM_RESJ") != null)
			this.getXSLParameter().put("TEM_RESJ",runtimeData.getParameter("TEM_RESJ"));
		if (runtimeData.getParameter("TEM_RESS") != null)
			this.getXSLParameter().put("TEM_RESS",runtimeData.getParameter("TEM_RESS"));
		if (runtimeData.getParameter("TEM_ETP") != null)
			this.getXSLParameter().put("TEM_ETP",runtimeData.getParameter("TEM_ETP"));
		// Recherche par code
		if (getMode().equals("code"))
			this.getXSLParameter().put("rechCode","1");
		return Boolean.TRUE;
	}
	
	/**
	 * @return Returns the annee.
	 * @throws FrameWorkException
	 */
	public String getAnnee() throws FrameWorkException {
		String anneeEnCours = null;
		if (owner.getAnnee() == null) {
			anneeEnCours = getAnneeEnCours();
			owner.getListe().setAnnee(anneeEnCours);
		}	
		else
			anneeEnCours = owner.getAnnee();
		return anneeEnCours;
	}
		
	/**
	 * @return Retourne l'anne en cours 
	 * @throws PortalException
	 * 
	 */
	public String getAnneeEnCours() throws FrameWorkException {
		String res = null;
		Query qry = null;
		boolean error = false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select cod_anu from annee_uni where eta_anu_iae = 'O'");
			qry.select();			   
			while (qry.getRs().next()){
				  res = qry.getRs().getString("cod_anu"); 
			}
		}
		catch (SQLException e) {
			log.error("RechercheListe::getAnneeEnCours() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("RechercheListe::getAnneeEnCours() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
				
		}
		return res;
	}
		
	/**
	 * @return Renvoie erreur.
	 */
	public String getErreur() {
		return erreur;
	}

	/**
	 * @param erreur erreur  dfinir.
	 */
	public void setErreur(String erreur) {
		this.erreur = erreur;
	}

	/**
	 * @return Renvoie mode.
	 */
	public String getMode() {
		return mode;
	}

	/**
	 * @param mode mode  dfinir.
	 */
	public void setMode(String mode) {
		this.mode = mode;
	}
		
}