package org.esupportail.portal.channels.gestion.CMonDossierWebEns.arboApogee;

import java.util.List;
import org.jasig.portal.utils.XMLEscaper;

public class Objet {
	
	// Code de l'objet
	private String code;
	// Version de l'objet
	private String version;
	// Libell de l'objet
	private String libelle;
	// Position de l'objet dans le chemin (0,1,...)
	private Integer position;
	// Indique si l'objet  des fils
	private boolean hasFils;
	// Type des fils de l'objet
	private String typeFils;
	// Lise des fils de l'objets
	private List listeFils;
		
	public Objet() {
		this.code = "";
		this.version = "";
		this.position = new Integer(0);
		this.hasFils = true;
		this.typeFils = "";
		this.listeFils = null;
	}
	
	public Objet(String code, String version, String libelle, String typeFils) {
		this.code = code;
		this.version = version;
		this.libelle = libelle;
		this.hasFils = true;
		this.typeFils = typeFils;
	}
	
	public Objet(String code, String version, String libelle, String typeFils, Integer position) {
		this(code,version,libelle,typeFils);
		this.position = position;
	}

	/**
	 * @return Renvoie code.
	 */
	public String getCode() {
		return XMLEscaper.escape(code);
	}

	/**
	 * @param code code  dfinir.
	 */
	public void setCode(String code) {
		this.code = code;
	}
	
	/**
	 * @return Renvoie version.
	 */
	public String getVersion() {
		return XMLEscaper.escape(version);
	}

	/**
	 * @param version version  dfinir.
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * @return Renvoie libelle.
	 */
	public String getLibelle() {
		return XMLEscaper.escape(libelle);
	}

	/**
	 * @param libelle libelle  dfinir.
	 */
	public void setLibelle(String libelle) {
		this.libelle = libelle;
	}

	/**
	 * @return Renvoie position.
	 */
	public Integer getPosition() {
		return position;
	}

	/**
	 * @param position position  dfinir.
	 */
	public void setPosition(Integer position) {
		this.position = position;
	}

	/**
	 * @return Renvoie hasFils
	 */
	public boolean getHasFils() {
		return hasFils;
	}

	/**
	 * @param hasFils
	 */
	public void setHasFils(boolean hasFils) {
		this.hasFils = hasFils;
	}

	/**
	 * @return Renvoie le type des fils
	 */
	public String getTypeFils() {
		return typeFils;
	}

	/**
	 * @param typeFils type des fils
	 */
	public void setTypeFils(String typeFils) {
		this.typeFils = typeFils;
	}

	/**
	 * @return Renvoie listeFils.
	 */
	public List getListeFils() {
		return listeFils;
	}

	/**
	 * @param listeFils listeFils  dfinir.
	 */
	public void setListeFils(List listeFils) {
		this.listeFils = listeFils;
	}
	
}