package org.esupportail.portal.channels.gestion.CMonDossierWebEns.dossierEtudiant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CMonDossierWebEns.CMonDossierWebEns;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * <p>DispatcherMonDossierWeb</p>
 * <p>Sub-channel pour la gestion des appels et des retours du servant monDossierWeb</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 *
 */
public class DispatcherMonDossierWeb extends SubChannel {

	// Classe principale de la channel
	private CMonDossierWebEns owner;
	// log
	private static final Log log = LogFactory.getLog(DispatcherMonDossierWeb.class);
	// Action prcdente
	private String previousAction;
		
	/**
	 * Constructeur
	 * @param main
	 */
	public DispatcherMonDossierWeb(MainChannel main) {
		super(main);
		owner = (CMonDossierWebEns)main;
	}
	
	/**
	 * Gre les appels et retours du servant monDossierWeb
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		// Si l'action prcdente est dfinie, redirection vers elle
		if (getPreviousAction() != null) {
			if (rd.getParameter("sommaire") != null)
				setPreviousAction(rd.getParameter("sommaire"));
			owner.redirect(runtimeData,getPreviousAction());
			setPreviousAction(null);
			return Boolean.FALSE;
		}
		setPreviousAction(owner.getPreviousAction().getName());
		if (owner.getPreviousAction().getName().equals("resListe")) {
			owner.setCod_ind(this.runtimeData.getParameter("cod_ind"));
			owner.setLoginEtu(this.runtimeData.getParameter("login"));
		}
		// Redirection vers le servant dossierWeb
		owner.redirect(runtimeData,"servantMonDossierWeb");
		return Boolean.FALSE;
	}

	/**
	 * @return Renvoie previousAction.
	 */
	public String getPreviousAction() {
		return previousAction;
	}

	/**
	 * @param previousAction previousAction  dfinir.
	 */
	public void setPreviousAction(String previousAction) {
		this.previousAction = previousAction;
	}
	
}