package org.esupportail.portal.channels.gestion.CRechercheApogee;

import java.sql.SQLException;
import org.apache.log4j.Priority;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.utils.XMLEscaper;

/** 
 * <p>Titre : Diplomes</p>
 * <p>Description : SubChannel charg de la gestion du niveau Diplomes</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class Diplomes extends SubChannel {
	
	// Classe principale de la channel
	private CRechercheApogee owner;
	// Flux xml  afficher
	private StringBuffer xml;
	// Code du diplome
	private String cod_dip;
	// Version du diplome
	private String cod_vrs_vdi;
	
	/**
	 * Constructeur
	 * @param main
	 */
	public Diplomes(MainChannel main) {
		super(main);
		owner = (CRechercheApogee)main;	
	}

	public Boolean setXML() throws FrameWorkException {
		xml = new StringBuffer(START_XML);
		xml.append(getDiplomes());
		xml.append(owner.getXmlChemin());
		xml.append(END_XML);
		setXML(xml.toString());
		
		// passage des paramtres  la feuille xsl
		if (owner.getActionParam(owner.getCurrentAction().getName(),"libelle") != null && owner.getActionParam(owner.getCurrentAction().getName(),"libelle").getValue() != null)
			this.getXSLParameter().put("libelle",owner.getActionParam(owner.getCurrentAction().getName(),"libelle").getValue());
		if (owner.getActionParam(owner.getCurrentAction().getName(),"action") != null && owner.getActionParam(owner.getCurrentAction().getName(),"action").getValue() != null)
			this.getXSLParameter().put("action",owner.getActionParam(owner.getCurrentAction().getName(),"action").getValue());
		
		return Boolean.TRUE;
	}
	
	/**
	 * Mthode qui retourne les composantes sous forme de flux xml 
	 * 
	 */
	public StringBuffer getDiplomes() throws FrameWorkException {
		
		StringBuffer res = new StringBuffer("<diplomes>");
		Query qry = null;
		boolean error= false;
		String anneeEnCours = owner.getAnnee();
		//log("anneEnCours : " +anneeEnCours);
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select distinct chv.cod_cmp, lib_cmp, vfv.cod_dip, vfv.cod_vrs_vdi, vdi.lic_vdi " + 
						"from cmp_habiliter_vdi chv, vdi_fractionner_vet vfv, version_diplome vdi, composante " + 
						"where (? >= vfv.DAA_DEB_RCT_VET and vfv.DAA_FIN_RCT_VET >= ?) " + 
						"and chv.cod_dip = vfv.cod_dip and chv.cod_vrs_vdi = vfv.cod_vrs_vdi " + 
						"and chv.TEM_EN_SVE_CVD = 'O' and vdi.cod_dip = vfv.cod_dip " + 
						"and vdi.cod_vrs_vdi = vfv.cod_vrs_vdi and chv.cod_cmp = ? and chv.cod_cmp = composante.cod_cmp ");
			qry.getStmt().setString(1, anneeEnCours);
			qry.getStmt().setString(2, anneeEnCours);
			qry.getStmt().setString(3, this.runtimeData.getParameter("id"));
			qry.select();		
			String lib_cmp = null;
			while (qry.getRs().next()){
				lib_cmp = qry.getRs().getString("lib_cmp");
				res.append("<diplome cod_cmp=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_cmp"))).append("\" id=\"");
				res.append(XMLEscaper.escape(qry.getRs().getString("cod_dip"))).append("\" vers=\"");
				res.append(XMLEscaper.escape(qry.getRs().getString("cod_vrs_vdi"))).append("\" lib=\"");
				res.append(XMLEscaper.escape(qry.getRs().getString("lic_vdi")));
				res.append("\"/>");
				cod_dip = qry.getRs().getString("cod_dip");
				cod_vrs_vdi = qry.getRs().getString("cod_vrs_vdi");
			}
			// si lib_cmp est vide car l'anne ne permet pas de rcuprer des rsultats pour la requte prcdente, on le fixe  l'aide de l'id reu en param
			if (lib_cmp == null) {
				qry.setSql("select lib_cmp from composante where cod_cmp = ? ");
				qry.getStmt().setString(1, this.runtimeData.getParameter("id"));
				qry.select();
				while (qry.getRs().next()){
					lib_cmp = qry.getRs().getString("lib_cmp");
				}
			}
			// ajout du niveau dans le chemin s'il n'est pas dj prsent
			Niveau nivEnCours = new Niveau(this.runtimeData.getParameter("id"),lib_cmp,owner.getCurrentAction().getName(),this.runtimeData.getParameter("vers"));
			if (owner.getChemin() != null && !owner.getChemin().containsValue(nivEnCours))
				owner.getChemin().put(new Integer(owner.getChemin().size()),nivEnCours);
			// on fixe le resultat en mode servant
			if (owner instanceof CRechercheApogeeServant) 
				((CRechercheApogeeServant)owner).setNiveauEnCours(nivEnCours);
		}
		catch (SQLException e) {
			log(Priority.ERROR,"Diplomes::getDiplomes() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log(Priority.ERROR,"Diplomes::getDiplomes() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		res.append("</diplomes>");
		return res;
	}
	
}
