package org.esupportail.portal.channels.gestion.CRechercheApogee;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.FatalError;
import org.esupportail.portal.utils.channels.plugins.RestrictedAction;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/** 
 * <p>Titre : RechercheApogee</p>
 * <p>Description : Permet de parcourir l'arborescence des composantes/diplomes/etapes/elements d'Apogee</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class CRechercheApogee extends MainChannel {
	
	// log
	private static final Log log = LogFactory.getLog(CRechercheApogee.class);
	// map contenant le chemin lors de la recherche
	private TreeMap chemin;
	// anne utilise pour les requtes
	protected String annee;

	public CRechercheApogee() throws PortalException {
		setConfigActions(Config.getInstance());	
		chemin = new TreeMap();
	}
	
	public void setStaticData(ChannelStaticData sd) {
		staticData = sd;
		
		String userId = (String) staticData.getPerson().getAttribute(IPerson.USERNAME);
		// test d'accs au canal
		try {
			if (!RestrictedAction.filterAccess(this,"default",Config.getInstance().getGroupmapping(),false)){
				FatalError.fatalError(this, Config.getInstance().getMsgInterdit());
				log.info("CRechercheApogee::setStaticData: Acces refuse");
			}
		} catch (PortalException e) {
			log.error("CRechercheApogee::setStaticData: Erreur Contrle d'acces " + e);
		} catch (FrameWorkException e) {
			log.error("CRechercheApogee::setStaticData: Erreur Contrle d'acces " + e);
		}
	}	
	
	/**
	 * Dtermination du chemin de recherche  afficher
	 * 
	 * @return le flux xml dcrivant le chemin de recherche parcouru
	 */
	public StringBuffer getXmlChemin() {
		StringBuffer res = new StringBuffer();
		
		// si on a un niveau de pass en paramtre (clic sur un niveau du chemin affich par ex), 
		// on adapte le chemin en fonction
		if (this.runtimeData.getParameter("niveau") != null) {
			Integer niveau = new Integer(this.runtimeData.getParameter("niveau"));
			SortedMap cheminEnCours = chemin.headMap(new Integer(niveau.intValue() + 1));
			chemin = new TreeMap(cheminEnCours);
		}

		// on parcourt la treemap pour construire le chemin en xml
		Set ensemble = chemin.keySet();
		Iterator iterateur = ensemble.iterator();
		res.append("<niveaux>");
		while(iterateur.hasNext()){
	      Object o = iterateur.next();
	      Niveau nivEnCours = (Niveau)(chemin.get(o));
	      res.append("<niveau libelle=\"").append(nivEnCours.getLibelle()).append("\" id=\"");
	      res.append(nivEnCours.getId()).append("\" action=\""); 
	      res.append(nivEnCours.getAction()).append("\" niveau=\"");
	      res.append(o.toString());
	      res.append("\" vers=\"").append(nivEnCours.getVers());
	      res.append("\" />");
		}      
		res.append("</niveaux>");
		return res;
	}
	
	/**
	 * 
	 * Vrifie si le niveau (diplome, etape, etc..) est dj prsent dans le chemin
	 *
	 * return la position de l'indice de l'objet Niveau si trouv, la taille du chemin sinon
	 */
	public int checkNiveau() {
		Set ensemble = this.getChemin().keySet();
		Iterator iterateur = ensemble.iterator();
		int i = 0;
		while(iterateur.hasNext()){
	      Object o = iterateur.next();
	      Niveau nivTest = (Niveau)(this.getChemin().get(o));
	      if (nivTest.getAction().equals(this.getCurrentAction().getName()))
	      		return i;
	      i++;
		}
		return this.getChemin().size();
	}

	/**
	 * @param chemin The chemin to set.
	 */
	public void setChemin(TreeMap chemin) {
		this.chemin = chemin;
	}
	/**
	 * @return Returns the chemin.
	 */
	public TreeMap getChemin() {
		return chemin;
	}
	/**
	 * @return Returns the annee.
	 * @throws FrameWorkException
	 * @throws PortalException
	 */
	public String getAnnee() throws FrameWorkException {
		String anneeEnCours = null;
		if (annee == null)
			anneeEnCours = getAnneeEnCours();
		else
			anneeEnCours = annee;
		return anneeEnCours;
	}
	
	/**
	 * @return Retourne l'anne en cours 
	 * @throws PortalException
	 * 
	 */
	public String getAnneeEnCours() throws FrameWorkException {
		
		String res = null;
		Query qry = null;
		boolean error = false;
	
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select cod_anu from annee_uni where eta_anu_iae = 'O'");
			qry.select();			   
			while (qry.getRs().next()){
				  res = qry.getRs().getString("cod_anu"); 
			}
		}
		catch (SQLException e) {
			log.error("CRechercheApogee::getAnneeEnCours() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("CRechercheApogee::getAnneeEnCours() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
				
		}
		return res;
	}
	
}
