package org.esupportail.portal.channels.gestion.CRechercheApogee;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.ActionParam;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XMLEscaper;

/** 
 * <p>Titre : Composantes</p>
 * <p>Description : SubChannel charg de la gestion du niveau Composantes</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class Composantes extends SubChannel {

	// log
	private static final Log log = LogFactory.getLog(Composantes.class);
	// Classe principale de la channel
	private CRechercheApogee owner;
	// Flux xml  afficher
	private StringBuffer xml;
	// Libell du niveau ( = Liste des Composantes)
	private String libelle;
	
	/**
	 * Constructeur
	 * @param main
	 */
	public Composantes(MainChannel main) {
		super(main);
		owner = (CRechercheApogee)main;
	}
	
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		super.init(rd);
		// on rcupre le libell du niveau  partir du fichier de config
		ActionParam p = owner.getActionParam(owner.getCurrentAction().getName(),"libelle");
		if (p != null)
			libelle = p.getValue();
		// ajout de Composantes comme niveau initial du chemin de recherche
		int size = owner.getChemin().size(); 
		if (size == 0) 
			owner.getChemin().put(new Integer(size),new Niveau("null",libelle,owner.getCurrentAction().getName(),null));
		return Boolean.TRUE;
	}
		
	public Boolean setXML() throws FrameWorkException {

		// construction du xml
		xml = new StringBuffer(START_XML);
		xml.append(owner.getXmlChemin());
		xml.append(getComposantes());
		xml.append(END_XML);
		setXML(xml.toString());
		// passage des paramtres  la feuille xsl
		if (libelle != null)
			this.getXSLParameter().put("libelle",libelle);
		if (owner.getActionParam(owner.getCurrentAction().getName(),"action") != null && owner.getActionParam(owner.getCurrentAction().getName(),"action").getValue() != null)
			this.getXSLParameter().put("action",owner.getActionParam(owner.getCurrentAction().getName(),"action").getValue());
		
		return Boolean.TRUE;
	}
	
	/**
	 * Mthode qui retourne les composantes sous forme de flux xml 
	 * 
	 */
	public StringBuffer getComposantes() throws FrameWorkException {
		
		StringBuffer res = new StringBuffer("<composantes>");
		Query qry = null;
		boolean error= false;
	
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select cod_cmp, lib_cmp from composante where tem_en_sve_cmp = 'O' order by lib_cmp");
			qry.select();			
			while (qry.getRs().next()){
				res.append("<composante id=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_cmp"))).append("\" lib=\"");
				res.append(XMLEscaper.escape(qry.getRs().getString("lib_cmp"))).append("\"/>");
			}
		}
		catch (SQLException e) {
			log.error("Composantes::getComposantes() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("Composantes::getComposantes() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		res.append("</composantes>");
		return res;
	}
}
