package org.esupportail.portal.channels.gestion.CRechercheApogee;

import java.io.IOException;
import org.esupportail.portal.utils.channels.ConfigChannel;

/** 
 * <p>Titre : Config</p>
 * <p>Description : Lecture de la configuration du canal</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class Config extends ConfigChannel {
	
	// dclaration des variables de la classe
	private static Config singleton = null;
	// message d'interdiction
	private String msgInterdit;
	// liste des lments que l'on ne veut pas afficher
	private String[] listeFictif;
	
	/**
	* 
	* @return ConfigChannel Instance
	* @throws IOException
	* @throws JspException
	*/
	public static Config getInstance() {
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}
	
	/**
	 * Mthode qui permet d'ajouter une personnalisation sur les rgles que doit prendre en compte
	 * le digester
	 */
	protected void customDigester() {
		dig.addCallMethod("config","addRoot",1);
		dig.addCallParam("config/msgInterdit",0);
		// Elments que l'on ne veut pas afficher
		dig.addCallMethod("config/listeFictif","addListeFictif",1);
	    dig.addCallParam("config/listeFictif",0,"value");
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.channels.ConfigChannel#getConfigFile()
	 */
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CRechercheApogee/CRechercheApogee.xml";
	}
	
	/**
	* 
	* @param msgInterdit Parameter of file RechercheApogee.xml
	* 
	*/
	public void addRoot(String msgInterdit){
		this.msgInterdit = msgInterdit;
	}

	public void addListeFictif(String value){
		if (!value.equals(""))
			this.listeFictif = value.split(",");
	}

	
	/**
	 * @return Returns the msgInterdit.
	 */
	public String getMsgInterdit() {
		return msgInterdit;
	}
	/**
	 * @param msgInterdit The msgInterdit to set.
	 */
	public void setMsgInterdit(String msgInterdit) {
		this.msgInterdit = msgInterdit;
	}
	/**
	 * @return Returns the listeFictif.
	 */
	public String[] getListeFictif() {
		return listeFictif;
	}
}
