package org.esupportail.portal.channels.gestion.CRechercheApogee;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.utils.XMLEscaper;

/** 
 * <p>Titre : Elements</p>
 * <p>Description : SubChannel charg de la gestion du niveau Elements</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class Elements extends SubChannel {

	// log
	private static final Log log = LogFactory.getLog(Elements.class);	
	// Classe principale de la channel
	private CRechercheApogee owner;
	// Flux xml  afficher
	private StringBuffer xml;
	
	/**
	 * Constructeur
	 * @param main
	 */
	public Elements(MainChannel main) {
		super(main);
		owner = (CRechercheApogee)main;	
	}

	public Boolean setXML() throws FrameWorkException {
		xml = new StringBuffer(START_XML);
		xml.append(getElements());
		xml.append(owner.getXmlChemin());
		xml.append(END_XML);
		setXML(xml.toString());
		setXSLParameter();	
		return Boolean.TRUE;
	}
	
	public Boolean setXMLSousElt() throws FrameWorkException {
		xml = new StringBuffer(START_XML);
		xml.append(getSousElements());
		xml.append(owner.getXmlChemin());
		xml.append(END_XML);
		setXML(xml.toString());
		setXSLParameter();
		return Boolean.TRUE;
	}
	
	public void setXSLParameter() {
		// passage des paramtres  la feuille xsl
		if (owner.getActionParam(owner.getCurrentAction().getName(),"libelle") != null && owner.getActionParam(owner.getCurrentAction().getName(),"libelle").getValue() != null)
			this.getXSLParameter().put("libelle",owner.getActionParam(owner.getCurrentAction().getName(),"libelle").getValue());
		if (owner.getActionParam(owner.getCurrentAction().getName(),"action") != null && owner.getActionParam(owner.getCurrentAction().getName(),"action").getValue() != null)
			this.getXSLParameter().put("action",owner.getActionParam(owner.getCurrentAction().getName(),"action").getValue());	
	}
	
	
	/**
	 * Mthode qui retourne les lments sous forme de flux xml 
	 * 
	 */
	public StringBuffer getElements() throws FrameWorkException {
		
		StringBuffer res = new StringBuffer("<elements>");
		Query qry = null;
		boolean error= false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			String sql = "select e.cod_elp, e.lib_elp, le.cod_lse " + 
						 "from vet_regroupe_lse vrl, liste_elp le, elp_regroupe_elp ere, element_pedagogi e " + 
						 "where vrl.cod_etp = ? " + 
						 "and vrl.cod_vrs_vet = ? " +
						 "and vrl.DAT_FRM_REL_LSE_VET is null " +
						 "and le.cod_lse = vrl.cod_lse " + 
						 "and le.ETA_LSE = 'O' " + 
						 "and ere.cod_lse = le.cod_lse " + 
						 "and ere.eta_lse = 'O' " + 
						 "and ere.DATE_FERMETURE_LIEN is null " + 
						 "and ere.eta_elp_fils = 'O' " + 
						 "and ere.tem_sus_elp_fils = 'N' " + 
						 "and e.cod_elp = ere.cod_elp_fils ";
			// modif CC - 07/03/2005 : Non affichage des lments fictifs
			String[] listeFictif = Config.getInstance().getListeFictif();
			if (listeFictif != null && listeFictif.length >= 1) {
				sql += "and e.cod_nel not in (";
				for (int i = 0; i < listeFictif.length ; i++) {
					sql += "'" + listeFictif[i].toUpperCase() + "'";
					if (i < (listeFictif.length-1))
						sql += ",";
				}
				sql += ")";
			}	
			qry.setSql(sql);
			qry.getStmt().setString(1, this.runtimeData.getParameter("id"));
			qry.getStmt().setString(2, this.runtimeData.getParameter("vers"));
			qry.select();		
			while (qry.getRs().next()){
				res.append("<element id=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_elp"))).append("\" vers=\"");
				res.append(XMLEscaper.escape(qry.getRs().getString("cod_lse"))).append("\" lib=\"");
				res.append(XMLEscaper.escape(qry.getRs().getString("lib_elp")));
				if (hasSubElements(qry.getRs().getString("cod_elp")))
					res.append("\" isDossier=\"1\" ");
				else
					res.append("\" isDossier=\"0\" ");
				res.append("/>");
			}
			// ajout du niveau dans le chemin s'il n'est pas dj prsent
			qry.setSql("select lib_etp from etape where cod_etp = ?");
			qry.getStmt().setString(1, this.runtimeData.getParameter("id"));
			qry.select();
			String lib_etp = null;
			while (qry.getRs().next()){
				lib_etp = qry.getRs().getString("lib_etp");
			}
			Niveau nivEnCours = new Niveau(this.runtimeData.getParameter("id"),lib_etp,owner.getCurrentAction().getName(),this.runtimeData.getParameter("vers"));
			if (owner.getChemin() != null && !owner.getChemin().containsValue(nivEnCours)) {
				// modif CC - 31/01/2005
				owner.getChemin().put(new Integer(owner.checkNiveau()),nivEnCours);
			}	
			// on fixe le resultat en mode servant
			if (owner instanceof CRechercheApogeeServant) 
				((CRechercheApogeeServant)owner).setNiveauEnCours(nivEnCours);
		}
		catch (SQLException e) {
			log.error("Elements::getElements() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("Elements::getElements() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		res.append("</elements>");
		return res;
	}	
	
	/**
	 * Mthode qui retourne les sous-lments sous forme de flux xml 
	 * 
	 */
	public StringBuffer getSousElements() throws FrameWorkException {
		
		StringBuffer res = new StringBuffer("<elements>");
		Query qry = null;
		boolean error= false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			String sql = "select e.cod_elp, e.lib_elp " + 
						 "from elp_regroupe_elp ere, element_pedagogi e " + 
						 "where ere.cod_elp_pere = ? " + 
						 "and ere.eta_lse = 'O' " +
						 "and ere.DATE_FERMETURE_LIEN is null " +
						 "and ere.eta_elp_fils = 'O' " + 
						 "and ere.tem_sus_elp_fils = 'N' " +
						 "and ere.eta_elp_pere = 'O' " +
						 "and ere.tem_sus_elp_pere = 'N' " +
						 "and e.cod_elp = ere.cod_elp_fils ";
			// modif CC - 07/03/2005 : Non affichage des lments fictifs
			String[] listeFictif = Config.getInstance().getListeFictif();
			if (listeFictif != null && listeFictif.length >= 1) {
				sql += "and e.cod_nel not in (";
				for (int i = 0; i < listeFictif.length ; i++) {
					sql += "'" + listeFictif[i].toUpperCase() + "'";
					if (i < (listeFictif.length-1))
						sql += ",";
				}
				sql += ")";
			}
			qry.setSql(sql);
			qry.getStmt().setString(1, this.runtimeData.getParameter("id"));
			qry.select();		
			while (qry.getRs().next()){
				res.append("<element id=\"").append(XMLEscaper.escape(qry.getRs().getString("cod_elp")));
				res.append("\" lib=\"");
				res.append(XMLEscaper.escape(qry.getRs().getString("lib_elp")));
				if (hasSubElements(qry.getRs().getString("cod_elp")))
					res.append("\" isDossier=\"1\" ");
				else
					res.append("\" isDossier=\"0\" ");
				res.append("/>");
			}
			// ajout du niveau dans le chemin s'il n'est pas dj prsent
			String lib_elp = null;
			qry.setSql("select lib_elp from element_pedagogi where cod_elp = ?");
			qry.getStmt().setString(1, this.runtimeData.getParameter("id"));
			qry.select();
			while (qry.getRs().next()){
				lib_elp = XMLEscaper.escape(qry.getRs().getString("lib_elp"));
			}
			Niveau nivEnCours = new Niveau(this.runtimeData.getParameter("id"),lib_elp,owner.getCurrentAction().getName(),this.runtimeData.getParameter("vers"));
			if (owner.getChemin() != null && !owner.getChemin().containsValue(nivEnCours))
				owner.getChemin().put(new Integer(owner.getChemin().size()),nivEnCours);
			// on fixe le resultat en mode servant
			if (owner instanceof CRechercheApogeeServant) 
				((CRechercheApogeeServant)owner).setNiveauEnCours(nivEnCours);
		}
		catch (SQLException e) {
			log.error("Elements::getSousElements() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("Elements::getSousElements() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		res.append("</elements>");
		return res;
	}
	
	public boolean hasSubElements(String cod_elp) throws FrameWorkException {
		Query qry = null;
		boolean error= false;
		boolean res = false;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select count(*) nb " + 
						"from elp_regroupe_elp ere " + 
						"where ere.cod_elp_pere = ? " + 
						"and ere.eta_lse = 'O' " +
						"and ere.DATE_FERMETURE_LIEN is null " +
						"and ere.eta_elp_fils = 'O' " + 
						"and ere.tem_sus_elp_fils = 'N' " +
						"and ere.eta_elp_pere = 'O' " +
						"and ere.tem_sus_elp_pere = 'N' ");
			qry.getStmt().setString(1, cod_elp);
			qry.select();		
			while (qry.getRs().next()){
				int nb = qry.getRs().getInt("nb");
				if (nb > 0)
					res = true;
			}
		}
		catch (SQLException e) {
			log.error("Elements::hasSubElements() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("Elements::hasSubElements() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		
		return res;
	}
	
}
