package org.esupportail.portal.channels.gestion.CRechercheApogee;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XMLEscaper;

/** 
 * <p>Titre : Etapes</p>
 * <p>Description : SubChannel charg de la gestion du niveau Etapes</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class Etapes extends SubChannel {
	
	// log
	private static final Log log = LogFactory.getLog(Etapes.class);	
	// Classe principale de la channel
	private CRechercheApogee owner;
	// Flux xml  afficher
	private StringBuffer xml;
	// Nb de resultats retourns
	private int nbRes;
	// Informations de l'tape dans le cas "tape unique"
	private String cod_etp = null;
	private String cod_vrs_vet = null;
	private String lib_etp = null;
	
	/**
	 * Constructeur
	 * @param main
	 */
	public Etapes(MainChannel main) {
		super(main);
		owner = (CRechercheApogee)main;	
	}
	
	public Boolean setXML() throws FrameWorkException {
		xml = new StringBuffer(START_XML);
		xml.append(getEtapes());
		xml.append(owner.getXmlChemin());
		xml.append(END_XML);
		setXML(xml.toString());
		
		// test si un seul resultat, alors redirection vers l'action Elements sans affichage de l'tape
		// test sur le runtimedata "niveau" pour ne pas faire la redirection si on clique sur l'tape dans le chemin de recherche
		if (nbRes == 1 /*&& runtimeData.getParameter("niveau") == null*/) { 
			 try {
			 	runtimeData.setParameter("id",cod_etp);
			 	runtimeData.setParameter("vers",cod_vrs_vet);
			 	runtimeData.setParameter("lib",lib_etp);
			 	runtimeData.setParameter("action","sousElements");
				owner.redirect(runtimeData,"elements");
				return Boolean.FALSE;
			} catch (PortalException e) {
				log.error("Etapes::setXML : " + e);
			}
		}
		
		// passage des paramtres  la feuille xsl
		if (owner.getActionParam(owner.getCurrentAction().getName(),"libelle") != null && owner.getActionParam(owner.getCurrentAction().getName(),"libelle").getValue() != null)
			this.getXSLParameter().put("libelle",owner.getActionParam(owner.getCurrentAction().getName(),"libelle").getValue());
		if (owner.getActionParam(owner.getCurrentAction().getName(),"action") != null && owner.getActionParam(owner.getCurrentAction().getName(),"action").getValue() != null)
			this.getXSLParameter().put("action",owner.getActionParam(owner.getCurrentAction().getName(),"action").getValue());
		
		return Boolean.TRUE;
	}
	
	/**
	 * Mthode qui retourne les composantes sous forme de flux xml 
	 * 
	 */
	public StringBuffer getEtapes() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<etapes>");
		Query qry = null;
		boolean error= false;
		String anneeEnCours = owner.getAnnee();
		//log.error("anneEnCours : " +anneeEnCours);
		// initialisation du nombre de rsultats
		nbRes = 0;
		try {
			qry = Config.getInstance().getConnexionDefault();
			qry.setSql("select vfv.cod_etp, vfv.cod_vrs_vet, e.lib_etp, vdi.lic_vdi " + 
						"from vdi_fractionner_vet vfv, etape e, version_diplome vdi  " + 
						"where (? >= vfv.DAA_DEB_RCT_VET and vfv.DAA_FIN_RCT_VET >= ?) " + 
						"and e.cod_etp = vfv.cod_etp " +
						"and vdi.cod_dip = vfv.cod_dip and vdi.cod_vrs_vdi = vfv.cod_vrs_vdi " +
						"and vdi.cod_dip = ? and vdi.cod_vrs_vdi = ?");
			qry.getStmt().setString(1, anneeEnCours);
			qry.getStmt().setString(2, anneeEnCours);
			qry.getStmt().setString(3, this.runtimeData.getParameter("id"));
			qry.getStmt().setString(4, this.runtimeData.getParameter("vers"));
			qry.select();		
			String lic_vdi = null;
			while (qry.getRs().next()){
				lic_vdi = qry.getRs().getString("lic_vdi");
				cod_etp = qry.getRs().getString("cod_etp");
				cod_vrs_vet = qry.getRs().getString("cod_vrs_vet");
				lib_etp = qry.getRs().getString("lib_etp");
				res.append("<etape id=\"").append(XMLEscaper.escape(cod_etp)).append("\" vers=\"");
				res.append(XMLEscaper.escape(cod_vrs_vet)).append("\" lib=\"");
				res.append(XMLEscaper.escape(lib_etp));
				res.append("\"/>");
				nbRes++;
			}
			// ajout du niveau dans le chemin s'il n'est pas dj prsent
			Niveau nivEnCours = new Niveau(this.runtimeData.getParameter("id"),lic_vdi,owner.getCurrentAction().getName(),this.runtimeData.getParameter("vers"));
			if (owner.getChemin() != null && !owner.getChemin().containsValue(nivEnCours)) {
				// modif CC - 31/01/2005
				owner.getChemin().put(new Integer(owner.checkNiveau()),nivEnCours);
			}	
			// on fixe le resultat en mode servant
			if (owner instanceof CRechercheApogeeServant) {
				((CRechercheApogeeServant)owner).setNiveauEnCours(nivEnCours);
				// s'il n'y a qu'une tape et qu'il s'agit du niveau redonnant la main au canal maitre, on arrete le servant
				if (nbRes == 1 && ((CRechercheApogeeServant)owner).getNiveauRetour().equals(owner.getCurrentAction().getName())) {
					((CRechercheApogeeServant)owner).getNiveauEnCours().setId(cod_etp);
					((CRechercheApogeeServant)owner).getNiveauEnCours().setVers(cod_vrs_vet);
					((CRechercheApogeeServant)owner).getNiveauEnCours().setLibelle(lib_etp);
					((CRechercheApogeeServant)owner).setServantFinish(true);
				}
			} 
		}
		catch (SQLException e) {
			log.error("Etapes::getEtapes() : Erreur SQL " + e);
			error = true;
		}
		catch (Exception e) {
			log.error("Etapes::getEtapes() : Erreur " + e);
			error = true;
		}
		finally {
			qry.close();
			if (error)
				throw new FrameWorkException();
		}
		res.append("</etapes>");
		return res;
	}

}
