package org.esupportail.portal.channels.gestion.CRechercheApogee;


/** 
 * <p>Titre : Niveau</p>
 * <p>Description : Description d'un niveau de recherche ; objet retourn lors de l'utilisation en mode servant</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class Niveau  { 

	// identifiant du niveau	
	private String id;
	// libelle du niveau
	private String libelle;
	// action  effectuer lors d'un clic sur ce niveau 
	private String action;
	// version du niveau
	private String vers;
	
	/**
	 * Constructeur
	 * @param id identifiant du niveau
	 * @param libelle libelle du niveau
	 * @param action action  effectuer lors  d'un clic
	 * @param vers version du niveau
	 */
	public Niveau(String id, String libelle, String action, String vers) {
		this.id = id;
		this.libelle = libelle;
		this.action = action;
		this.vers = vers;
	}
	
	/**
	 * @return Returns the action.
	 */
	public String getAction() {
		return action;
	}
	/**
	 * @param action The action to set.
	 */
	public void setAction(String action) {
		this.action = action;
	}
	/**
	 * @return Returns the id.
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * @return Returns the libelle.
	 */
	public String getLibelle() {
		return libelle;
	}
	/**
	 * @param libelle The libelle to set.
	 */
	public void setLibelle(String libelle) {
		this.libelle = libelle;
	}
	
	 public int hashCode(){
	 	if (id != null && libelle != null && action != null)
	 		return id.hashCode() + libelle.hashCode() + action.hashCode();
	 	return 0;
	 }
	  
	 public boolean equals(Object o){
	    if(!(o instanceof Niveau))
	      return false;
	    Niveau n = (Niveau)o;
	    if(this.hashCode() == n.hashCode())
	      return true;
	    return false;
	  }
	
	/**
	 * @return Returns the vers.
	 */
	public String getVers() {
		return vers;
	}
	/**
	 * @param vers The vers to set.
	 */
	public void setVers(String vers) {
		this.vers = vers;
	}
	
}
