<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="liste.xsl" />

   <xsl:import href="chemin.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL" />

   <xsl:param name="prefForm" />

   <xsl:param name="mediaPath" />

<!-- libelle du niveau -->
   <xsl:param name="libelle" />

<!-- action appelee lors du clic sur un lien -->
   <xsl:param name="action" />

<!-- indique que l'on est en mode servant et specifie le dernier niveau cliquable avant retour au canal maitre -->
   <xsl:param name="modeServant"/>

<!-- indique le niveau actuellement selectionne : composantes, diplomes, etc.. -->
   <xsl:param name="niveauServant" />
   
   <xsl:template match="xml">
<!-- Lien de retour au canal maitre si utilisation en mode servant -->
      <xsl:if test="$modeServant!=''">
      	<br/>
   		<table cellspacing="0" cellpadding="5" width="100%" border="0">
   		<tr>
   		<!-- Affichage du libelle du niveau si on est pas au niveau initial dans le mode servant -->
   		 <xsl:if test="count(niveaux/niveau) &gt; 1">
   		 <td class="uportal-channel-table-header" nowrap="true"><xsl:value-of select="$libelle" /></td>
   		<td width="5%">&#160;</td>
   		 </xsl:if>
   		<td valign="absmiddle">
         	<a href="{$baseActionURL}?servantFinished"><img src="{$mediaPath}/find.gif" border="0" alt="Nouvelle recherche"/></a>
         </td>
         <td class="uportal-label" nowrap="true">
            <a href="{$baseActionURL}?servantFinished">Nouvelle recherche</a>
         </td>
         <td width="5%">&#160;</td>
         <td valign="absmiddle">
         	<a href="{$baseActionURL}?servantFinshed&amp;action=default"><img src="{$mediaPath}/back.gif" border="0" alt="Retour au sommaire"/></a>
         </td>
         <td class="uportal-label" nowrap="true">
            <a href="{$baseActionURL}?servantFinished&amp;sommaire=default">Retour au sommaire</a>
         </td>
		<td width="100%">&#160;</td>
		</tr>
		</table>
<hr/>
      </xsl:if>

<!-- Chemin parcouru dans l'arbre de recherche -->
      <xsl:apply-templates select="niveaux" />

<!-- Affichage du libelle du niveau si on est pas au niveau initial dans le mode standalone -->
<xsl:if test="$modeServant=''">
      <xsl:if test="count(niveaux/niveau) &gt; 1">
         <table border="0" width="100%" cellspacing="0" cellpadding="5">
            <tr>
               <td class="uportal-channel-table-header" nowrap="true">
                  <xsl:value-of select="$libelle" />
               </td>

               <td width="100%"></td>
            </tr>
         </table>
      </xsl:if>
</xsl:if>

<!-- Affichage de la liste resultat -->
      <xsl:choose>
         <xsl:when test="count(composantes/composante)=0 and count(diplomes/diplome)=0 and count(etapes/etape)=0 and count(elements/element)=0">
            <table>
               <tr>
                  <td class="uportal-channel-error">Aucun rsultat disponible</td>
               </tr>
            </table>
         </xsl:when>

         <xsl:otherwise>
            <table border="0" cellspacing="0" cellpadding="4">
               <xsl:for-each select="composantes/composante | diplomes/diplome | etapes/etape | elements/element">
                  <xsl:call-template name="niveau">
                     <xsl:with-param name="action">
                        <xsl:value-of select="$action" />
                     </xsl:with-param>

                     <xsl:with-param name="id" select="@id" />

                     <xsl:with-param name="lib" select="@lib" />

                     <xsl:with-param name="vers" select="@vers" />

                     <xsl:with-param name="isDossier" select="@isDossier" />
                                         
                     <xsl:with-param name="retourServant" select="$modeServant" />

                     <xsl:with-param name="niveauServant" select="$niveauServant" /> 
                     
                     <xsl:with-param name="niveauChemin" select="(/xml/niveaux/niveau[position()=last()]/@niveau)+1" /> 
                     
                  </xsl:call-template>
               </xsl:for-each>
            </table>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
</xsl:stylesheet>

