package org.esupportail.portal.channels.gestion.CRechercheApogee;

import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.xml.sax.ContentHandler;

/** 
 * <p>Titre : RechercheApogeeServant</p>
 * <p>Description : Permet de parcourir l'arborescence des composantes/diplomes/etapes/elements d'Apogee en mode servant</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class CRechercheApogeeServant extends CRechercheApogee implements IServant {
	
	// niveau qui redonne la main au canal Matre
	private String niveauRetour;
	// indique que le servant a finit dans le cas o le traitement ne ncessite pas d'affichage 
	// par ex : passage de diplome et lment sans affichage de l'tape
	private boolean servantFinish;
	// rsultat retourn en mode servant
	private Niveau niveauEnCours;
	
	/**
	 * Constructeur
	 * @throws PortalException
	 */
	public CRechercheApogeeServant() throws PortalException  {
		super();
	}

	/**
	 * retourne true ou false si le servant a fini de travailler
	 * pour se terminer, le canal doit recevoir : servantFinished
	 * qui est en fait le nom d'un paramtre de la feuille xsl 
	 * ou avoir servantFinish  true
	 * @return True si le servant est fini, False sinon
	 */
	public boolean isFinished() {
		if (runtimeData.getParameter("servantFinished") != null || servantFinish)
			return true;
		return false;
	}

	/**
	 * Retourne un objet Niveau correspondant au niveau slectionn
	 * @return Object[] ( caster en Niveau), Null sinon
	 */
	public Object[] getResults() {
		Object[] res = new Object[1];
		res[0] = niveauEnCours;
		return res;
	}
	
	/**
	 * Ajoute un paramtre au staticData du servant
	 */
	public void setStaticData(ChannelStaticData sd) {
		// on fixe l'anne  utiliser pour les requtes
		annee = sd.getParameter("annee");
		// on fixe le niveau que l'on veut pouvoir slectionner
		niveauRetour = sd.getParameter("niveau");
		super.setStaticData(sd);
	}
	
	
	public void renderXML(ContentHandler out) throws PortalException {
		// on passe  toutes les subchannel non servant le fait qu'elles travaillent en mode servant (feuille XSL)
		if (!currentAction.isServant()) {
			// gestion des lments d'lments
			if (currentAction.getName().equals("sousElements")) 
				niveauRetour = "sousElements";
			else if (niveauRetour != null && niveauRetour.equals("sousElements")) // on raffecte le niveau  Elements si on remonte dans le chemin
				niveauRetour = "elements";
			if (niveauRetour != null) {
				currentSubChannel.getXSLParameter().put("modeServant",niveauRetour);
			}	
			else {
				currentSubChannel.getXSLParameter().put("modeServant","1");
			}	
			// passage du niveau en cours
			currentSubChannel.getXSLParameter().put("niveauServant",currentAction.getName());
		}	
		super.renderXML(out);
	}	

	/**
	 * @return Returns the niveauEnCours.
	 */
	protected Niveau getNiveauEnCours() {
		return niveauEnCours;
	}
	
	/**
	 * @param niveauEnCours The niveauEnCours to set.
	 */
	protected void setNiveauEnCours(Niveau niveauEnCours) {
		this.niveauEnCours = niveauEnCours;
	}
	
	/**
	 * @return Returns the servantFinish.
	 */
	protected boolean isServantFinish() {
		return servantFinish;
	}
	/**
	 * @param servantFinish The servantFinish to set.
	 */
	protected void setServantFinish(boolean servantFinish) {
		this.servantFinish = servantFinish;
	}
	/**
	 * @return Returns the niveauRetour.
	 */
	protected String getNiveauRetour() {
		return niveauRetour;
	}
	/**
	 * @param niveauRetour The niveauRetour to set.
	 */
	protected void setNiveauRetour(String niveauRetour) {
		this.niveauRetour = niveauRetour;
	}
}
