<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />

<!-- Affichage de la liste resultat -->
   <xsl:template name="niveau">
      <xsl:param name="action" />

      <xsl:param name="id" />

      <xsl:param name="lib" />

      <xsl:param name="vers" />

      <xsl:param name="isDossier" />

      <xsl:param name="retourServant" />

      <xsl:param name="niveauServant" />

<!-- Niveau dans le chemin de parcours -->
      <xsl:param name="niveauChemin" />

      <tr>
         <td valign="absmiddle">
            <xsl:choose>
               <xsl:when test="$isDossier='0'">
                  <img src="{$mediaPath}/page.gif" />
               </xsl:when>

               <xsl:otherwise>
                  <img src="{$mediaPath}/folder.gif" />
               </xsl:otherwise>
            </xsl:choose>
         </td>

         <td class="uportal-label">
            <xsl:choose>
               <xsl:when test="$retourServant=$niveauServant and $retourServant != ''">
                  <xsl:choose>
                     <xsl:when test="$isDossier='1'">
                        <table>
                           <tr>
                              <td class="uportal-label">
                                 <a href="{$baseActionURL}?action={$action}&amp;id={$id}&amp;vers={$vers}">
                                    <xsl:value-of select="$lib" />
                                 </a>
                              </td>

                              <td class="uportal-label" valign="absmiddle">
                                 <a href="{$baseActionURL}?action={$action}&amp;id={$id}&amp;vers={$vers}&amp;servantFinished">
                                    <img src="{$mediaPath}valid.gif" border="0" alt="Slectionner" />
                                 </a>
                              </td>

                              <td class="uportal-channel-text">
                                 <a href="{$baseActionURL}?action={$action}&amp;id={$id}&amp;vers={$vers}&amp;servantFinished">Slectionner</a>
                              </td>
                           </tr>
                        </table>
                     </xsl:when>

                     <xsl:otherwise>
                        <a href="{$baseActionURL}?action={$action}&amp;id={$id}&amp;vers={$vers}&amp;servantFinished">
                           <xsl:value-of select="$lib" />
                        </a>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:when>

               <xsl:when test="$isDossier='0'">
                  <xsl:value-of select="$lib" />
               </xsl:when>

               <xsl:otherwise>
               <a href="{$baseActionURL}?action={$action}&amp;id={$id}&amp;vers={$vers}&amp;niveau={$niveauChemin}">
                  <xsl:value-of select="$lib" />
               </a>
               </xsl:otherwise>
            </xsl:choose>
         </td>
      </tr>
   </xsl:template>
</xsl:stylesheet>

