/*
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 */ 
package org.esupportail.portal.utils.connectors;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;

import org.apache.commons.digester.*;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author oziller
 *
 * Cette classe a pour objet de lire et maintenir un accs vers les proprits du connecteur Apoge
 * 
 */
public class ApogeeConnectorConfig { 
		// Log
	private static final Log log = LogFactory.getLog(ApogeeConnectorConfig.class);
		// Singleton de la classe
	private static ApogeeConnectorConfig singleton = null;
	   	// Pool de connexion  utiliser 
	private String pool = null;
		// Attribut de la personne qui sert  faire le mapping
	private String personattribute = null;
		// Requete qui nous donne le COD_IND connaissant la valeur de l'attribut de mapping
	private String sqlmapping = null;
		// Classe qui nous donne l'attribut de mapping connaissant la valeur du login
	private String classmapping= null;
		// HashMap de mapping des comptes de demo
	private HashMap demomapping;

	/**
	 * Constructeur de la classe
	 * Il lit le fichier de configuration et en extrait les paramtres du connecteur Apoge.
	 *
	 */
	private ApogeeConnectorConfig() {
		// Cration d'une instance Digester 
		Digester dig = new Digester();
		//On rend l'objet disponible  la manipulation en le mettant en haut de la pile
		dig.push(this);
		//Chaque fois que "config" sera lu  la lecture du fichier de config on fera appelle  la mthode addRoot() avec 4 paramtres
		dig.addCallMethod("config","addRoot",4);
		//Premier paramtre de la mthode addRoot()
		dig.addCallParam("config/pool",0);
		//Deuxime paramtre de la mthode addRoot()
		dig.addCallParam("config/personattribute",1);
		//Troisime paramtre de la mthode addRoot()
		dig.addCallParam("config/sqlmapping",2);
		dig.addCallParam("config/classmapping",3);
		// Mapping des comptes de demo
		dig.addObjectCreate("config/demomapping/demo",Demo.class);
		dig.addSetProperties("config/demomapping/demo");
		dig.addSetNext("config/demomapping/demo","addDemo");
		// Emplacement du fichier de config  parser  partir du rpertoire classes
		URL resourceURL =  ApogeeConnectorConfig.class.getResource("/properties/channels/org_esup/connectors/ApogeeConnector.xml");
		if (resourceURL != null){
			try {
				// Parsing du fichier dont le chemin est pass en paramtre
				dig.parse(new InputSource(resourceURL.toExternalForm()));
			 }
			catch (IOException e) {
				 log.error("Config::Config() : ERREUR : Impossible d'ouvrir le fichier de config ApogeeConnector.xml\n" + e.toString());
			}
			catch (SAXException e) {
				log.error("Config::Config() : ERREUR : SAXException :\n" + e.toString());
			} 
			catch (Exception e) {
				log.error("Config::Config() : ERREUR : de lecture du fichier de config\n" + e.toString());
			}
		}
		else{
			log.error("Config::Config() : ERREUR : ApogeeConnector n'existe pas.\n");
		}	
	}
	
	/**
	* Methode ncessaire au digester.
	* 
	* @param pool
	* @param personAttribute
	* @param sqlMapping
	* @param classMapping
	* 
	*/
	public void addRoot(String pool, String personattribute,String sqlmapping, String classmapping) throws ConnectorException  {
		this.pool = pool;
		this.personattribute = personattribute;
		this.sqlmapping = sqlmapping;
		this.classmapping = classmapping;
		// Logs
		if (log.isDebugEnabled()) {
			log.debug("pool=" + this.pool);
			log.debug("personattribute=" + this.personattribute);
			log.debug("sqlmapping=" + this.sqlmapping);
			log.debug("classmapping=" + this.classmapping);
		}
		// Vrifications sur la validit de la configuration
		if (this.personattribute == null)
		  throw new ConnectorException("Connecteur Apoge : l'attribut de la personne n'est pas prcis");
		if ((this.pool != null) && (this.sqlmapping == null))
			throw new ConnectorException("Connecteur Apoge : il faut prciser une requte de mapping sql");
		if ((this.pool == null) && (this.sqlmapping != null))
			throw new ConnectorException("Connecteur Apoge : il faut prciser le pool sur lequel excuter la requte de mapping sql");
	}

	/**
	 * Mthode appele par le digester lorsqu'un demomapping a t lu dans le fichier de config
	 * @param d
	 */
	public void addDemo(Demo d) {
		if (demomapping == null) {
			demomapping = new HashMap();
		}
		if (d != null)
			demomapping.put(d.getLogin(),d.getCodind());
	}
	
	/**
	 * Retourne la HashMap de mapping des comptes de demo
	 * @return
	 */
	public HashMap getDemomapping() {
		return demomapping;
	}
	
	/**
	 * Positionne la HashMap de mapping des comptes de demo
	 */
	public void setDemomapping(HashMap demomapping) {
		this.demomapping = demomapping;
	}
	
	/**
	* Accs  l'occurence du singleton.
	* 
	* @return Config Instance
	* @throws IOException
	* @throws JspException
	*/
	public static ApogeeConnectorConfig getInstance() {
	
		if (singleton == null) {
			 singleton = new ApogeeConnectorConfig();
		 	}
		return singleton;
	}
	
	/**
	 * @return
	 */
	public String getPersonAttribute() {
		return personattribute;
	}

	/**
	 * @return
	 */
	public String getPool() {
		return pool;
	}

	/**
	 * @return
	 */
	public String getSqlMapping() {
		return sqlmapping;
	}

	/**
	 * @param string
	 */
	public void setPersonAttribute(String string) {
		personattribute = string;
	}

	/**
	 * @param string
	 */
	public void setPool(String string) {
		pool = string;
	}

	/**
	 * @param string
	 */
	public void setSqlMapping(String string) {
		sqlmapping = string;
	}

	/**
	 * @return Returns the classmapping.
	 */
	public String getClassmapping() {
		return classmapping;
	}
	/**
	 * @param classmapping The classmapping to set.
	 */
	public void setClassmapping(String classmapping) {
		this.classmapping = classmapping;
	}
	
}