/*
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 * 
 */
package org.esupportail.portal.utils.connectors;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;

import org.jasig.portal.RDBMServices;
import org.jasig.portal.RDBMServices.PreparedStatement;
import org.jasig.portal.security.IPerson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author oziller
 *
 * Cette classe permet de retrouver le COD_IND (identifiant Apoge) d'un tudiant
 * connaissant son login.
 * Cette classe utilise le fichier de proprits ApogeeConnector.xml
 * Cette classe est implmente sous forme d'un singleton.
 */
public class ApogeeConnector {

	// log
	private static final Log log = LogFactory.getLog(ApogeeConnector.class);
	private static ApogeeConnector instance = null;
	private static String attributeName = null;
	// objet dsignant la classe retournant l'attribut de mapping connaissant la valeur du login
	private static IClassMapping res = null;
	
	/**
	 * Constructeur de la classe. Il est priv puisqu'il s'agit d'un singleton
	 * Initialise le nom de l'attribut dans lequel sera cach le COD_IND
	 */
	private ApogeeConnector() {
		attributeName = getClass().getName() + ".COD_IND";
	}
	
	/**
	 * Retourne le singleton de la classe ApogeeConnector.
	 * @return l'objet unique ApogeeConnector
	 */
	private static ApogeeConnector getInstance() {
		if (instance == null)
			instance = new ApogeeConnector();
		return instance;
	}
	
	/**
	 * Retourne un COD_IND connaissant la valeur du login
	 * @param login login de la personne
	 * @return la valeur du COD_IND pour le paramtre pass
	 * @throws ConnectorException
	 */
	public static String getCOD_INDFromLogin(String login) throws ConnectorException {
		String personAttribute = null;
		personAttribute = getPersonAttributeFromLogin(login);
		
		return getCOD_IND(personAttribute);
	}
	
	
	/**
	 * Retourne le personAttribute  utiliser pour faire le mapping connaissant la valeur du login 
	 * @param login login de la personne
	 * @return le personAttribute  utiliser pour faire le mapping
	 * @throws ConnectorException
	 */
	private static String getPersonAttributeFromLogin(String login) {
		String resLogin = null;

		if (ApogeeConnectorConfig.getInstance().getClassmapping() == null || 
		   (ApogeeConnectorConfig.getInstance().getClassmapping() != null && ApogeeConnectorConfig.getInstance().getClassmapping().equals(""))
		) {
			if (log.isDebugEnabled())
				log.debug("ApogeeConnector::getPersonAttributeFromLogin() : Valeur reue retourne");
			resLogin = login;
		}	
		else {
			Class classmapping = null;
			Object classmappingObj = null;
			if (res == null) {
				// Instanciation de la classe charge de rcuprer le personne Attribute
				try {
					if (log.isDebugEnabled()) {
						log.debug("ApogeeConnector::getPersonAttributeFromLogin() : Tentative d'instanciation de la classmapping " + ApogeeConnectorConfig.getInstance().getClassmapping());
						log.debug("ApogeeConnector::getPersonAttributeFromLogin() : Recherche classmapping ");
					}
					classmapping = Class.forName(ApogeeConnectorConfig.getInstance().getClassmapping());
					if (log.isDebugEnabled())
						log.debug("ApogeeConnector::getPersonAttributeFromLogin() : Recherche types params constructeur classmapping ");
					Class[] types = {};
					if (log.isDebugEnabled())
						log.debug("ApogeeConnector::getPersonAttributeFromLogin() : Recherche constructeur ");
					Constructor cons = classmapping.getConstructor(types);
					Object[] params = {};
					if (log.isDebugEnabled())
						log.debug("ApogeeConnector::getPersonAttributeFromLogin() : Utilisation constructeur ");
					classmappingObj = cons.newInstance(params);
					res = (IClassMapping)classmappingObj;
					if (log.isDebugEnabled())
						log.debug("ApogeeConnector::getPersonAttributeFromLogin() :  Instanciation de la sub-channel " + 
							ApogeeConnectorConfig.getInstance().getClassmapping() + " russie !");
				}
				catch (Exception e) {
					res = null;
					log.error("ApogeeConnector::getPersonAttributeFromLogin() :  Echec de l'instanciation de la classmapping :  " + 
							ApogeeConnectorConfig.getInstance().getClassmapping());
				}
			}
			if (log.isDebugEnabled())
				log.debug("ApogeeConnector::getPersonAttributeFromLogin() : Appel de la mthode de rcupration du personAtribute ");
			resLogin = res.getPersonAttributeFromLogin(login);
		}
		return resLogin;
	}
	
	
	/**
	 * Retourne un COD_IND connaissant la valeur de l'attribut qui nous permet de faire le mapping.
	 * @param personAttributeValue la valeur du paramtre de la requte sql de mapping
	 * @return la valeur du COD_IND pour le paramtre pass
	 * @throws ConnectorException
	 */
	public static String getCOD_IND(String personAttributeValue) throws ConnectorException {
		Connection con = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		String res = null;

		// cas particuler ou le sqlmapping est null ou vide = cela veut dire qu'on retourne directement
		// l'attribut pass en paramtre
		if (ApogeeConnectorConfig.getInstance().getSqlMapping() == null)
			return personAttributeValue;
		else
			if (ApogeeConnectorConfig.getInstance().getSqlMapping().equals(""))
				return personAttributeValue;
			else
			// sinon interrogation de la base de donnes		
			try {
				try {
					con =
						RDBMServices.getConnection(
							ApogeeConnectorConfig.getInstance().getPool());
					stmt =
						new RDBMServices.PreparedStatement(
							con,
							ApogeeConnectorConfig.getInstance().getSqlMapping());
					stmt.clearParameters();
					stmt.setString(1, personAttributeValue);
					rs = stmt.executeQuery();
					if (rs.next())
						res = rs.getString("COD_IND");
					else
					  throw new ConnectorException("Impossible de trouver un COD_IND pour la valeur " + personAttributeValue);		
				}
				finally {
					if (rs != null)
						rs.close();
					if (stmt != null)
						stmt.close();
					if (con != null)
						con.close();
				}
			} 
			catch (Exception e) {
				// echec de la rcupration du COD_IND
				throw new ConnectorException("Erreur sur la requte de mapping Apoge : " +
				  e.toString()); 
			}
		return res;
	}
	
	/**
	 * Retourne le COD_IND associ  une personne (reprsente par un objet IPerson).
	 * Le rsultat est mis en cache pour la personne ce qui vite ensuite de relancer des requtes SQL
	 * @param person la personne pour laquelle on recherche le COD_IND
	 * @return la valeur du COD_IND pour la personne
	 * @throws ConnectorException
	 */
	public static String getCOD_IND(IPerson person) throws ConnectorException {
		String res = null;
		
		// Rcupration de la HashMap de mapping pour les cpts de demo
		HashMap demomapping = ApogeeConnectorConfig.getInstance().getDemomapping();
		// Tentative de rcupration d'un mapping pour le login du user connect
		if (demomapping != null) {
			res = (String) demomapping.get(person.getAttribute(IPerson.USERNAME));
			// Si russie, on retourne le codind correspondant
			if (res != null && !res.equals("")) 
				return res;	
		}
		// Recherche de l'attribut COD_IND en cache
		res = (String)person.getAttribute(getInstance().getAttributeName());
		// Si l'attribut COD_IND existe dj pour la personne 
		if (res != null)
			return res;
	    // Sinon on recherche sa valeur et on l'enregistre
	    // Recherche de l'attribut de mapping pour la personne en cours
	    String attributeValue = (String)person.getAttribute(ApogeeConnectorConfig.getInstance().getPersonAttribute());
	    // AB.20050307 Prise en compte de la classe de mapping	   
	      //OZ.20060428 Gestion cas o classe mapping est null
	    if (ApogeeConnectorConfig.getInstance().getClassmapping() != null)
	    	if (!ApogeeConnectorConfig.getInstance().getClassmapping().equals(""))
	    		attributeValue = getPersonAttributeFromLogin(attributeValue);
	    // Cet attribut doit tre valu
	    if (attributeValue == null)
	    	throw new ConnectorException("L'attribut " + ApogeeConnectorConfig.getInstance().getPersonAttribute() + " n'est pas valu pour la personne");
	   	// Recherche de la valeur du COD_IND connaissant la valeur de l'attribut de mapping
	    res = getCOD_IND(attributeValue);
	    // Enregistrement du rsultat dans le cache
	    person.setAttribute(getInstance().getAttributeName(),res);
	    // Retour du COD_IND
	    return res;
	}
	
	/**
	 * @return le nom de l'attribut d'une personne dans lequel on va stocker le COD_IND
	 */
	public String getAttributeName() {
		return attributeName;
	}

}
