/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.serialize.CachingSerializer;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.SAX2FilterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CharacterCachingChannelIncorporationFilter
extends SAX2FilterImpl {
    private boolean insideChannelElement = false;
    ChannelManager cm;
    private String channelSubscribeId;
    private boolean ccaching;
    private CachingSerializer ser;
    Vector systemCCacheBlocks;
    Vector channelIdBlocks;

    public CharacterCachingChannelIncorporationFilter(ContentHandler handler, ChannelManager chanm, boolean ccaching) {
        super(handler);
        if (handler instanceof CachingSerializer) {
            this.ser = (CachingSerializer)((Object)handler);
            this.ccaching = true;
        } else {
            this.ccaching = false;
        }
        this.cm = chanm;
        boolean bl = this.ccaching = this.ccaching && ccaching;
        if (this.ccaching) {
            LogService.log(LogService.DEBUG, "CharacterCachingChannelIncorporationFilter() : ccaching=true");
            this.systemCCacheBlocks = new Vector();
            this.channelIdBlocks = new Vector();
        } else {
            LogService.log(LogService.DEBUG, "CharacterCachingChannelIncorporationFilter() : ccaching=false");
        }
    }

    public Vector getSystemCCacheBlocks() {
        if (this.ccaching) {
            return this.systemCCacheBlocks;
        }
        return null;
    }

    public Vector getChannelIdBlocks() {
        if (this.ccaching) {
            return this.channelIdBlocks;
        }
        return null;
    }

    public void startDocument() throws SAXException {
        if (this.ccaching) {
            try {
                if (!this.ser.startCaching()) {
                    LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::startDocument() : unable to start caching!");
                }
            }
            catch (IOException ioe) {
                LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::startDocument() : unable to start caching!");
            }
        }
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.ccaching) {
            try {
                if (this.ser.stopCaching()) {
                    try {
                        this.systemCCacheBlocks.add(this.ser.getCache());
                    }
                    catch (UnsupportedEncodingException e) {
                        LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::endDocument() : unable to obtain character cache, invalid encoding specified ! " + e);
                    }
                    catch (IOException ioe) {
                        LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::endDocument() : IO exception occurred while retreiving character cache ! " + ioe);
                    }
                } else {
                    LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::endDocument() : unable to stop caching!");
                }
            }
            catch (IOException ioe) {
                LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::endDocument() : unable to stop caching! Exception: " + ioe.getMessage());
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        block8: {
            if (!this.insideChannelElement) {
                if (qName.equals("channel")) {
                    this.insideChannelElement = true;
                    this.channelSubscribeId = atts.getValue("ID");
                    if (this.ccaching) {
                        try {
                            if (this.ser.stopCaching()) {
                                this.systemCCacheBlocks.add(this.ser.getCache());
                                break block8;
                            }
                            LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::startElement() : unable to reset cache state ! Serializer was not caching when it should've been !");
                        }
                        catch (UnsupportedEncodingException e) {
                            LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::startElement() : unable to obtain character cache, invalid encoding specified ! " + e);
                        }
                        catch (IOException ioe) {
                            LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::startElement() : IO exception occurred while retreiving character cache ! " + ioe);
                        }
                    }
                } else {
                    super.startElement(uri, localName, qName, atts);
                }
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.insideChannelElement) {
            if (qName.equals("channel")) {
                this.insideChannelElement = false;
                if (this.getContentHandler() != null) {
                    if (this.ccaching) {
                        this.channelIdBlocks.add(this.channelSubscribeId);
                    }
                    this.cm.outputChannel(this.channelSubscribeId, this.getContentHandler());
                    if (this.ccaching) {
                        try {
                            if (!this.ser.startCaching()) {
                                LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::endElement() : unable to restart cache after a channel end!");
                            }
                        }
                        catch (IOException ioe) {
                            LogService.log(LogService.ERROR, "CharacterCachingChannelIncorporationFilter::endElement() : unable to start caching!");
                        }
                    }
                }
            }
        } else {
            super.endElement(uri, localName, qName);
        }
    }
}

