/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelParameter;
import org.jasig.portal.ChannelType;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.CounterStoreFactory;

public class RDBMChannelRegistryStore
implements IChannelRegistryStore {
    protected static final boolean localeAware;
    static /* synthetic */ Class class$org$jasig$portal$ChannelDefinition;

    public ChannelType newChannelType() throws Exception {
        int nextChanTypeId = CounterStoreFactory.getCounterStoreImpl().getIncrementIntegerId("UP_CHAN_TYPE");
        return new ChannelType(nextChanTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelType getChannelType(int channelTypeId) throws SQLException {
        ChannelType channelType = null;
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String query = "SELECT * FROM UP_CHAN_TYPE WHERE TYPE_ID=" + channelTypeId;
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.getChannelType(): " + query);
                ResultSet rs = stmt.executeQuery(query);
                try {
                    if (rs.next()) {
                        String javaClass = rs.getString("TYPE");
                        String name = rs.getString("TYPE_NAME");
                        String descr = rs.getString("TYPE_DESCR");
                        String cpdUri = rs.getString("TYPE_DEF_URI");
                        channelType = new ChannelType(channelTypeId);
                        channelType.setJavaClass(javaClass);
                        channelType.setName(name);
                        channelType.setDescription(descr);
                        channelType.setCpdUri(cpdUri);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return channelType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelType[] getChannelTypes() throws SQLException {
        ChannelType[] channelTypes = null;
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String query = "SELECT TYPE_ID, TYPE, TYPE_NAME, TYPE_DESCR, TYPE_DEF_URI FROM UP_CHAN_TYPE";
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.getChannelTypes(): " + query);
                ResultSet rs = stmt.executeQuery(query);
                try {
                    ArrayList<ChannelType> channelTypesList = new ArrayList<ChannelType>();
                    while (rs.next()) {
                        int channelTypeId = rs.getInt(1);
                        String javaClass = rs.getString(2);
                        String name = rs.getString(3);
                        String descr = rs.getString(4);
                        String cpdUri = rs.getString(5);
                        ChannelType channelType = new ChannelType(channelTypeId);
                        channelType.setJavaClass(javaClass);
                        channelType.setName(name);
                        channelType.setDescription(descr);
                        channelType.setCpdUri(cpdUri);
                        channelTypesList.add(channelType);
                    }
                    channelTypes = channelTypesList.toArray(new ChannelType[0]);
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return channelTypes;
    }

    public void saveChannelType(ChannelType chanType) throws SQLException {
        block21: {
            Connection con;
            block20: {
                con = null;
                ChannelType chanTypeInStore = this.getChannelType(chanType.getId());
                if (chanTypeInStore != null) break block20;
                try {
                    int chanTypeId = chanType.getId();
                    String javaClass = chanType.getJavaClass();
                    String name = chanType.getName();
                    String descr = chanType.getDescription();
                    String cpdUri = chanType.getCpdUri();
                    con = RDBMServices.getConnection();
                    RDBMServices.setAutoCommit(con, false);
                    Statement stmt = con.createStatement();
                    try {
                        String insert = "INSERT INTO UP_CHAN_TYPE VALUES ('" + chanTypeId + "', " + "'" + javaClass + "', " + "'" + name + "', " + "'" + descr + "', " + "'" + cpdUri + "')";
                        LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.saveChannelType(): " + insert);
                        int rows = stmt.executeUpdate(insert);
                        RDBMServices.commit(con);
                    }
                    catch (SQLException sqle) {
                        RDBMServices.rollback(con);
                        throw sqle;
                    }
                    finally {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    try {
                        throw new SQLException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        RDBMServices.releaseConnection(con);
                        throw throwable;
                    }
                }
                RDBMServices.releaseConnection(con);
                break block21;
            }
            try {
                int chanTypeId = chanType.getId();
                String javaClass = chanType.getJavaClass();
                String name = chanType.getName();
                String descr = chanType.getDescription();
                String cpdUri = chanType.getCpdUri();
                con = RDBMServices.getConnection();
                RDBMServices.setAutoCommit(con, false);
                Statement stmt = con.createStatement();
                try {
                    String update = "UPDATE UP_CHAN_TYPE SET TYPE='" + javaClass + "', " + "TYPE_NAME='" + name + "', " + "TYPE_DESCR='" + descr + "', " + "TYPE_DEF_URI='" + cpdUri + "' " + "WHERE TYPE_ID=" + chanTypeId;
                    LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.saveChannelType(): " + update);
                    int rows = stmt.executeUpdate(update);
                    RDBMServices.commit(con);
                }
                catch (SQLException sqle) {
                    RDBMServices.rollback(con);
                    throw sqle;
                }
                finally {
                    stmt.close();
                }
            }
            catch (Exception e) {
                try {
                    throw new SQLException(e.getMessage());
                }
                catch (Throwable throwable) {
                    RDBMServices.releaseConnection(con);
                    throw throwable;
                }
            }
            RDBMServices.releaseConnection(con);
        }
    }

    public void deleteChannelType(ChannelType chanType) throws SQLException {
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                int chanTypeId = chanType.getId();
                String select = "SELECT * FROM UP_CHANNEL WHERE CHAN_TYPE_ID=" + chanTypeId;
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.deleteChannelType(): " + select);
                ResultSet rs = stmt.executeQuery(select);
                if (rs.next()) {
                    String message = "Cannot delete channel type " + chanTypeId + ".  It is still in use by channels ";
                    do {
                        int channelPublishId = rs.getInt("CHAN_ID");
                        message = message + channelPublishId + " ";
                    } while (rs.next());
                    throw new SQLException(message);
                }
                String delete = "DELETE FROM UP_CHAN_TYPE WHERE TYPE_ID=" + chanTypeId;
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.deleteChannelType(): " + delete);
                int rows = stmt.executeUpdate(delete);
                RDBMServices.commit(con);
            }
            catch (SQLException sqle) {
                RDBMServices.rollback(con);
                throw sqle;
            }
            finally {
                stmt.close();
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    public ChannelDefinition newChannelDefinition() throws Exception {
        int nextChanDefId = CounterStoreFactory.getCounterStoreImpl().getIncrementIntegerId("UP_CHANNEL");
        return new ChannelDefinition(nextChanDefId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDefinition getChannelDefinition(int channelPublishId) throws SQLException {
        ChannelDefinition channelDef = null;
        try {
            channelDef = (ChannelDefinition)EntityCachingService.instance().get(class$org$jasig$portal$ChannelDefinition == null ? (class$org$jasig$portal$ChannelDefinition = RDBMChannelRegistryStore.class$("org.jasig.portal.ChannelDefinition")) : class$org$jasig$portal$ChannelDefinition, String.valueOf(channelPublishId));
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
        if (channelDef == null) {
            Connection con = null;
            RDBMServices.PreparedStatement pstmtChannel = null;
            RDBMServices.PreparedStatement pstmtChannelParam = null;
            RDBMServices.PreparedStatement pstmtChannelMdata = null;
            ResultSet rs = null;
            try {
                con = RDBMServices.getConnection();
                pstmtChannel = RDBMChannelRegistryStore.getChannelPstmt(con);
                pstmtChannelParam = RDBMChannelRegistryStore.getChannelParamPstmt(con);
                pstmtChannelMdata = RDBMChannelRegistryStore.getChannelMdataPstmt(con);
                pstmtChannel.clearParameters();
                pstmtChannel.setInt(1, channelPublishId);
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.getChannelDefinition(): " + pstmtChannel);
                rs = pstmtChannel.executeQuery();
                if (rs.next()) {
                    int chanType = rs.getInt(4);
                    if (rs.wasNull()) {
                        chanType = 0;
                    }
                    int publisherId = rs.getInt(5);
                    if (rs.wasNull()) {
                        publisherId = 0;
                    }
                    int approverId = rs.getInt(6);
                    if (rs.wasNull()) {
                        approverId = 0;
                    }
                    int timeout = rs.getInt(9);
                    if (rs.wasNull()) {
                        timeout = 0;
                    }
                    channelDef = new ChannelDefinition(channelPublishId);
                    channelDef.setTitle(rs.getString(1));
                    channelDef.setDescription(rs.getString(2));
                    channelDef.setJavaClass(rs.getString(3));
                    channelDef.setTypeId(chanType);
                    channelDef.setPublisherId(publisherId);
                    channelDef.setApproverId(approverId);
                    channelDef.setPublishDate(rs.getTimestamp(7));
                    channelDef.setApprovalDate(rs.getTimestamp(8));
                    channelDef.setTimeout(timeout);
                    channelDef.setEditable(RDBMServices.dbFlag(rs.getString(10)));
                    channelDef.setHasHelp(RDBMServices.dbFlag(rs.getString(11)));
                    channelDef.setHasAbout(RDBMServices.dbFlag(rs.getString(12)));
                    channelDef.setName(rs.getString(13));
                    channelDef.setFName(rs.getString(14));
                    channelDef.setIsSecure(RDBMServices.dbFlag(rs.getString(15)));
                    int dbOffset = 0;
                    if (pstmtChannelParam == null) {
                        dbOffset = 15;
                    } else {
                        rs.close();
                        pstmtChannelParam.clearParameters();
                        pstmtChannelParam.setInt(1, channelPublishId);
                        LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.getChannelDefinition(): " + pstmtChannelParam);
                        rs = pstmtChannelParam.executeQuery();
                    }
                    while (pstmtChannelParam == null || rs.next()) {
                        String name = rs.getString(dbOffset + 1);
                        String value = rs.getString(dbOffset + 2);
                        String override = rs.getString(dbOffset + 3);
                        if (name != null) {
                            channelDef.addParameter(name, value, override);
                        }
                        if (pstmtChannelParam != null || rs.next()) continue;
                        break;
                    }
                    if (localeAware) {
                        rs.close();
                        pstmtChannelMdata.clearParameters();
                        pstmtChannelMdata.setInt(1, channelPublishId);
                        LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.getChannelDefinition(): " + pstmtChannelMdata);
                        try {
                            rs = pstmtChannelMdata.executeQuery();
                            while (pstmtChannelMdata == null || rs.next()) {
                                String locale = rs.getString(1);
                                channelDef.putChanTitles(locale, rs.getString(2));
                                channelDef.putChanDescs(locale, rs.getString(3));
                                channelDef.putChanNames(locale, rs.getString(4));
                                if (pstmtChannelMdata != null || rs.next()) continue;
                                break;
                            }
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, "RDBMChannelRegistryStore.getChannelDefinition(): Database being used is not internationalized. Execute `ant i18n-db' for internationalized database setting.");
                        }
                    }
                }
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.getChannelDefinition(): Read channel " + channelPublishId + " from the store");
                try {
                    EntityCachingService.instance().add(channelDef);
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, e);
                }
                Object var17_19 = null;
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                try {
                    rs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    pstmtChannel.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    pstmtChannelParam.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    pstmtChannelMdata.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    RDBMServices.releaseConnection(con);
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                pstmtChannel.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                pstmtChannelParam.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                pstmtChannelMdata.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                RDBMServices.releaseConnection(con);
            }
            catch (Exception e) {}
        }
        return channelDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDefinition getChannelDefinition(String channelFunctionalName) throws SQLException {
        ChannelDefinition channelDef = null;
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String query = "SELECT CHAN_ID FROM UP_CHANNEL WHERE CHAN_FNAME='" + channelFunctionalName + "' ORDER BY CHAN_APVL_DT DESC";
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.getChannelDefinition(): " + query);
                ResultSet rs = stmt.executeQuery(query);
                try {
                    if (rs.next()) {
                        channelDef = this.getChannelDefinition(rs.getInt("CHAN_ID"));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return channelDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDefinition[] getChannelDefinitions() throws SQLException {
        ChannelDefinition[] channelDefs = null;
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String query = "SELECT CHAN_ID FROM UP_CHANNEL";
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.getChannelDefinitions(): " + query);
                ResultSet rs = stmt.executeQuery(query);
                try {
                    ArrayList<ChannelDefinition> channelDefsList = new ArrayList<ChannelDefinition>();
                    while (rs.next()) {
                        ChannelDefinition channelDef = this.getChannelDefinition(rs.getInt("CHAN_ID"));
                        channelDefsList.add(channelDef);
                    }
                    channelDefs = channelDefsList.toArray(new ChannelDefinition[0]);
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return channelDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChannelDefinition(ChannelDefinition channelDef) throws SQLException {
        Connection con = RDBMServices.getConnection();
        try {
            int channelPublishId = channelDef.getId();
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String sqlTitle = RDBMServices.sqlEscape(channelDef.getTitle());
                String sqlDescription = RDBMServices.sqlEscape(channelDef.getDescription());
                String sqlClass = channelDef.getJavaClass();
                int sqlTypeID = channelDef.getTypeId();
                int chanPublisherId = channelDef.getPublisherId();
                String chanPublishDate = RDBMServices.sqlTimeStamp(channelDef.getPublishDate());
                int chanApproverId = channelDef.getApproverId();
                String chanApprovalDate = RDBMServices.sqlTimeStamp(channelDef.getApprovalDate());
                int sqlTimeout = channelDef.getTimeout();
                String sqlEditable = RDBMServices.dbFlag(channelDef.isEditable());
                String sqlHasHelp = RDBMServices.dbFlag(channelDef.hasHelp());
                String sqlHasAbout = RDBMServices.dbFlag(channelDef.hasAbout());
                String sqlName = RDBMServices.sqlEscape(channelDef.getName());
                String sqlFName = RDBMServices.sqlEscape(channelDef.getFName());
                String sqlIsSecure = RDBMServices.dbFlag(channelDef.isSecure());
                String query = "SELECT CHAN_ID FROM UP_CHANNEL WHERE CHAN_ID=" + channelPublishId;
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.addChannelDefinition(): " + query);
                ResultSet rs = stmt.executeQuery(query);
                if (rs.next()) {
                    String update = "UPDATE UP_CHANNEL SET CHAN_TITLE='" + sqlTitle + "', " + "CHAN_DESC='" + sqlDescription + "', " + "CHAN_CLASS='" + sqlClass + "', " + "CHAN_TYPE_ID=" + sqlTypeID + ", " + "CHAN_PUBL_ID=" + chanPublisherId + ", " + "CHAN_PUBL_DT=" + chanPublishDate + ", " + "CHAN_APVL_ID=" + chanApproverId + ", " + "CHAN_APVL_DT=" + chanApprovalDate + ", " + "CHAN_TIMEOUT=" + sqlTimeout + ", " + "CHAN_EDITABLE='" + sqlEditable + "', " + "CHAN_HAS_HELP='" + sqlHasHelp + "', " + "CHAN_HAS_ABOUT='" + sqlHasAbout + "', " + "CHAN_NAME='" + sqlName + "', " + "CHAN_FNAME='" + sqlFName + "', " + "CHAN_SECURE='" + sqlIsSecure + "' " + "WHERE CHAN_ID=" + channelPublishId;
                    LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.addChannelDefinition(): " + update);
                    stmt.executeUpdate(update);
                } else {
                    String insert = "INSERT INTO UP_CHANNEL (CHAN_ID, CHAN_TITLE, CHAN_DESC, CHAN_CLASS, CHAN_TYPE_ID, CHAN_PUBL_ID, CHAN_PUBL_DT, CHAN_APVL_ID, CHAN_APVL_DT, CHAN_TIMEOUT, CHAN_EDITABLE, CHAN_HAS_HELP, CHAN_HAS_ABOUT, CHAN_NAME, CHAN_FNAME, CHAN_SECURE) ";
                    insert = insert + "VALUES (" + channelPublishId + ", '" + sqlTitle + "', '" + sqlDescription + "', '" + sqlClass + "', " + sqlTypeID + ", " + chanPublisherId + ", " + chanPublishDate + ", " + chanApproverId + ", " + chanApprovalDate + ", " + sqlTimeout + ", '" + sqlEditable + "', '" + sqlHasHelp + "', '" + sqlHasAbout + "', '" + sqlName + "', '" + sqlFName + "', '" + sqlIsSecure + "')";
                    LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.addChannelDefinition(): " + insert);
                    stmt.executeUpdate(insert);
                }
                String delete = "DELETE FROM UP_CHANNEL_PARAM WHERE CHAN_ID=" + channelPublishId;
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.addChannelDefinition(): " + delete);
                int recordsDeleted = stmt.executeUpdate(delete);
                ChannelParameter[] parameters = channelDef.getParameters();
                if (parameters != null) {
                    for (int i = 0; i < parameters.length; ++i) {
                        String paramName = parameters[i].getName();
                        String paramValue = parameters[i].getValue();
                        boolean paramOverride = parameters[i].getOverride();
                        if (paramName == null && paramValue == null) {
                            throw new RuntimeException("Invalid parameter node");
                        }
                        String insert = "INSERT INTO UP_CHANNEL_PARAM (CHAN_ID, CHAN_PARM_NM, CHAN_PARM_VAL, CHAN_PARM_OVRD) VALUES (" + channelPublishId + ",'" + paramName + "','" + paramValue + "', '" + (paramOverride ? "Y" : "N") + "')";
                        LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.addChannelDefinition(): " + insert);
                        stmt.executeUpdate(insert);
                    }
                }
                RDBMServices.commit(con);
                try {
                    EntityCachingService.instance().update(channelDef);
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, e);
                }
            }
            catch (SQLException sqle) {
                LogService.log(LogService.ERROR, sqle);
                RDBMServices.rollback(con);
                throw sqle;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChannelDefinition(ChannelDefinition channelDef) throws SQLException, GroupsException {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                int channelPublishId = channelDef.getId();
                String delete = "DELETE FROM UP_CHANNEL WHERE CHAN_ID=" + channelPublishId;
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.deleteChannelDefinition(): " + delete);
                stmt.executeUpdate(delete);
                delete = "DELETE FROM UP_CHANNEL_PARAM WHERE CHAN_ID=" + channelPublishId;
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.deleteChannelDefinition(): " + delete);
                stmt.executeUpdate(delete);
                delete = "DELETE FROM UP_PERMISSION WHERE OWNER='CHAN_ID." + channelPublishId + "' OR TARGET='CHAN_ID." + channelPublishId + "'";
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.deleteChannelDefinition(): " + delete);
                stmt.executeUpdate(delete);
                delete = "DELETE FROM UPC_KEYWORD WHERE CHAN_ID=" + channelPublishId;
                LogService.log(LogService.DEBUG, "RDBMChannelRegistryStore.deleteChannelDefinition(): " + delete);
                stmt.executeUpdate(delete);
                IEntity channelDefEntity = GroupService.getEntity(String.valueOf(channelPublishId), class$org$jasig$portal$ChannelDefinition == null ? (class$org$jasig$portal$ChannelDefinition = RDBMChannelRegistryStore.class$("org.jasig.portal.ChannelDefinition")) : class$org$jasig$portal$ChannelDefinition);
                Iterator iter = channelDefEntity.getContainingGroups();
                while (iter.hasNext()) {
                    IEntityGroup parentGroup = (IEntityGroup)iter.next();
                    parentGroup.removeMember(channelDefEntity);
                    parentGroup.updateMembers();
                }
                try {
                    EntityCachingService.instance().remove(channelDef);
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, e);
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    public void approveChannelDefinition(ChannelDefinition channelDef, IPerson approver, Date approveDate) throws SQLException {
        channelDef.setApproverId(approver.getID());
        channelDef.setApprovalDate(approveDate);
        this.saveChannelDefinition(channelDef);
    }

    public void disapproveChannelDefinition(ChannelDefinition channelDef) throws SQLException {
        channelDef.setApproverId(-1);
        channelDef.setApprovalDate(null);
        this.saveChannelDefinition(channelDef);
    }

    public ChannelCategory newChannelCategory() throws GroupsException {
        IEntityGroup categoryGroup = GroupService.newGroup(class$org$jasig$portal$ChannelDefinition == null ? (class$org$jasig$portal$ChannelDefinition = RDBMChannelRegistryStore.class$("org.jasig.portal.ChannelDefinition")) : class$org$jasig$portal$ChannelDefinition);
        categoryGroup.setName("");
        categoryGroup.setCreatorID("");
        categoryGroup.update();
        String id = categoryGroup.getKey();
        return new ChannelCategory(id);
    }

    public ChannelCategory getChannelCategory(String channelCategoryId) throws GroupsException {
        IEntityGroup categoryGroup = GroupService.findGroup(channelCategoryId);
        ChannelCategory category = new ChannelCategory(channelCategoryId);
        category.setName(categoryGroup.getName());
        category.setDescription(categoryGroup.getDescription());
        category.setCreatorId(categoryGroup.getCreatorID());
        return category;
    }

    public ChannelCategory getTopLevelChannelCategory() throws GroupsException {
        IEntityGroup categoryGroup = GroupService.getDistinguishedGroup("org.jasig.portal.ChannelDefinition");
        return this.getChannelCategory(categoryGroup.getKey());
    }

    public ChannelCategory[] getChildCategories(ChannelCategory parent) throws GroupsException {
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        ArrayList<ChannelCategory> categories = new ArrayList<ChannelCategory>();
        Iterator iter = parentGroup.getMembers();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isGroup()) continue;
            String categoryId = gm.getKey();
            categories.add(this.getChannelCategory(categoryId));
        }
        return categories.toArray(new ChannelCategory[0]);
    }

    public ChannelDefinition[] getChildChannels(ChannelCategory parent) throws SQLException, GroupsException {
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        ArrayList<ChannelDefinition> channelDefs = new ArrayList<ChannelDefinition>();
        Iterator iter = parentGroup.getMembers();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isEntity()) continue;
            int channelPublishId = Integer.parseInt(gm.getKey());
            channelDefs.add(this.getChannelDefinition(channelPublishId));
        }
        return channelDefs.toArray(new ChannelDefinition[0]);
    }

    public ChannelCategory[] getParentCategories(ChannelCategory child) throws GroupsException {
        String childKey = String.valueOf(child.getId());
        IEntityGroup childGroup = GroupService.findGroup(childKey);
        ArrayList<ChannelCategory> parents = new ArrayList<ChannelCategory>();
        Iterator iter = childGroup.getContainingGroups();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isGroup()) continue;
            String categoryId = gm.getKey();
            parents.add(this.getChannelCategory(categoryId));
        }
        return parents.toArray(new ChannelCategory[0]);
    }

    public ChannelCategory[] getParentCategories(ChannelDefinition child) throws GroupsException {
        String childKey = String.valueOf(child.getId());
        IEntity childEntity = GroupService.getEntity(childKey, class$org$jasig$portal$ChannelDefinition == null ? (class$org$jasig$portal$ChannelDefinition = RDBMChannelRegistryStore.class$("org.jasig.portal.ChannelDefinition")) : class$org$jasig$portal$ChannelDefinition);
        ArrayList<ChannelCategory> parents = new ArrayList<ChannelCategory>();
        Iterator iter = childEntity.getContainingGroups();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isGroup()) continue;
            String categoryId = gm.getKey();
            parents.add(this.getChannelCategory(categoryId));
        }
        return parents.toArray(new ChannelCategory[0]);
    }

    public void saveChannelCategory(ChannelCategory category) throws GroupsException {
        IEntityGroup categoryGroup = GroupService.findGroup(category.getId());
        categoryGroup.setName(category.getName());
        categoryGroup.setDescription(category.getDescription());
        categoryGroup.setCreatorID(category.getCreatorId());
        categoryGroup.update();
    }

    public void deleteChannelCategory(ChannelCategory category) throws GroupsException {
        String key = String.valueOf(category.getId());
        IEntityGroup categoryGroup = GroupService.findGroup(key);
        categoryGroup.delete();
    }

    public void addCategoryToCategory(ChannelCategory child, ChannelCategory parent) throws GroupsException {
        String childKey = String.valueOf(child.getId());
        IEntityGroup childGroup = GroupService.findGroup(childKey);
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        parentGroup.addMember(childGroup);
        parentGroup.updateMembers();
    }

    public void removeCategoryFromCategory(ChannelCategory child, ChannelCategory parent) throws GroupsException {
        String childKey = String.valueOf(child.getId());
        IEntityGroup childGroup = GroupService.findGroup(childKey);
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup(parentKey);
        parentGroup.removeMember(childGroup);
        parentGroup.updateMembers();
    }

    public void addChannelToCategory(ChannelDefinition channelDef, ChannelCategory category) throws PortalException {
        String channelDefKey = String.valueOf(channelDef.getId());
        IEntity channelDefEntity = GroupService.getEntity(channelDefKey, class$org$jasig$portal$ChannelDefinition == null ? (class$org$jasig$portal$ChannelDefinition = RDBMChannelRegistryStore.class$("org.jasig.portal.ChannelDefinition")) : class$org$jasig$portal$ChannelDefinition);
        IEntityGroup categoryGroup = GroupService.findGroup(category.getId());
        categoryGroup.addMember(channelDefEntity);
        categoryGroup.updateMembers();
    }

    public void removeChannelFromCategory(ChannelDefinition channelDef, ChannelCategory category) throws PortalException {
        String channelDefKey = String.valueOf(channelDef.getId());
        IEntity channelDefEntity = GroupService.getEntity(channelDefKey, class$org$jasig$portal$ChannelDefinition == null ? (class$org$jasig$portal$ChannelDefinition = RDBMChannelRegistryStore.class$("org.jasig.portal.ChannelDefinition")) : class$org$jasig$portal$ChannelDefinition);
        String categoryKey = String.valueOf(category.getId());
        IEntityGroup categoryGroup = GroupService.findGroup(categoryKey);
        categoryGroup.removeMember(channelDefEntity);
        categoryGroup.updateMembers();
    }

    protected static final RDBMServices.PreparedStatement getChannelPstmt(Connection con) throws SQLException {
        String sql = "SELECT UC.CHAN_TITLE, UC.CHAN_DESC, UC.CHAN_CLASS, UC.CHAN_TYPE_ID, UC.CHAN_PUBL_ID, UC.CHAN_APVL_ID, UC.CHAN_PUBL_DT, UC.CHAN_APVL_DT, UC.CHAN_TIMEOUT, UC.CHAN_EDITABLE, UC.CHAN_HAS_HELP, UC.CHAN_HAS_ABOUT, UC.CHAN_NAME, UC.CHAN_FNAME, UC.CHAN_SECURE";
        sql = RDBMServices.supportsOuterJoins ? sql + ", CHAN_PARM_NM, CHAN_PARM_VAL, CHAN_PARM_OVRD, CHAN_PARM_DESC FROM " + RDBMServices.joinQuery.getQuery("channel") : sql + " FROM UP_CHANNEL UC WHERE";
        sql = sql + " UC.CHAN_ID=?";
        return new RDBMServices.PreparedStatement(con, sql);
    }

    protected static final RDBMServices.PreparedStatement getChannelParamPstmt(Connection con) throws SQLException {
        if (RDBMServices.supportsOuterJoins) {
            return null;
        }
        return new RDBMServices.PreparedStatement(con, "SELECT CHAN_PARM_NM, CHAN_PARM_VAL,CHAN_PARM_OVRD,CHAN_PARM_DESC FROM UP_CHANNEL_PARAM WHERE CHAN_ID=?");
    }

    protected static final RDBMServices.PreparedStatement getChannelMdataPstmt(Connection con) throws SQLException {
        return new RDBMServices.PreparedStatement(con, "SELECT LOCALE, CHAN_TITLE, CHAN_DESC, CHAN_NAME FROM UP_CHANNEL_MDATA WHERE CHAN_ID=?");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block5: {
            try {
                if (!RDBMServices.supportsOuterJoins) break block5;
                if (RDBMServices.joinQuery instanceof RDBMServices.JdbcDb) {
                    RDBMServices.joinQuery.addQuery("channel", "{oj UP_CHANNEL UC LEFT OUTER JOIN UP_CHANNEL_PARAM UCP ON UC.CHAN_ID = UCP.CHAN_ID} WHERE");
                    break block5;
                }
                if (RDBMServices.joinQuery instanceof RDBMServices.PostgreSQLDb) {
                    RDBMServices.joinQuery.addQuery("channel", "UP_CHANNEL UC LEFT OUTER JOIN UP_CHANNEL_PARAM UCP ON UC.CHAN_ID = UCP.CHAN_ID WHERE");
                    break block5;
                }
                if (RDBMServices.joinQuery instanceof RDBMServices.OracleDb) {
                    RDBMServices.joinQuery.addQuery("channel", "UP_CHANNEL UC, UP_CHANNEL_PARAM UCP WHERE UC.CHAN_ID = UCP.CHAN_ID(+) AND");
                    break block5;
                }
                throw new Exception("Unknown database driver");
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "RDBMChannelRegistryStore: Error in static initializer", e);
            }
        }
        localeAware = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.i18n.LocaleManager.locale_aware");
    }
}

