/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jndi;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.jasig.portal.PortalException;
import org.jasig.portal.services.ExternalServices;
import org.jasig.portal.services.LogService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JNDIManager {
    public static void initializePortalContext() throws PortalException {
        try {
            Context context = JNDIManager.getContext();
            ExternalServices.startServices(context.createSubcontext("services"));
            context.createSubcontext("users");
            context.createSubcontext("sessions");
            LogService.log(LogService.DEBUG, "JNDIManager::initializePortalContext() : initialized portal JNDI context");
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    public static void initializeSessionContext(HttpSession session, String userId, String layoutId, Document userLayout) throws PortalException {
        Context topContext = null;
        try {
            topContext = JNDIManager.getContext();
        }
        catch (NamingException ne) {
            LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): Unable to obtain initial context - " + ne.getMessage());
            return;
        }
        try {
            Context tsessionContext = (Context)topContext.lookup("/sessions");
            tsessionContext.bind(session.getId(), (Object)userId);
        }
        catch (NamingException ne) {
            LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): Unable to obtain /sessions context - " + ne.getMessage());
        }
        session.setAttribute("JNDISessionListener", (Object)new JNDISessionListener());
        String sessionId = session.getId();
        Context usersContext = null;
        try {
            usersContext = (Context)topContext.lookup("/users");
        }
        catch (NamingException ne) {
            LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): Could not find /users context - " + ne.getMessage());
            throw new PortalException("JNDIManager.initializeSessionContext(): Could not find /users context", (Exception)ne);
        }
        Context userIdContext = null;
        Context sessionsContext = null;
        Context layoutsContext = null;
        try {
            userIdContext = (Context)usersContext.lookup(userId);
            try {
                layoutsContext = (Context)userIdContext.lookup("layouts");
            }
            catch (NamingException ne) {
                LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): /users/" + userId + "/layouts - did not exist, even though /users/" + userId + " context did!");
                layoutsContext = userIdContext.createSubcontext("layouts");
            }
            try {
                sessionsContext = (Context)userIdContext.lookup("sessions");
            }
            catch (NamingException ne) {
                LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): context /users/" + userId + "/sessions - did not exist, even though /users/" + userId + " context did!");
                sessionsContext = userIdContext.createSubcontext("sessions");
            }
        }
        catch (NamingException ne) {
            try {
                userIdContext = usersContext.createSubcontext(userId);
                layoutsContext = userIdContext.createSubcontext("layouts");
                sessionsContext = userIdContext.createSubcontext("sessions");
                LogService.log(LogService.DEBUG, "JNDIManager.initializeSessionContext(): initialized context for a userId=\"" + userId + "\".");
            }
            catch (NamingException ne2) {
                LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): exception encountered while trying to create  /users/" + userId + " and layouts/sessions contexts ! " + ne2.getMessage());
                throw new PortalException("JNDIManager.initializeSessionContext(): exception encountered while trying to create  /users/" + userId + " and layouts/sessions contexts !", (Exception)ne2);
            }
        }
        Context sessionIdContext = null;
        try {
            sessionIdContext = sessionsContext.createSubcontext(sessionId);
        }
        catch (NameAlreadyBoundException nabe) {
            LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): trying to initialize session twice. sessionId=\"" + sessionId + "\"");
            throw new PortalException("JNDIManager.initializeSessionContext(): trying to initialize session twice. sessionId=\"" + sessionId + "\"", (Exception)nabe);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): error encountered while trying to create context /users/" + userId + "/sessions/" + sessionId + " " + e.getMessage());
            throw new PortalException("JNDIManager.initializeSessionContext(): error encountered while trying to create context /users/" + userId + "/sessions/" + sessionId, e);
        }
        try {
            sessionIdContext.bind("layoutId", (Object)layoutId);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): error encountered while trying to bind /users/" + userId + "/sessions/" + sessionId + "/layoutId " + e.getMessage());
            throw new PortalException("JNDIManager.initializeSessionContext(): error encountered while trying to bind /users/" + userId + "/sessions/" + sessionId + "/layoutId", e);
        }
        try {
            sessionIdContext.createSubcontext("channel-obj");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            try {
                Context layoutIdContext = (Context)layoutsContext.lookup(layoutId);
                try {
                    Context lsessionsContext = (Context)userIdContext.lookup("layouts/" + layoutId + "/sessions");
                    lsessionsContext.createSubcontext(sessionId);
                    LogService.log(LogService.DEBUG, "JNDIManager.initializeSessionContext(): created /users/" + userId + "/layouts/" + layoutId + "/sessions/" + sessionId);
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): exception occured while looking up context /users/" + userId + "/layouts/" + layoutId + "/sessions , although /users/" + userId + "/layouts context already existed ! " + e.getMessage());
                    throw new PortalException("JNDIManager.initializeSessionContext(): exception occured while looking up context /users/" + userId + "/layouts/" + layoutId + "/sessions , although /users/" + userId + "/layouts context already existed !", e);
                }
            }
            catch (NamingException nne) {
                Context layoutIdContext = layoutsContext.createSubcontext(layoutId);
                Context lsessionsContext = layoutIdContext.createSubcontext("sessions");
                lsessionsContext.createSubcontext(sessionId);
                LogService.log(LogService.DEBUG, "JNDIManager.initializeSessionContext(): created context /users/" + userId + "/layouts/" + layoutId);
                try {
                    Context channel_idsContext = layoutIdContext.createSubcontext("channel-ids");
                    NodeList channelNodes = userLayout.getElementsByTagName("channel");
                    Node fname = null;
                    Node instanceid = null;
                    for (int i = 0; i < channelNodes.getLength(); ++i) {
                        fname = channelNodes.item(i).getAttributes().getNamedItem("fname");
                        instanceid = channelNodes.item(i).getAttributes().getNamedItem("ID");
                        if (fname == null || instanceid == null) continue;
                        CompositeName cname = new CompositeName(fname.getNodeValue());
                        Enumeration<String> e = cname.getAll();
                        Context nextContext = channel_idsContext;
                        String subContextName = new String();
                        while (e.hasMoreElements()) {
                            subContextName = e.nextElement();
                            if (e.hasMoreElements()) {
                                nextContext = nextContext.createSubcontext(subContextName);
                                continue;
                            }
                            LogService.log(LogService.DEBUG, "JNDIManager.initializeSessionContext(): bound " + instanceid.getNodeValue() + " to " + nextContext.getNameInNamespace() + "/" + subContextName);
                            nextContext.rebind(subContextName, (Object)instanceid.getNodeValue());
                        }
                    }
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): exception occured while creating cahnnel-ids context. " + ne.getMessage());
                    throw new PortalException("JNDIManager.initializeSessionContext(): exception occured while creating cahnnel-ids context.", (Exception)ne);
                }
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "JNDIManager.initializeSessionContext(): exception occured while pupulating context /users/" + userId + "/layouts/" + layoutId + "  " + e.getMessage());
            throw new PortalException("JNDIManager.initializeSessionContext(): exception occured while pupulating context /users/" + userId + "/layouts/" + layoutId, e);
        }
    }

    private static Context getContext() throws NamingException {
        Hashtable<String, String> environment = new Hashtable<String, String>(5);
        environment.put("java.naming.factory.initial", "org.jasig.portal.jndi.PortalInitialContextFactory");
        InitialContext ctx = new InitialContext(environment);
        return ctx;
    }

    private static class JNDISessionListener
    implements HttpSessionBindingListener,
    Serializable {
        private JNDISessionListener() {
        }

        public void valueBound(HttpSessionBindingEvent bindingEvent) {
            LogService.log(LogService.INFO, "JNDISessionListener bound for: " + bindingEvent.getSession().getId());
        }

        public void valueUnbound(HttpSessionBindingEvent bindingEvent) {
            block33: {
                LogService.log(LogService.INFO, "JNDISessionListener unbound for: " + bindingEvent.getSession().getId());
                Context context = null;
                try {
                    context = JNDIManager.getContext();
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): Could not get portal context " + ne.getMessage());
                    return;
                }
                Context usersContext = null;
                try {
                    usersContext = (Context)context.lookup("/users");
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): Could not get /users context " + ne.getMessage());
                    return;
                }
                if (usersContext == null) {
                    return;
                }
                String sessionId = bindingEvent.getSession().getId();
                Context tsessionsContext = null;
                try {
                    tsessionsContext = (Context)context.lookup("/sessions");
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): Could not get /sessions context " + ne.getMessage());
                    return;
                }
                String userId = null;
                try {
                    userId = (String)tsessionsContext.lookup(sessionId);
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): Session " + sessionId + " does is not registered under /sessions context ! " + ne.getMessage());
                    return;
                }
                if (userId == null) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): Unable to determine userId for a session " + sessionId + " ... giving up on JNDI cleanup.");
                    return;
                }
                try {
                    tsessionsContext.unbind(sessionId);
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): Problems unbinding /sessions/" + sessionId + " " + ne.getMessage());
                }
                Context userIdContext = null;
                try {
                    userIdContext = (Context)usersContext.lookup(userId);
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): context /users/" + userId + " doesn't exist!");
                    return;
                }
                Context sessionsContext = null;
                try {
                    sessionsContext = (Context)userIdContext.lookup("sessions");
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): context /users/" + userId + "/sessions doesn't exist!");
                    return;
                }
                Context sessionIdContext = null;
                try {
                    sessionIdContext = (Context)sessionsContext.lookup(sessionId);
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): context /users/" + userId + "/sessions/" + sessionId + " doesn't exist!");
                    return;
                }
                String layoutId = null;
                try {
                    layoutId = (String)sessionIdContext.lookup("layoutId");
                }
                catch (NamingException ne) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): binding /users/" + userId + "/sessions/" + sessionId + "/layoutId doesn't exist!");
                }
                try {
                    sessionsContext.unbind(sessionId);
                    LogService.log(LogService.DEBUG, "JNDISessionListener.valueUnbound(): destroyed context /users/" + userId + "/sessions/" + sessionId);
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): exception occurred while trying to destroy context  /users/" + userId + "/sessions/" + sessionId + " " + e.getMessage());
                }
                try {
                    NamingEnumeration<NameClassPair> list = userIdContext.list("sessions");
                    if (!list.hasMore()) {
                        usersContext.unbind(userId);
                        LogService.log(LogService.DEBUG, "JNDISessionListener.valueUnbound(): destroyed context /users/" + userId + " since the last remaining session has been unbound.");
                        break block33;
                    }
                    try {
                        Context layoutsContext = (Context)userIdContext.lookup("layouts");
                        try {
                            Context layoutIdContext = (Context)layoutsContext.lookup(layoutId);
                            try {
                                Context lsessionsContext = (Context)layoutIdContext.lookup("sessions");
                                lsessionsContext.unbind(sessionId);
                                LogService.log(LogService.DEBUG, "JNDISessionListener.valueUnbound(): destroyed context /users/" + userId + "/layouts/" + layoutId + "/sessions/" + sessionId);
                                NamingEnumeration<NameClassPair> slist = layoutIdContext.list("sessions");
                                if (slist.hasMore()) break block33;
                                try {
                                    layoutsContext.unbind(layoutId);
                                    LogService.log(LogService.DEBUG, "JNDISessionListener.valueUnbound(): destroyed context /users/" + userId + "/layouts/" + layoutId + " since the last session using it has been unbound.");
                                }
                                catch (Exception e) {
                                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): error destroying /users/" + userId + "/layouts/" + layoutId + " " + e.getMessage());
                                }
                            }
                            catch (Exception e) {
                                LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): error looking up  /users/" + userId + "/layouts/" + layoutId + "/sesions " + e.getMessage());
                            }
                        }
                        catch (Exception e) {
                            LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): error looking up  /users/" + userId + "/layouts/" + layoutId + " " + e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): error looking up  /users/" + userId + "/layouts " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, "JNDISessionListener.valueUnbound(): error listing  /users/" + userId + "/sessions/ " + e.getMessage());
                }
            }
        }
    }
}

