/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.serialize;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jasig.portal.serialize.CharacterCachingWriter;

public class CachingWriter
extends Writer
implements CharacterCachingWriter {
    Writer out;
    StringWriter cache = null;
    boolean caching = false;

    public CachingWriter(Writer out) {
        this.out = out;
    }

    public boolean startCaching() throws IOException {
        if (this.caching) {
            return false;
        }
        this.flush();
        this.caching = true;
        this.cache = new StringWriter();
        return true;
    }

    public String getCache(String encoding) throws IOException {
        this.flush();
        return this.cache.toString();
    }

    public boolean stopCaching() {
        if (!this.caching) {
            return false;
        }
        this.caching = false;
        return true;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.cache != null) {
            this.cache.flush();
        }
    }

    public void write(char[] c) throws IOException {
        this.out.write(c);
        if (this.caching) {
            this.cache.write(c);
        }
    }

    public void write(char[] c, int off, int len) throws IOException {
        this.out.write(c, off, len);
        if (this.caching) {
            this.cache.write(c, off, len);
        }
    }

    public void write(int c) throws IOException {
        this.out.write(c);
        if (this.caching) {
            this.cache.write(c);
        }
    }

    public void write(String str) throws IOException {
        this.out.write(str);
        if (this.caching) {
            this.cache.write(str);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        this.out.write(str, off, len);
        if (this.caching) {
            this.cache.write(str, off, len);
        }
    }
}

