/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.serialize;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.AddressTester;
import org.jasig.portal.utils.CommonUtils;

public class ProxyWriter {
    protected boolean _proxying;
    private static final String[] _proxiableElements = new String[]{"image", "img", "script", "input", "applet", "iframe"};
    private static boolean PROXY_ENABLED = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.serialize.ProxyWriter.resource_proxy_enabled");
    private static String PROXIED_FILES_URI = PropertiesManager.getProperty("org.jasig.portal.serialize.ProxyWriter.proxy_files_uri");
    private static String PROXIED_FILES_PATH = PropertiesManager.getProperty("org.jasig.portal.serialize.ProxyWriter.proxy_files_path");
    private static final String PROXY_REWRITE_PREFIX = PropertiesManager.getProperty("org.jasig.portal.serialize.ProxyWriter.resource_proxy_rewrite_prefix");

    protected static String considerProxyRewrite(String name, String localName, String value) {
        if (PROXY_ENABLED && (name.equalsIgnoreCase("src") || name.equalsIgnoreCase("archive")) && value.indexOf("http://") != -1) {
            value = ProxyWriter.capture3XXCodes(value);
            if (localName.equalsIgnoreCase("script")) {
                value = ProxyWriter.reWrite(value);
                return value;
            }
            for (int i = 0; i < _proxiableElements.length; ++i) {
                if (!localName.equalsIgnoreCase(_proxiableElements[i])) continue;
                value = PROXY_REWRITE_PREFIX + value.substring(7);
                break;
            }
        }
        return value;
    }

    private static String capture3XXCodes(String value) {
        try {
            String skip_protocol = value.substring(7);
            String domain_only = skip_protocol.substring(0, skip_protocol.indexOf("/"));
            String work_value = value;
            if (!domain_only.endsWith("ubc.ca")) {
                boolean getRedirect = true;
                while (getRedirect) {
                    AddressTester tester = new AddressTester(work_value);
                    int responseCode = tester.getResponseCode();
                    if (responseCode != 301 || responseCode != 302) {
                        LogService.log(LogService.DEBUG, "ProxyWriter::capture3XXCodes(): could not get deeper in getting the image.");
                        return work_value;
                    }
                    getRedirect = false;
                    URL url = new URL(work_value);
                    URLConnection urlConnect = url.openConnection();
                    HttpURLConnection httpUrlConnect = (HttpURLConnection)urlConnect;
                    httpUrlConnect.setRequestMethod("HEAD");
                    httpUrlConnect.setInstanceFollowRedirects(false);
                    httpUrlConnect.connect();
                    int response = httpUrlConnect.getResponseCode();
                    String location = httpUrlConnect.getHeaderField("Location");
                    httpUrlConnect.disconnect();
                    if (response != 301 && response != 302) continue;
                    getRedirect = true;
                    work_value = location;
                }
                if (!work_value.equals(value)) {
                    value = work_value;
                }
            }
            return value;
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "ProxyWriter::catpture3XXCodes():Failed to rewrite the value: " + e.getMessage());
            return value;
        }
    }

    private static String reWrite(String scriptUri) {
        String filePath = null;
        String fileName = null;
        BufferedReader in = null;
        OutputStreamWriter out = null;
        try {
            AddressTester tester;
            fileName = ProxyWriter.fileNameGenerator(scriptUri);
            filePath = PROXIED_FILES_PATH + fileName;
            File outputFile = new File(filePath);
            if (!outputFile.exists() || new Date().getTime() - outputFile.lastModified() > 1800000L) {
                try {
                    String line;
                    tester = new AddressTester(scriptUri);
                    if (!tester.URLAvailable()) {
                        LogService.log(LogService.ERROR, "ProxyWriter::rewrite(): The adress " + scriptUri + " is not available. ");
                        return scriptUri;
                    }
                    URL url = new URL(scriptUri);
                    URLConnection urlConnect = url.openConnection();
                    HttpURLConnection httpUrlConnect = (HttpURLConnection)urlConnect;
                    httpUrlConnect.setInstanceFollowRedirects(false);
                    httpUrlConnect.connect();
                    int response = httpUrlConnect.getResponseCode();
                    in = new BufferedReader(new InputStreamReader(httpUrlConnect.getInputStream()));
                    out = new FileWriter(outputFile);
                    while ((line = in.readLine()) != null) {
                        String newLine = ProxyWriter.processLine(line);
                        out.write(newLine + "\t\n");
                    }
                    httpUrlConnect.disconnect();
                    in.close();
                    out.close();
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, "ProxyWriter::rewrite():Failed to rewrite the file for: " + scriptUri + " " + e.getMessage());
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    outputFile.delete();
                    return scriptUri;
                }
            }
            if (!(tester = new AddressTester(PROXIED_FILES_URI + fileName)).URLAvailable()) {
                LogService.log(LogService.ERROR, "ProxyWriter::rewrite(): The file  " + filePath + " is written but cannot be reached ");
                return scriptUri;
            }
            return PROXY_REWRITE_PREFIX + PROXIED_FILES_URI.substring(7) + fileName;
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "ProxyWriter::rewrite():Failed to read the file at : " + filePath + " " + e.getMessage());
            return scriptUri;
        }
    }

    private static String fileNameGenerator(String addr) {
        String newName = CommonUtils.replaceText(addr, "/", "");
        newName = CommonUtils.replaceText(newName, "http:", "");
        newName = CommonUtils.replaceText(newName, "www.", "");
        newName = CommonUtils.replaceText(newName, ".", "");
        newName = CommonUtils.replaceText(newName, "?", "");
        newName = CommonUtils.replaceText(newName, "&", "");
        try {
            newName = newName.substring(0, 16) + ".html";
        }
        catch (IndexOutOfBoundsException ignore) {
            return newName + ".html";
        }
        return newName;
    }

    private static String processLine(String line) throws Exception {
        try {
            if (line.indexOf(" src") != -1 && line.indexOf("http://") != -1) {
                String srcValue = ProxyWriter.extractURL(line);
                String srcNewValue = ProxyWriter.createProxyURL(srcValue);
                line = CommonUtils.replaceText(line, srcValue, srcNewValue);
                int firstPartIndex = line.lastIndexOf(srcNewValue) + srcNewValue.length();
                String remaining = line.substring(firstPartIndex);
                return line.substring(0, firstPartIndex) + "  " + ProxyWriter.processLine(remaining);
            }
            return line;
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "ProxyWriter::processLine():Failed to process a line : " + line + " " + e.getMessage());
            throw e;
        }
    }

    private static String extractURL(String line) {
        int URLStartIndex = 0;
        int URLEndIndex = 0;
        int srcIndex = line.indexOf(" src");
        if (line.indexOf("https://", srcIndex) != -1) {
            return "";
        }
        if (line.indexOf("http://", srcIndex) == -1) {
            return "";
        }
        URLStartIndex = line.indexOf("http", srcIndex);
        URLEndIndex = line.indexOf(" ", URLStartIndex);
        String srcValue = line.substring(URLStartIndex, URLEndIndex);
        return srcValue;
    }

    private static String createProxyURL(String srcValue) {
        String srcNewValue = "";
        if (srcValue.indexOf("https://") != -1) {
            return srcValue;
        }
        srcNewValue = srcValue.indexOf("http://") != -1 ? CommonUtils.replaceText(srcValue, "http://", PROXY_REWRITE_PREFIX) : "";
        return srcNewValue;
    }
}

