/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services.entityproperties;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.services.EntityPropertyRegistry;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.entityproperties.EntityProperties;
import org.jasig.portal.services.entityproperties.IEntityPropertyStore;

public class RDBMPropertyStore
implements IEntityPropertyStore {
    protected static Class propsType = null;
    protected static final String TABLE_NAME = "UP_ENTITY_PROP";
    protected static final String TYPE_COL = "ENTITY_TYPE_ID";
    protected static final String KEY_COL = "ENTITY_KEY";
    protected static final String NAME_COL = "PROPERTY_NAME";
    protected static final String VALUE_COL = "PROPERTY_VALUE";
    protected static final String DATE_COL = "LAST_MODIFIED";
    protected static final String selectProperties = "SELECT PROPERTY_NAME, PROPERTY_VALUE FROM UP_ENTITY_PROP WHERE ENTITY_TYPE_ID=? AND ENTITY_KEY=?";
    protected static final String deleteProperty = "DELETE FROM UP_ENTITY_PROP WHERE ENTITY_TYPE_ID=? AND ENTITY_KEY=? AND PROPERTY_NAME=?";
    protected static final String insertProperty = "INSERT INTO UP_ENTITY_PROP VALUES (?,?,?,?,?)";

    public RDBMPropertyStore() {
        try {
            if (propsType == null) {
                propsType = Class.forName("org.jasig.portal.services.entityproperties.EntityProperties");
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMPropertyStore.Constructor Unable to create propstype");
            LogService.log(LogService.ERROR, e);
        }
    }

    public String[] getPropertyNames(EntityIdentifier entityID) {
        String[] propNames = null;
        EntityProperties ep = this.getCachedProperties(entityID);
        if (ep != null) {
            propNames = ep.getPropertyNames();
        }
        return propNames;
    }

    public String getProperty(EntityIdentifier entityID, String name) {
        String propVal = null;
        EntityProperties ep = this.getCachedProperties(entityID);
        if (ep != null) {
            propVal = ep.getProperty(name);
        }
        return propVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeProperty(EntityIdentifier entityID, String name, String value) {
        this.unStoreProperty(entityID, name);
        Connection conn = null;
        RDBMServices.PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = new RDBMServices.PreparedStatement(conn, insertProperty);
            ps.clearParameters();
            ps.setInt(1, EntityTypes.getEntityTypeID(entityID.getType()));
            ps.setString(2, entityID.getKey());
            ps.setString(3, name);
            ps.setString(4, value);
            ps.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            int i = ps.executeUpdate();
            ps.close();
            this.clearCache(entityID);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMPropertyStore.storeProperty " + ps);
            LogService.log(LogService.ERROR, e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unStoreProperty(EntityIdentifier entityID, String name) {
        Connection conn = null;
        RDBMServices.PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = new RDBMServices.PreparedStatement(conn, deleteProperty);
            ps.clearParameters();
            ps.setInt(1, EntityTypes.getEntityTypeID(entityID.getType()));
            ps.setString(2, entityID.getKey());
            ps.setString(3, name);
            int i = ps.executeUpdate();
            ps.close();
            this.clearCache(entityID);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "RDBMPropertyStore.unStoreProperty " + ps);
            LogService.log(LogService.ERROR, e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    protected Connection getConnection() {
        return RDBMServices.getConnection();
    }

    protected void releaseConnection(Connection conn) {
        RDBMServices.releaseConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityProperties getCachedProperties(EntityIdentifier entityID) {
        EntityProperties ep = EntityPropertyRegistry.instance().getCachedProperties(entityID);
        if (ep == null) {
            ep = new EntityProperties(entityID.getKey());
            Connection conn = null;
            RDBMServices.PreparedStatement ps = null;
            try {
                conn = this.getConnection();
                ps = new RDBMServices.PreparedStatement(conn, selectProperties);
                ps.clearParameters();
                ps.setInt(1, EntityTypes.getEntityTypeID(entityID.getType()));
                ps.setString(2, entityID.getKey());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    ep.setProperty(rs.getString(NAME_COL), rs.getString(VALUE_COL));
                }
                this.addToCache(ep);
                rs.close();
                ps.close();
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "RDBMPropertyStore.getPropertyNames: " + ps);
                LogService.log(LogService.ERROR, e);
            }
            finally {
                this.releaseConnection(conn);
            }
        }
        return ep;
    }

    protected void clearCache(EntityIdentifier entityID) {
        EntityPropertyRegistry.instance().clearCache(entityID);
    }

    protected void addToCache(EntityProperties ep) {
        EntityPropertyRegistry.instance().addToCache(ep);
    }
}

