/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.chanpub;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelParameter;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.tools.chanpub.ChannelDefDtdResolver;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChannelPublisher {
    private static final String FRAMEWORK_OWNER = "UP_FRAMEWORK";
    private static final String SUBSCRIBER_ACTIVITY = "SUBSCRIBE";
    private static final String GRANT_PERMISSION_TYPE = "GRANT";
    private static int MODE;
    private static Properties channelTypesProperties;
    private static IPerson systemUser;
    private static DocumentBuilder domParser;
    private static IChannelRegistryStore crs;
    private static Map chanTypesNamesToIds;
    private static final String chanDefsLocation = "/properties/chanpub";
    static /* synthetic */ Class class$org$jasig$portal$tools$chanpub$ChannelPublisher;
    static /* synthetic */ Class class$org$jasig$portal$ChannelDefinition;
    static /* synthetic */ Class class$org$jasig$portal$security$IPerson;

    public static void main(String[] args) {
        try {
            if (args[1] != null && args[1].length() > 0) {
                MODE = args[1].equals("all") ? 0 : 1;
            }
            crs = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
            ChannelPublisher.initChanTypeMap();
            ChannelPublisher.setupSystemUser();
            ChannelPublisher.setupDomParser();
            if (MODE == 1) {
                System.out.println("You have chosen to publish one channel.....");
                System.out.print("Publishing channel " + args[1] + ".....");
                ChannelInfo ci = ChannelPublisher.getChannelInfo(args[1]);
                ChannelPublisher.publishChannel(ci);
                System.out.println("Done");
            } else {
                System.out.println("You have chosen to publish all channels.....");
                File f = ResourceLoader.getResourceAsFile(class$org$jasig$portal$tools$chanpub$ChannelPublisher == null ? (class$org$jasig$portal$tools$chanpub$ChannelPublisher = ChannelPublisher.class$("org.jasig.portal.tools.chanpub.ChannelPublisher")) : class$org$jasig$portal$tools$chanpub$ChannelPublisher, "/properties/chanpub/");
                if (f.isDirectory()) {
                    class ChannelDefFileFilter
                    implements FileFilter {
                        ChannelDefFileFilter() {
                        }

                        public boolean accept(File file) {
                            return file.getName().endsWith(".xml");
                        }
                    }
                    File[] files = f.listFiles(new ChannelDefFileFilter());
                    for (int j = 0; j < files.length; ++j) {
                        try {
                            System.out.print("Publishing channel " + files[j].getName() + ".....");
                            ChannelInfo ci = ChannelPublisher.getChannelInfo(files[j].getName());
                            ChannelPublisher.publishChannel(ci);
                            System.out.println("Done!");
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("FAILED!");
                            LogService.log(LogService.ERROR, "Exception occurred while publishing " + files[j].getName() + " channel. " + e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception occurred in main method. " + e + ". Please see portal.log for details");
            LogService.log(LogService.ERROR, "main() :: Exception occurred in main method." + e);
            e.printStackTrace();
        }
        System.out.println("Publishing finished.");
        System.exit(0);
    }

    private static InputStream getFileAsInputStream(File f) throws Exception {
        return new FileInputStream(f);
    }

    private static void setupSystemUser() {
        systemUser = PersonFactory.createSystemPerson();
    }

    private static void publishChannel(ChannelInfo ci) throws Exception {
        try {
            crs.saveChannelDefinition(ci.chanDef);
            AuthorizationService authService = AuthorizationService.instance();
            String target = "CHAN_ID." + ci.chanDef.getId();
            IUpdatingPermissionManager upm = authService.newUpdatingPermissionManager(FRAMEWORK_OWNER);
            IPermission[] newPermissions = new IPermission[ci.groups.length];
            for (int j = 0; j < ci.groups.length; ++j) {
                IAuthorizationPrincipal authPrincipal = authService.newPrincipal(ci.groups[j]);
                newPermissions[j] = upm.newPermission(authPrincipal);
                newPermissions[j].setType(GRANT_PERMISSION_TYPE);
                newPermissions[j].setActivity(SUBSCRIBER_ACTIVITY);
                newPermissions[j].setTarget(target);
            }
            IPermission[] oldPermissions = upm.getPermissions(SUBSCRIBER_ACTIVITY, target);
            upm.removePermissions(oldPermissions);
            upm.addPermissions(newPermissions);
            ChannelCategory[] categories = crs.getParentCategories(ci.chanDef);
            for (int i = 0; i < categories.length; ++i) {
                crs.removeChannelFromCategory(ci.chanDef, categories[i]);
            }
            for (int k = 0; k < ci.categories.length; ++k) {
                crs.addChannelToCategory(ci.chanDef, ci.categories[k]);
            }
            crs.approveChannelDefinition(ci.chanDef, systemUser, new Date());
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "publishChannel() :: Exception while attempting to publish channel to database. Channel name = " + ci.chanDef.getName());
            throw e;
        }
    }

    private static void setupDomParser() throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(true);
            domParser = dbf.newDocumentBuilder();
            domParser.setEntityResolver(new ChannelDefDtdResolver());
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "setupDomParser() :: creating Dom Parser. " + e);
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ChannelInfo getChannelInfo(String chanDefFile) throws Exception {
        ChannelInfo ci = new ChannelInfo();
        Document doc = null;
        try {
            InputStream is = ResourceLoader.getResourceAsStream(class$org$jasig$portal$tools$chanpub$ChannelPublisher == null ? (class$org$jasig$portal$tools$chanpub$ChannelPublisher = ChannelPublisher.class$("org.jasig.portal.tools.chanpub.ChannelPublisher")) : class$org$jasig$portal$tools$chanpub$ChannelPublisher, "/properties/chanpub/" + chanDefFile);
            doc = domParser.parse(is);
            Element chanDefE = doc.getDocumentElement();
            String fname = null;
            for (Node n = chanDefE.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || !n.getNodeName().equals("fname")) continue;
                fname = XML.getElementText((Element)n);
            }
            if (fname == null) {
                throw new Exception(chanDefFile + " is missing required fname element");
            }
            ci.chanDef = crs.getChannelDefinition(fname);
            if (ci.chanDef == null) {
                ci.chanDef = crs.newChannelDefinition();
            }
            for (Node param = chanDefE.getFirstChild(); param != null; param = param.getNextSibling()) {
                Element anode;
                int j;
                NodeList anodes;
                if (!(param instanceof Element)) continue;
                Element pele = (Element)param;
                String tagname = pele.getTagName();
                String value = XML.getElementText(pele);
                if (tagname.equals("title")) {
                    ci.chanDef.setTitle(value);
                } else if (tagname.equals("name")) {
                    ci.chanDef.setName(value);
                } else if (tagname.equals("fname")) {
                    ci.chanDef.setFName(value);
                } else if (tagname.equals("desc")) {
                    ci.chanDef.setDescription(value);
                } else if (tagname.equals("type")) {
                    String typeId = (String)chanTypesNamesToIds.get(value);
                    if (typeId == null) throw new Exception("Invalid entry in " + chanDefFile + " for Channel Type entry. Please fix before running Channel Publishing Tool");
                    ci.chanDef.setTypeId(Integer.parseInt(typeId));
                } else if (tagname.equals("class")) {
                    ci.chanDef.setJavaClass(value);
                } else if (tagname.equals("timeout")) {
                    ci.chanDef.setTimeout(Integer.parseInt(value));
                } else if (tagname.equals("hasedit")) {
                    ci.chanDef.setEditable(value != null && value.equals("Y"));
                } else if (tagname.equals("hashelp")) {
                    ci.chanDef.setHasHelp(value != null && value.equals("Y"));
                } else if (tagname.equals("hasabout")) {
                    ci.chanDef.setHasAbout(value != null && value.equals("Y"));
                } else if (tagname.equals("secure")) {
                    ci.chanDef.setIsSecure(value != null && value.equals("Y"));
                } else if (tagname.equals("categories")) {
                    anodes = pele.getElementsByTagName("category");
                    ci.categories = new ChannelCategory[anodes.getLength()];
                    if (anodes.getLength() != 0) {
                        for (j = 0; j < anodes.getLength(); ++j) {
                            anode = (Element)anodes.item(j);
                            String catString = XML.getElementText(anode);
                            IEntityGroup category = ChannelPublisher.getGroup(catString, class$org$jasig$portal$ChannelDefinition == null ? ChannelPublisher.class$("org.jasig.portal.ChannelDefinition") : class$org$jasig$portal$ChannelDefinition);
                            if (category == null) {
                                throw new Exception("Invalid entry in " + chanDefFile + " for category entry. Please fix before running Channel Publishing Tool");
                            }
                            ci.categories[j] = crs.getChannelCategory(category.getKey());
                        }
                    }
                } else if (tagname.equals("groups")) {
                    anodes = pele.getElementsByTagName("group");
                    ci.groups = new IGroupMember[anodes.getLength()];
                    if (anodes.getLength() != 0) {
                        for (j = 0; j < anodes.getLength(); ++j) {
                            anode = (Element)anodes.item(j);
                            String groupStr = XML.getElementText(anode);
                            IEntityGroup group = ChannelPublisher.getGroup(groupStr, class$org$jasig$portal$security$IPerson == null ? ChannelPublisher.class$("org.jasig.portal.security.IPerson") : class$org$jasig$portal$security$IPerson);
                            if (group == null) {
                                throw new Exception("Invalid entry in " + chanDefFile + " for groups entry. Please fix before running Channel Publishing Tool");
                            }
                            ci.groups[j] = group;
                        }
                    }
                } else if (tagname.equals("parameters") && (anodes = pele.getElementsByTagName("parameter")).getLength() > 0) {
                    for (j = 0; j < anodes.getLength(); ++j) {
                        NodeList ovrdnodes;
                        NodeList descnodes;
                        NodeList valuenodes;
                        String pname = null;
                        String pvalue = null;
                        String povrd = null;
                        String pdescr = null;
                        Element anode2 = (Element)anodes.item(j);
                        NodeList namenodes = anode2.getElementsByTagName("name");
                        if (namenodes.getLength() > 0) {
                            pname = XML.getElementText((Element)namenodes.item(0));
                        }
                        if ((valuenodes = anode2.getElementsByTagName("value")).getLength() > 0) {
                            pvalue = XML.getElementText((Element)valuenodes.item(0));
                        }
                        if ((descnodes = anode2.getElementsByTagName("description")).getLength() > 0) {
                            pdescr = XML.getElementText((Element)descnodes.item(0));
                        }
                        if ((ovrdnodes = anode2.getElementsByTagName("ovrd")).getLength() > 0) {
                            povrd = XML.getElementText((Element)ovrdnodes.item(0));
                        }
                        ChannelParameter chanParam = new ChannelParameter(pname, pvalue, povrd);
                        chanParam.setDescription(pdescr);
                        ci.chanDef.addParameter(chanParam);
                    }
                }
                ci.chanDef.setPublisherId(0);
                ci.chanDef.setPublishDate(new Date());
            }
            return ci;
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "getChannelInfo() :: Exception reading channel definition file: " + chanDefFile);
            LogService.log(LogService.ERROR, e);
            throw e;
        }
    }

    private static IEntityGroup getGroup(String groupName, Class entityType) throws Exception {
        IEntityGroup group = null;
        EntityIdentifier[] groups = GroupService.searchForGroups(groupName, 1, entityType);
        group = groups != null && groups.length > 0 ? GroupService.findGroup(groups[0].getKey()) : GroupService.findGroup(groupName);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initChanTypeMap() {
        if (chanTypesNamesToIds == null) {
            chanTypesNamesToIds = new HashMap();
            chanTypesNamesToIds.put("Custom", "-1");
            Connection con = RDBMServices.getConnection();
            try {
                String query = "SELECT * FROM UP_CHAN_TYPE";
                RDBMServices.PreparedStatement pstmt = new RDBMServices.PreparedStatement(con, query);
                try {
                    pstmt.clearParameters();
                    LogService.log(LogService.DEBUG, query);
                    ResultSet rs = pstmt.executeQuery();
                    try {
                        while (rs.next()) {
                            String chanTypeId = rs.getString("TYPE_ID");
                            String chanTypeName = rs.getString("TYPE_NAME");
                            chanTypesNamesToIds.put(chanTypeName, chanTypeId);
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    pstmt.close();
                }
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "Problem loading channel types from UP_CHAN_TYPE");
                LogService.log(LogService.ERROR, e);
            }
            finally {
                RDBMServices.releaseConnection(con);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ChannelInfo {
        ChannelDefinition chanDef;
        IGroupMember[] groups;
        ChannelCategory[] categories;

        private ChannelInfo() {
        }
    }
}

