/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.net.HttpURLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.Cookie;
import org.jasig.portal.services.LogService;

public class CookieCutter {
    private Vector cookies = new Vector();
    private boolean supportSetCookie2 = false;

    public boolean cookiesExist() {
        return this.cookies.size() > 0;
    }

    public void sendCookieHeader(HttpURLConnection httpUrlConnect, String domain, String path, String port) {
        Vector<ChannelCookie> cookiesToSend = new Vector<ChannelCookie>();
        String cport = "";
        boolean portOk = true;
        for (int index = 0; index < this.cookies.size(); ++index) {
            ChannelCookie cookie = (ChannelCookie)((Object)this.cookies.elementAt(index));
            Date current = new Date();
            Date cookieExpiryDate = cookie.getExpiryDate();
            boolean isExpired = cookieExpiryDate != null ? cookieExpiryDate.before(current) : false;
            if (cookie.isPortSet()) {
                cport = cookie.getPort();
                portOk = false;
            }
            if (!cport.equals("") && cport.indexOf(port) != -1) {
                portOk = true;
            }
            if (!domain.endsWith(cookie.getDomain()) || !path.startsWith(cookie.getPath()) || !portOk || isExpired) continue;
            cookiesToSend.addElement(cookie);
        }
        if (cookiesToSend.size() > 0) {
            Vector<ChannelCookie> cookiesInOrder = new Vector<ChannelCookie>();
            block1: for (int i = 0; i < cookiesToSend.size(); ++i) {
                ChannelCookie c1 = (ChannelCookie)((Object)cookiesToSend.elementAt(i));
                boolean flag = false;
                if (cookiesInOrder.size() == 0) {
                    cookiesInOrder.addElement(c1);
                    continue;
                }
                for (int index = 0; index < cookiesInOrder.size(); ++index) {
                    ChannelCookie c2 = (ChannelCookie)((Object)cookiesInOrder.elementAt(index));
                    if (c1.getPath().length() < c2.getPath().length()) continue;
                    cookiesInOrder.insertElementAt(c1, index);
                    flag = true;
                    continue block1;
                }
                if (flag) continue;
                cookiesInOrder.addElement(c1);
            }
            String headerValue = "";
            for (int i = 0; i < cookiesInOrder.size(); ++i) {
                ChannelCookie c = (ChannelCookie)((Object)cookiesInOrder.elementAt(i));
                headerValue = i == 0 ? c.getName() + "=" + c.getValue() : headerValue + "; " + c.getName() + "=" + c.getValue();
            }
            if (!headerValue.equals("")) {
                httpUrlConnect.setRequestProperty("Cookie", headerValue);
            }
        }
    }

    public void storeCookieHeader(HttpURLConnection httpUrlConnect, String domain, String path, String port) {
        String header;
        int index = 1;
        while ((header = httpUrlConnect.getHeaderFieldKey(index)) != null) {
            if (this.supportSetCookie2) {
                if (header.equalsIgnoreCase("set-cookie2")) {
                    this.processSetCookie2Header(httpUrlConnect.getHeaderField(index), domain, path, port);
                }
            } else if (header.equalsIgnoreCase("set-cookie2")) {
                this.supportSetCookie2 = true;
                this.processSetCookie2Header(httpUrlConnect.getHeaderField(index), domain, path, port);
            } else if (header.equalsIgnoreCase("set-cookie")) {
                try {
                    this.processSetCookieHeader(httpUrlConnect.getHeaderField(index), domain, path, port);
                }
                catch (ParseException e) {
                    LogService.log(LogService.WARN, "CookieCutter: Cannot process Set Cookie header: " + e.getMessage());
                }
            }
            ++index;
        }
    }

    private void processSetCookie2Header(String headerVal, String domain, String path, String port) {
        StringTokenizer headerValue = new StringTokenizer(headerVal, ",");
        while (headerValue.hasMoreTokens()) {
            ChannelCookie cookie;
            StringTokenizer cookieValue = new StringTokenizer(headerValue.nextToken(), ";");
            String token = cookieValue.nextToken();
            if (token.indexOf("=") != -1) {
                cookie = new ChannelCookie(token.substring(0, token.indexOf("=")), token.substring(token.indexOf("=") + 1).trim());
            } else {
                LogService.log(LogService.DEBUG, "CWebProxy: Invalid Header: \"Set-Cookie2:" + headerVal + "\"");
                cookie = null;
            }
            if (cookie == null) continue;
            boolean ageSet = false;
            boolean domainSet = false;
            boolean pathSet = false;
            boolean portSet = false;
            while (cookieValue.hasMoreTokens()) {
                token = cookieValue.nextToken();
                if (!ageSet && token.indexOf("=") != -1 && token.substring(0, token.indexOf("=")).trim().equalsIgnoreCase("max-age")) {
                    cookie.setMaxAge(Integer.parseInt(token.substring(token.indexOf("=") + 1).trim()));
                    ageSet = true;
                    continue;
                }
                if (!domainSet && token.indexOf("=") != -1 && token.substring(0, token.indexOf("=")).trim().equalsIgnoreCase("domain")) {
                    cookie.setDomain(token.substring(token.indexOf("=") + 1).trim());
                    domainSet = true;
                    cookie.domainIsSet();
                    continue;
                }
                if (!pathSet && token.indexOf("=") != -1 && token.substring(0, token.indexOf("=")).trim().equalsIgnoreCase("path")) {
                    cookie.setPath(token.substring(token.indexOf("=") + 1).trim());
                    pathSet = true;
                    cookie.pathIsSet();
                    continue;
                }
                if (portSet || token.toLowerCase().indexOf("port") == -1) continue;
                if (token.indexOf("=") == -1) {
                    cookie.setPort(port);
                } else {
                    cookie.setPort(token.substring(token.indexOf("=") + 1).trim());
                }
                portSet = true;
                cookie.portIsSet();
            }
            if (!domainSet) {
                cookie.setDomain(domain);
            }
            if (!pathSet) {
                cookie.setPath(path);
            }
            cookie.setVersion(1);
            for (int index = 0; index < this.cookies.size(); ++index) {
                ChannelCookie old = (ChannelCookie)((Object)this.cookies.elementAt(index));
                if (!cookie.getName().equals(old.getName())) continue;
                String newPath = cookie.getPath();
                String newDomain = cookie.getDomain();
                String oldPath = old.getPath();
                String oldDomain = old.getDomain();
                if (!newDomain.equalsIgnoreCase(oldDomain) || !newPath.equals(oldPath)) continue;
                this.cookies.removeElement((Object)old);
            }
            int expires = cookie.getMaxAge();
            if (expires < 0) {
                this.cookies.addElement(cookie);
                continue;
            }
            if (expires == 0) continue;
            Date d = new Date();
            cookie.setExpiryDate(new Date(d.getTime() + (long)(expires * 1000)));
            this.cookies.addElement(cookie);
        }
    }

    private void processSetCookieHeader(String headerVal, String domain, String path, String port) throws ParseException {
        if (headerVal.indexOf("Expires=") != -1 || headerVal.indexOf("expires=") != -1 || headerVal.indexOf("EXPIRES=") != -1) {
            ChannelCookie cookie;
            StringTokenizer cookieValue = new StringTokenizer(headerVal, ";");
            String token = cookieValue.nextToken();
            if (token.indexOf("=") != -1) {
                cookie = new ChannelCookie(token.substring(0, token.indexOf("=")), token.substring(token.indexOf("=") + 1).trim());
            } else {
                LogService.log(LogService.DEBUG, "CWebProxy: Invalid Header: \"Set-Cookie:" + headerVal + "\"");
                cookie = null;
            }
            if (cookie != null) {
                boolean ageSet = false;
                boolean domainSet = false;
                boolean pathSet = false;
                while (cookieValue.hasMoreTokens()) {
                    token = cookieValue.nextToken();
                    if (!ageSet && token.indexOf("=") != -1 && token.substring(0, token.indexOf("=")).trim().equalsIgnoreCase("expires")) {
                        SimpleDateFormat f = new SimpleDateFormat("EEE, d-MMM-yyyy HH:mm:ss z", Locale.ENGLISH);
                        f.setTimeZone(TimeZone.getTimeZone("GMT"));
                        f.setLenient(true);
                        Date date = f.parse(token.substring(token.indexOf("=") + 1).trim());
                        Date current = new Date();
                        if (date != null) {
                            long l = date.before(current) ? 0L : date.getTime() - current.getTime();
                            int exp = (int)l / 1000;
                            cookie.setMaxAge(exp);
                            ageSet = true;
                        }
                    }
                    if (!domainSet && token.indexOf("=") != -1 && token.substring(0, token.indexOf("=")).trim().equalsIgnoreCase("domain")) {
                        cookie.setDomain(token.substring(token.indexOf("=") + 1).trim());
                        domainSet = true;
                    }
                    if (pathSet || token.indexOf("=") == -1 || !token.substring(0, token.indexOf("=")).trim().equalsIgnoreCase("path")) continue;
                    cookie.setPath(token.substring(token.indexOf("=") + 1).trim());
                    pathSet = true;
                }
                if (!domainSet) {
                    cookie.setDomain(domain);
                }
                if (!pathSet) {
                    cookie.setPath(path);
                }
                cookie.setVersion(0);
                for (int index = 0; index < this.cookies.size(); ++index) {
                    ChannelCookie old = (ChannelCookie)((Object)this.cookies.elementAt(index));
                    if (!cookie.getName().equals(old.getName())) continue;
                    String newPath = cookie.getPath();
                    String newDomain = cookie.getDomain();
                    String oldPath = old.getPath();
                    String oldDomain = old.getDomain();
                    if (!newDomain.equalsIgnoreCase(oldDomain) || !newPath.equals(oldPath)) continue;
                    this.cookies.removeElement((Object)old);
                }
                int expires = cookie.getMaxAge();
                if (expires < 0) {
                    this.cookies.addElement(cookie);
                } else if (expires != 0) {
                    Date d = new Date();
                    cookie.setExpiryDate(new Date(d.getTime() + (long)(expires * 1000)));
                    this.cookies.addElement(cookie);
                }
            }
        } else {
            this.processSetCookie2Header(headerVal, domain, path, port);
        }
    }

    private class ChannelCookie
    extends Cookie {
        protected String port = null;
        protected boolean pathSet = false;
        protected boolean domainSet = false;
        protected boolean portSet = false;
        protected Date expiryDate = null;

        public ChannelCookie(String name, String value) {
            super(name, value);
        }

        public void setExpiryDate(Date expiryDate) {
            this.expiryDate = expiryDate;
        }

        public Date getExpiryDate() {
            return this.expiryDate;
        }

        public String getPath() {
            String path = super.getPath();
            if (path.startsWith("\"") && path.endsWith("\"")) {
                path = path.substring(1, path.length() - 1);
            }
            return path;
        }

        public String getValue() {
            String value = super.getValue();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }

        public void pathIsSet() {
            this.pathSet = true;
        }

        public void domainIsSet() {
            this.domainSet = true;
        }

        public void portIsSet() {
            this.portSet = true;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getPort() {
            return this.port;
        }

        public boolean isPathSet() {
            return this.pathSet;
        }

        public boolean isDomainSet() {
            return this.domainSet;
        }

        public boolean isPortSet() {
            return this.portSet;
        }
    }
}

