/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.services.LogService;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceLoader {
    private static DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();

    public static URL getResourceAsURL(Class requestingClass, String resource) throws ResourceMissingException {
        URL resourceURL;
        block3: {
            resourceURL = null;
            try {
                resourceURL = new URL(resource);
            }
            catch (MalformedURLException murle) {
                resourceURL = requestingClass.getResource(resource);
                if (resourceURL == null) {
                    resourceURL = CarResources.getInstance().getClassLoader().getResource(resource);
                }
                if (resourceURL != null) break block3;
                String resourceRelativeToClasspath = null;
                resourceRelativeToClasspath = resource.startsWith("/") ? resource : '/' + requestingClass.getPackage().getName().replace('.', '/') + '/' + resource;
                throw new ResourceMissingException(resource, resourceRelativeToClasspath, "Resource not found in classpath: " + resourceRelativeToClasspath);
            }
        }
        return resourceURL;
    }

    public static String getResourceAsURLString(Class requestingClass, String resource) throws ResourceMissingException {
        return ResourceLoader.getResourceAsURL(requestingClass, resource).toString();
    }

    public static File getResourceAsFile(Class requestingClass, String resource) throws ResourceMissingException {
        return new File(ResourceLoader.getResourceAsFileString(requestingClass, resource));
    }

    public static String getResourceAsFileString(Class requestingClass, String resource) throws ResourceMissingException {
        return URLDecoder.decode(ResourceLoader.getResourceAsURL(requestingClass, resource).getFile());
    }

    public static InputStream getResourceAsStream(Class requestingClass, String resource) throws ResourceMissingException, IOException {
        return ResourceLoader.getResourceAsURL(requestingClass, resource).openStream();
    }

    public static InputSource getResourceAsSAXInputSource(Class requestingClass, String resource) throws ResourceMissingException, IOException {
        return new InputSource(ResourceLoader.getResourceAsURL(requestingClass, resource).openStream());
    }

    public static Document getResourceAsDocument(Class requestingClass, String resource) throws ResourceMissingException, IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = ResourceLoader.getResourceAsStream(requestingClass, resource);
        return f.newDocumentBuilder().parse(inputStream);
    }

    public static Properties getResourceAsProperties(Class requestingClass, String resource) throws ResourceMissingException, IOException {
        InputStream inputStream = ResourceLoader.getResourceAsStream(requestingClass, resource);
        Properties props = new Properties();
        props.load(inputStream);
        inputStream.close();
        return props;
    }

    public static String getResourceAsString(Class requestingClass, String resource) throws ResourceMissingException, IOException {
        String line = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(ResourceLoader.getResourceAsStream(requestingClass, resource)));
        StringBuffer sbText = new StringBuffer(1024);
        while ((line = in.readLine()) != null) {
            sbText.append(line).append("\n");
        }
        return sbText.toString();
    }

    static {
        f.setNamespaceAware(true);
        try {
            String handler = PropertiesManager.getProperty("org.jasig.portal.utils.ResourceLoader.HttpsHandler");
            if (System.getProperty("java.protocol.handler.pkgs") != null && !System.getProperty("java.protocol.handler.pkgs").equals("")) {
                handler = handler + "|" + System.getProperty("java.protocol.handler.pkgs");
            }
            System.setProperty("java.protocol.handler.pkgs", handler);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "Unable to set HTTPS Protocol handler:");
            LogService.log(LogService.ERROR, e);
        }
    }
}

