/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.IOException;
import org.jasig.portal.utils.IWriteable;

public class SubstitutionIntegerFilter {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    final IWriteable out;
    final int[] substitute;
    final int[] target;
    private int matchindex;
    private int[] buffer;
    private int bufferindex;
    private int maxBuffer = 2048;

    public SubstitutionIntegerFilter(IWriteable out, int[] target, int[] substitute) {
        this.out = out;
        this.substitute = substitute;
        this.target = target;
        this.matchindex = 0;
        this.bufferindex = 0;
        this.buffer = new int[this.maxBuffer + target.length];
    }

    public SubstitutionIntegerFilter(IWriteable out, int[] target, int[] substitute, int bufferSize) {
        this.out = out;
        this.substitute = substitute;
        this.target = target;
        this.matchindex = 0;
        this.bufferindex = 0;
        this.maxBuffer = bufferSize - target.length;
        this.buffer = new int[this.maxBuffer + target.length];
    }

    public void write(int number) throws IOException {
        if (number == this.target[this.matchindex]) {
            if (this.matchindex < this.target.length - 1) {
                this.addToBuffer(number);
                ++this.matchindex;
            } else {
                this.bufferindex -= this.matchindex;
                this.matchindex = 0;
                for (int x = 0; x < this.substitute.length; ++x) {
                    this.addToBuffer(this.substitute[x]);
                }
            }
        } else {
            this.matchindex = 0;
            this.addToBuffer(number);
        }
    }

    public void flush() throws IOException {
        this.out.write(this.buffer, 0, this.bufferindex);
        this.bufferindex = 0;
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    protected void addToBuffer(int i) throws IOException {
        if (this.bufferindex > this.maxBuffer - 2 && this.matchindex == 0) {
            this.flush();
        }
        this.buffer[this.bufferindex++] = i;
    }
}

