/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.StylesheetSet;
import org.jasig.portal.i18n.LocaleAwareXSLT;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XSLT {
    protected static boolean stylesheetRootCacheEnabled = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.utils.XSLT.stylesheet_root_caching");
    protected static boolean stylesheetSetCacheEnabled = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.utils.XSLT.stylesheet_set_caching");
    protected static final String mediaProps = "/properties/media.properties";
    protected static final Hashtable stylesheetRootCache = new Hashtable();
    protected static final Hashtable stylesheetSetCache = new Hashtable();
    private static SAXTransformerFactory saxTFactory = null;
    protected Object caller = null;
    protected Source xmlSource;
    protected Result xmlResult;
    protected HashMap stylesheetParams = new HashMap();
    protected String xslURI;

    public XSLT(Object instance) {
        this.caller = instance;
    }

    public static XSLT getTransformer(Object instance) {
        return new XSLT(instance);
    }

    public static XSLT getTransformer(Object instance, Locale[] locales) {
        return new LocaleAwareXSLT(instance, locales);
    }

    public static SAXTransformerFactory getSAXTFactory() {
        TransformerFactory tFactory;
        if (saxTFactory == null && (tFactory = TransformerFactory.newInstance()) instanceof SAXTransformerFactory) {
            saxTFactory = (SAXTransformerFactory)tFactory;
        }
        if (saxTFactory == null) {
            LogService.log(LogService.ERROR, "XSLT() : unable to instantiate SAX transformer ! Please make sure the TRAX implementation you're using supports SAX Transformers");
        }
        return saxTFactory;
    }

    public void setXML(String xml) {
        this.xmlSource = new StreamSource(new StringReader(xml));
    }

    public void setXML(Node xml) {
        this.xmlSource = new DOMSource(xml);
    }

    public void setXML(InputStream is) {
        this.xmlSource = new StreamSource(is);
    }

    public void setXML(File file) {
        this.xmlSource = new StreamSource(file);
    }

    public void setXSL(String xslUri) throws PortalException {
        this.xslURI = ResourceLoader.getResourceAsURLString(this.caller.getClass(), xslUri);
    }

    public void setXSL(String sslUri, String stylesheetTitle, BrowserInfo browserInfo) throws PortalException {
        StylesheetSet set = XSLT.getStylesheetSet(ResourceLoader.getResourceAsURLString(this.caller.getClass(), sslUri));
        set.setMediaProps(mediaProps);
        String xslUri = set.getStylesheetURI(stylesheetTitle, browserInfo);
        this.setXSL(xslUri);
    }

    public void setXSL(String sslUri, BrowserInfo browserInfo) throws PortalException {
        this.setXSL(sslUri, null, browserInfo);
    }

    public void setTarget(ContentHandler contentHandler) {
        this.xmlResult = new SAXResult(contentHandler);
    }

    public void setTarget(OutputStream os) {
        this.xmlResult = new StreamResult(os);
    }

    public void setTarget(Node node) {
        this.xmlResult = new DOMResult(node);
    }

    public void setStylesheetParameters(Hashtable stylesheetParameters) {
        this.stylesheetParams.putAll(stylesheetParameters);
    }

    public void setStylesheetParameters(HashMap stylesheetParameters) {
        this.stylesheetParams = stylesheetParameters;
    }

    public void setStylesheetParameter(String name, String value) {
        this.stylesheetParams.put(name, value);
    }

    public void transform() throws PortalException {
        try {
            Transformer trans = XSLT.getTransformer(this.xslURI);
            XSLT.setStylesheetParams(trans, this.stylesheetParams);
            trans.transform(this.xmlSource, this.xmlResult);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    public static void transform(Source xmlSource, Result xmlResult, Hashtable stylesheetParams, String xslURI) throws PortalException {
        try {
            Transformer trans = XSLT.getTransformer(xslURI);
            XSLT.setStylesheetParams(trans, stylesheetParams);
            trans.transform(xmlSource, xmlResult);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    private static void setStylesheetParams(Transformer transformer, Hashtable stylesheetParams) {
        if (stylesheetParams != null) {
            HashMap stylesheetParamsHashMap = new HashMap();
            stylesheetParamsHashMap.putAll(stylesheetParams);
            XSLT.setStylesheetParams(transformer, stylesheetParamsHashMap);
        }
    }

    private static void setStylesheetParams(Transformer transformer, HashMap stylesheetParams) {
        if (stylesheetParams != null) {
            Iterator iterator = stylesheetParams.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object o = stylesheetParams.get(key);
                if (o.getClass().getName().equals("[Ljava.lang.String;")) {
                    o = ((String[])o)[0];
                }
                transformer.setParameter(key, o);
            }
        }
    }

    public static Templates getTemplates(String stylesheetURI) throws SAXException, PortalException {
        Templates temp = (Templates)stylesheetRootCache.get(stylesheetURI);
        if (temp == null) {
            try {
                TemplatesHandler thand = XSLT.getSAXTFactory().newTemplatesHandler();
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(thand);
                reader.parse(stylesheetURI);
                temp = thand.getTemplates();
                if (stylesheetRootCacheEnabled) {
                    stylesheetRootCache.put(stylesheetURI, temp);
                    LogService.log(LogService.INFO, "Caching templates for: " + stylesheetURI);
                }
            }
            catch (IOException ioe) {
                throw new ResourceMissingException(stylesheetURI, "Stylesheet", "Unable to read stylesheet from the specified location. Please check the stylesheet URL");
            }
            catch (TransformerConfigurationException tce) {
                LogService.log(LogService.ERROR, "XSLT::getTemplates() : unable to obtain TemplatesHandler due to TRAX misconfiguration!");
                throw new GeneralRenderingException("XSLT: current TRAX configuration does not allow for TemplateHandlers. Please reconfigure/reinstall your TRAX implementation.");
            }
            catch (SAXParseException px) {
                throw new GeneralRenderingException("XSLT:getTemplates(): SAXParseExeption: " + px.getMessage() + " line:" + px.getLineNumber() + " col:" + px.getColumnNumber());
            }
            catch (SAXException sx) {
                if (null != sx.getException() && sx.getException() instanceof TransformerException) {
                    TransformerException trx = (TransformerException)sx.getException();
                    throw new GeneralRenderingException("XSLT.getTemplates():" + trx.getMessageAndLocation());
                }
                throw sx;
            }
        }
        return temp;
    }

    public static Transformer getTransformer(String stylesheetURI) throws SAXException, PortalException {
        Transformer t = null;
        try {
            t = XSLT.getTemplates(stylesheetURI).newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            LogService.log(LogService.ERROR, "XSLT::getTransformer() : TRAX transformer is misconfigured : " + tce.getMessage());
        }
        return t;
    }

    public static TransformerHandler getTransformerHandler(String stylesheetURI) throws SAXException, PortalException {
        TransformerHandler th = null;
        try {
            th = XSLT.getSAXTFactory().newTransformerHandler(XSLT.getTemplates(stylesheetURI));
        }
        catch (TransformerConfigurationException tce) {
            LogService.log(LogService.ERROR, "XSLT::getTransformerHandler() : TRAX transformer is misconfigured : " + tce.getMessage());
        }
        return th;
    }

    public static TransformerHandler getTransformerHandler(String stylesheetURI, Locale[] locales, Object caller) throws SAXException, PortalException {
        TransformerHandler th = null;
        try {
            String localizedStylesheetURI = LocaleAwareXSLT.getLocaleAwareXslUri(stylesheetURI, locales, caller);
            th = XSLT.getSAXTFactory().newTransformerHandler(XSLT.getTemplates(localizedStylesheetURI));
        }
        catch (TransformerConfigurationException tce) {
            LogService.log(LogService.ERROR, "XSLT::getTransformerHandler() : TRAX transformer is misconfigured : " + tce.getMessage());
        }
        return th;
    }

    public static StylesheetSet getStylesheetSet(String stylesheetListURI) throws PortalException {
        StylesheetSet stylesheetSet = (StylesheetSet)stylesheetSetCache.get(stylesheetListURI);
        if (stylesheetSet == null) {
            stylesheetSet = new StylesheetSet(stylesheetListURI);
            if (stylesheetSetCacheEnabled) {
                stylesheetSetCache.put(stylesheetListURI, stylesheetSet);
                LogService.log(LogService.INFO, "Caching StylesheetSet for: " + stylesheetListURI);
            }
        }
        return stylesheetSet;
    }

    public static String getStylesheetURI(String sslUri, BrowserInfo browserInfo) throws PortalException {
        StylesheetSet set = XSLT.getStylesheetSet(sslUri);
        String xslUri = set.getStylesheetURI(browserInfo);
        return xslUri;
    }

    public static String getStylesheetURI(String sslUri, String title, BrowserInfo browserInfo) throws PortalException {
        StylesheetSet set = XSLT.getStylesheetSet(sslUri);
        String xslUri = set.getStylesheetURI(title, browserInfo);
        return xslUri;
    }
}

