/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.threading;

import org.jasig.portal.utils.threading.WorkerTask;

public final class WorkTracker {
    public static final int READY = 0;
    public static final int RUNNING = 1;
    public static final int DONE = 2;
    public static final int KILLED = 3;
    private WorkerTask work;
    private int state;
    private boolean jobSuccessful;
    private Exception exception;

    public WorkTracker(WorkerTask task) {
        this.work = task;
        this.state = 0;
        this.jobSuccessful = false;
        this.exception = null;
    }

    public synchronized void updateStatus(int state, boolean succcessful, Exception exception) {
        this.state = state;
        this.jobSuccessful = succcessful;
        this.exception = exception;
        this.notifyAll();
    }

    public synchronized void killJob() {
        if (this.state == 0 || this.state == 1) {
            this.work.kill();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isJobSuccessful() {
        return this.jobSuccessful;
    }

    public boolean isJobComplete() {
        return this.state == 2 || this.state == 3;
    }

    public int getState() {
        return this.state;
    }

    public void deregisterWork() {
        this.work = null;
    }

    public String toString() {
        String str = new String();
        switch (this.state) {
            case 0: {
                str = str + "State: READY";
                break;
            }
            case 1: {
                str = str + "State: RUNNING";
                break;
            }
            case 2: {
                str = str + "State: DONE";
                break;
            }
            case 3: {
                str = str + "State: KILLED";
            }
        }
        str = str + ", Job Successful: " + this.jobSuccessful;
        if (this.exception != null) {
            str = str + ", Exception: " + this.exception.getMessage();
        }
        return str;
    }
}

