/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.connectionpool;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.LDAPTLSSocketFactory;
import com.novell.ldap.connectionpool.Connection;
import com.novell.ldap.connectionpool.ListOfSharedConnections;
import com.novell.ldap.connectionpool.SharedConnections;

public class PoolManager {
    private ListOfSharedConnections inUseListOfSharedConnections = new ListOfSharedConnections();
    private ListOfSharedConnections availableListOfSharedConnections = new ListOfSharedConnections();
    private boolean shuttingDown;

    public PoolManager(String string, int n, int n2, int n3, LDAPSocketFactory lDAPSocketFactory) throws LDAPException {
        int n4 = 0;
        while (n4 < n2) {
            SharedConnections sharedConnections = new SharedConnections(n3);
            Connection connection = new Connection(lDAPSocketFactory);
            connection.connect(string, n);
            if (lDAPSocketFactory instanceof LDAPTLSSocketFactory) {
                connection.startTLS();
            }
            sharedConnections.add(connection);
            int n5 = 1;
            while (n5 < n3) {
                Connection connection2 = (Connection)connection.clone();
                sharedConnections.add(connection2);
                ++n5;
            }
            this.availableListOfSharedConnections.add(n4, sharedConnections);
            ++n4;
        }
        this.shuttingDown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getBoundConnection(String string, byte[] byArray) throws LDAPException, InterruptedException {
        Connection connection = null;
        SharedConnections sharedConnections = null;
        boolean bl = false;
        ListOfSharedConnections listOfSharedConnections = this.inUseListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            connection = this.inUseListOfSharedConnections.getAvailableConnection(string, byArray);
            if (null != connection) {
                connection.setInUse();
                return connection;
            }
        }
        ListOfSharedConnections listOfSharedConnections2 = this.availableListOfSharedConnections;
        synchronized (listOfSharedConnections2) {
            sharedConnections = this.availableListOfSharedConnections.getSharedConns(string, byArray);
            if (null == sharedConnections) {
                if (0 == this.availableListOfSharedConnections.size()) {
                    this.availableListOfSharedConnections.wait();
                    if (this.shuttingDown) {
                        return null;
                    }
                }
                sharedConnections = (SharedConnections)this.availableListOfSharedConnections.get(0);
                bl = true;
            }
            this.availableListOfSharedConnections.remove(sharedConnections);
            connection = (Connection)sharedConnections.get(0);
            connection.setInUse();
        }
        if (bl) {
            try {
                connection.poolBind(3, string, byArray);
                sharedConnections.setDN(string);
                sharedConnections.setPW(byArray);
            }
            catch (LDAPException lDAPException) {
                connection.clearInUse();
                sharedConnections.setDN(null);
                sharedConnections.setPW(null);
                ListOfSharedConnections listOfSharedConnections3 = this.availableListOfSharedConnections;
                synchronized (listOfSharedConnections3) {
                    this.availableListOfSharedConnections.add(sharedConnections);
                }
                throw lDAPException;
            }
        }
        ListOfSharedConnections listOfSharedConnections4 = this.inUseListOfSharedConnections;
        synchronized (listOfSharedConnections4) {
            this.inUseListOfSharedConnections.add(sharedConnections);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeConnectionAvailable(LDAPConnection lDAPConnection) {
        SharedConnections sharedConnections = null;
        ListOfSharedConnections listOfSharedConnections = this.inUseListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            ((Connection)lDAPConnection).clearInUse();
            sharedConnections = this.inUseListOfSharedConnections.getSharedConns((Connection)lDAPConnection);
            if (sharedConnections.allConnectionsAvailable()) {
                this.inUseListOfSharedConnections.remove(sharedConnections);
            } else {
                sharedConnections = null;
            }
        }
        if (null != sharedConnections) {
            ListOfSharedConnections listOfSharedConnections2 = this.availableListOfSharedConnections;
            synchronized (listOfSharedConnections2) {
                this.availableListOfSharedConnections.add(sharedConnections);
                this.availableListOfSharedConnections.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        ListOfSharedConnections listOfSharedConnections = this.availableListOfSharedConnections;
        synchronized (listOfSharedConnections) {
            this.shuttingDown = true;
            this.availableListOfSharedConnections.notifyAll();
        }
    }
}

