/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final char[] emap = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] dmap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};
    private static final byte[][] lowerBoundMask = new byte[][]{{0, 0}, {30, 0}, {15, 32}, {7, 48}, {2, 56}, {1, 60}};
    private static final byte continuationMask = -64;
    private static final byte continuationResult = -128;

    private Base64() {
    }

    public static final String encode(String string) {
        try {
            return Base64.encode(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("US-ASCII String encoding not supported by JVM");
        }
    }

    public static final String encode(byte[] byArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n = byArray.length;
        if (n == 0) {
            return new String("");
        }
        int n2 = n % 3 == 0 ? n / 3 : n / 3 + 1;
        if (n % 3 == 1) {
            bl2 = true;
        } else if (n % 3 == 2) {
            bl = true;
        }
        char[] cArray = new char[n2 * 4];
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n3 < n) {
            int n6 = 0xFF & byArray[n3];
            cArray[n4] = emap[n6 >> 2];
            if (n5 == n2 && bl2) {
                cArray[n4 + 1] = emap[(n6 & 3) << 4];
                cArray[n4 + 2] = 61;
                cArray[n4 + 3] = 61;
                break;
            }
            int n7 = 0xFF & byArray[n3 + 1];
            cArray[n4 + 1] = emap[((n6 & 3) << 4) + ((n7 & 0xF0) >> 4)];
            if (n5 == n2 && bl) {
                cArray[n4 + 2] = emap[(n7 & 0xF) << 2];
                cArray[n4 + 3] = 61;
                break;
            }
            int n8 = 0xFF & byArray[n3 + 2];
            cArray[n4 + 2] = emap[(n7 & 0xF) << 2 | (n8 & 0xC0) >> 6];
            cArray[n4 + 3] = emap[n8 & 0x3F];
            n3 += 3;
            n4 += 4;
            ++n5;
        }
        return new String(cArray);
    }

    public static final byte[] decode(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        return Base64.decode(cArray);
    }

    public static final byte[] decode(char[] cArray) {
        byte[] byArray;
        int n;
        int n2 = cArray.length;
        int n3 = n2 / 4;
        boolean bl = false;
        boolean bl2 = false;
        if (cArray.length == 0) {
            return new byte[0];
        }
        if (n2 % 4 != 0) {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.Base64Decoder: decode: mal-formatted encode value");
        }
        if (cArray[n2 - 1] == '=' && cArray[n2 - 2] == '=') {
            bl2 = true;
            n = n3 * 3 - 2;
            byArray = new byte[n];
        } else if (cArray[n2 - 1] == '=') {
            bl = true;
            n = n3 * 3 - 1;
            byArray = new byte[n];
        } else {
            n = n3 * 3;
            byArray = new byte[n];
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        while (n4 < n2) {
            byArray[n5] = (byte)(dmap[cArray[n4]] << 2 | (dmap[cArray[n4 + 1]] & 0x30) >> 4);
            if (n6 == n3 && bl2) break;
            byArray[n5 + 1] = (byte)((dmap[cArray[n4 + 1]] & 0xF) << 4 | (dmap[cArray[n4 + 2]] & 0x3C) >> 2);
            if (n6 == n3 && bl) break;
            byArray[n5 + 2] = (byte)((dmap[cArray[n4 + 2]] & 3) << 6 | dmap[cArray[n4 + 3]] & 0x3F);
            n4 += 4;
            n5 += 3;
            ++n6;
        }
        return byArray;
    }

    public static final byte[] decode(StringBuffer stringBuffer, int n, int n2) {
        byte[] byArray;
        int n3;
        int n4 = n2 - n;
        int n5 = n4 / 4;
        boolean bl = false;
        boolean bl2 = false;
        if (stringBuffer.length() == 0) {
            return new byte[0];
        }
        if (n4 % 4 != 0) {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.Base64Decoder: decode error: mal-formatted encode value");
        }
        if (stringBuffer.charAt(n2 - 1) == '=' && stringBuffer.charAt(n2 - 2) == '=') {
            bl2 = true;
            n3 = n5 * 3 - 2;
            byArray = new byte[n3];
        } else if (stringBuffer.charAt(n2 - 1) == '=') {
            bl = true;
            n3 = n5 * 3 - 1;
            byArray = new byte[n3];
        } else {
            n3 = n5 * 3;
            byArray = new byte[n3];
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        while (n6 < n4) {
            byArray[n7] = (byte)(dmap[stringBuffer.charAt(n + n6)] << 2 | (dmap[stringBuffer.charAt(n + n6 + 1)] & 0x30) >> 4);
            if (n8 == n5 && bl2) break;
            byArray[n7 + 1] = (byte)((dmap[stringBuffer.charAt(n + n6 + 1)] & 0xF) << 4 | (dmap[stringBuffer.charAt(n + n6 + 2)] & 0x3C) >> 2);
            if (n8 == n5 && bl) break;
            byArray[n7 + 2] = (byte)((dmap[stringBuffer.charAt(n + n6 + 2)] & 3) << 6 | dmap[stringBuffer.charAt(n + n6 + 3)] & 0x3F);
            n6 += 4;
            n7 += 3;
            ++n8;
        }
        return byArray;
    }

    public static final boolean isLDIFSafe(byte[] byArray) {
        int n = byArray.length;
        if (n > 0) {
            byte by = byArray[0];
            if (by == 0 || by == 10 || by == 13 || by == 32 || by == 58 || by == 60 || by < 0) {
                return false;
            }
            if (byArray[n - 1] == 32) {
                return false;
            }
            if (n > 1) {
                int n2 = 1;
                while (n2 < byArray.length) {
                    by = byArray[n2];
                    if (by == 0 || by == 10 || by == 13 || by < 0) {
                        return false;
                    }
                    ++n2;
                }
            }
        }
        return true;
    }

    public static final boolean isLDIFSafe(String string) {
        try {
            return Base64.isLDIFSafe(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 String encoding not supported by JVM");
        }
    }

    private static int getByteCount(byte by) {
        if (by > 0) {
            return 0;
        }
        if ((by & 0xE0) == 192) {
            return 1;
        }
        if ((by & 0xF0) == 224) {
            return 2;
        }
        if ((by & 0xF8) == 240) {
            return 3;
        }
        if ((by & 0xFC) == 248) {
            return 4;
        }
        if ((by & 0xFF) == 252) {
            return 5;
        }
        return -1;
    }

    public static boolean isValidUTF8(byte[] byArray, boolean bl) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = Base64.getByteCount(byArray[n]);
            if (n2 == 0) {
                ++n;
                continue;
            }
            if (n2 == -1 || n + n2 >= byArray.length || bl && n2 >= 3) {
                return false;
            }
            if ((lowerBoundMask[n2][0] & byArray[n]) == 0 && (lowerBoundMask[n2][1] & byArray[n + 1]) == 0) {
                return false;
            }
            int n3 = 1;
            while (n3 <= n2) {
                if ((byArray[n + n3] & 0xFFFFFFC0) != -128) {
                    return false;
                }
                ++n3;
            }
            n += n2 + 1;
        }
        return true;
    }
}

