/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import java.io.IOException;
import java.util.Enumeration;

public class LDAPAttributeSchema
extends LDAPSchemaElement {
    private String syntaxString;
    private boolean single = false;
    private String superior;
    private String equality;
    private String ordering;
    private String substring;
    private boolean collective = false;
    private boolean userMod = true;
    private int usage = 0;
    public static final int USER_APPLICATIONS = 0;
    public static final int DIRECTORY_OPERATION = 1;
    public static final int DISTRIBUTED_OPERATION = 2;
    public static final int DSA_OPERATION = 3;

    public LDAPAttributeSchema(String[] stringArray, String string, String string2, String string3, boolean bl, String string4, boolean bl2, String string5, String string6, String string7, boolean bl3, boolean bl4, int n) {
        super(LDAPSchema.schemaTypeNames[0]);
        this.names = stringArray;
        this.oid = string;
        this.description = string2;
        this.obsolete = bl2;
        this.syntaxString = string3;
        this.single = bl;
        this.equality = string5;
        this.ordering = string6;
        this.substring = string7;
        this.collective = bl3;
        this.userMod = bl4;
        this.usage = n;
        super.setValue(this.formatString());
    }

    public LDAPAttributeSchema(String string) {
        super(LDAPSchema.schemaTypeNames[0]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getNames() != null) {
                this.names = schemaParser.getNames();
            }
            if (schemaParser.getID() != null) {
                this.oid = schemaParser.getID();
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            if (schemaParser.getSyntax() != null) {
                this.syntaxString = schemaParser.getSyntax();
            }
            if (schemaParser.getSuperior() != null) {
                this.syntaxString = schemaParser.getSuperior();
            }
            this.single = schemaParser.getSingle();
            this.obsolete = schemaParser.getObsolete();
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public String getSyntaxString() {
        return this.syntaxString;
    }

    public String getSuperior() {
        return this.superior;
    }

    public boolean isSingleValued() {
        return this.single;
    }

    public String getEqualityMatchingRule() {
        return this.equality;
    }

    public String getOrderingMatchingRule() {
        return this.ordering;
    }

    public String getSubstringMatchingRule() {
        return this.substring;
    }

    public boolean isCollective() {
        return this.collective;
    }

    public boolean isUserModifiable() {
        return this.userMod;
    }

    public int getUsage() {
        return this.usage;
    }

    protected String formatString() {
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                    ++n;
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((string = this.getSuperior()) != null) {
            stringBuffer.append(" SUP ");
            stringBuffer.append("'" + string + "'");
        }
        if ((string = this.getEqualityMatchingRule()) != null) {
            stringBuffer.append(" EQUALITY ");
            stringBuffer.append("'" + string + "'");
        }
        if ((string = this.getOrderingMatchingRule()) != null) {
            stringBuffer.append(" ORDERING ");
            stringBuffer.append("'" + string + "'");
        }
        if ((string = this.getSubstringMatchingRule()) != null) {
            stringBuffer.append(" SUBSTR ");
            stringBuffer.append("'" + string + "'");
        }
        if ((string = this.getSyntaxString()) != null) {
            stringBuffer.append(" SYNTAX ");
            stringBuffer.append(string);
        }
        if (this.isSingleValued()) {
            stringBuffer.append(" SINGLE-VALUE");
        }
        if (this.isCollective()) {
            stringBuffer.append(" COLLECTIVE");
        }
        if (!this.isUserModifiable()) {
            stringBuffer.append(" NO-USER-MODIFICATION");
        }
        if ((n = this.getUsage()) != 0) {
            switch (n) {
                case 1: {
                    stringBuffer.append(" USAGE directoryOperation");
                    break;
                }
                case 2: {
                    stringBuffer.append(" USAGE distributedOperation");
                    break;
                }
                case 3: {
                    stringBuffer.append(" USAGE dSAOperation");
                    break;
                }
            }
        }
        Enumeration enumeration = this.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string == null) continue;
            stringBuffer.append(" " + string);
            stringArray = this.getQualifier(string);
            if (stringArray == null) continue;
            if (stringArray.length > 1) {
                stringBuffer.append("(");
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append(" '" + stringArray[n2] + "'");
                ++n2;
            }
            if (stringArray.length <= 1) continue;
            stringBuffer.append(" )");
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

