/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portal.ChannelParameter;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.IPortalDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChannelDefinition
implements IBasicEntity {
    private int id;
    private String chanFName;
    private String chanName;
    private String chanDesc;
    private String chanTitle;
    private String chanClass;
    private int chanTimeout;
    private int chanTypeId;
    private int chanPupblUsrId;
    private int chanApvlId;
    private Date chanPublDt;
    private Date chanApvlDt;
    private boolean chanEditable;
    private boolean chanHasHelp;
    private boolean chanHasAbout;
    private boolean chanIsSecure;
    private Map parameters;
    private String chanLocale;
    private Hashtable chanDescs;
    private Hashtable chanTitles;
    private Hashtable chanNames;
    static /* synthetic */ Class class$org$jasig$portal$ChannelDefinition;

    public ChannelDefinition(int id) {
        this.id = id;
        this.chanTitle = "";
        this.chanDesc = "";
        this.chanClass = "";
        this.parameters = new HashMap();
        this.chanLocale = null;
        this.chanTitles = new Hashtable();
        this.chanNames = new Hashtable();
        this.chanDescs = new Hashtable();
    }

    public int getId() {
        return this.id;
    }

    public String getFName() {
        return this.chanFName;
    }

    public String getName() {
        return this.chanName;
    }

    public String getDescription() {
        return this.chanDesc;
    }

    public String getTitle() {
        return this.chanTitle;
    }

    public String getJavaClass() {
        return this.chanClass;
    }

    public int getTimeout() {
        return this.chanTimeout;
    }

    public int getTypeId() {
        return this.chanTypeId;
    }

    public int getPublisherId() {
        return this.chanPupblUsrId;
    }

    public int getApproverId() {
        return this.chanApvlId;
    }

    public Date getPublishDate() {
        return this.chanPublDt;
    }

    public Date getApprovalDate() {
        return this.chanApvlDt;
    }

    public boolean isEditable() {
        return this.chanEditable;
    }

    public boolean hasHelp() {
        return this.chanHasHelp;
    }

    public boolean hasAbout() {
        return this.chanHasAbout;
    }

    public boolean isSecure() {
        return this.chanIsSecure;
    }

    public ChannelParameter[] getParameters() {
        return this.parameters.values().toArray(new ChannelParameter[0]);
    }

    public String getLocale() {
        return this.chanLocale;
    }

    public String getName(String locale) {
        String chanName = (String)this.chanNames.get(locale);
        if (chanName == null) {
            return this.chanName;
        }
        return chanName;
    }

    public String getDescription(String locale) {
        String chanDesc = (String)this.chanDescs.get(locale);
        if (chanDesc == null) {
            return this.chanDesc;
        }
        return chanDesc;
    }

    public String getTitle(String locale) {
        String chanDesc = (String)this.chanDescs.get(locale);
        if (chanDesc == null) {
            return this.chanDesc;
        }
        return chanDesc;
    }

    public void setFName(String fname) {
        this.chanFName = fname;
    }

    public void setName(String name) {
        this.chanName = name;
    }

    public void setDescription(String descr) {
        this.chanDesc = descr;
    }

    public void setTitle(String title) {
        this.chanTitle = title;
    }

    public void setJavaClass(String javaClass) {
        this.chanClass = javaClass;
    }

    public void setTimeout(int timeout) {
        this.chanTimeout = timeout;
    }

    public void setTypeId(int typeId) {
        this.chanTypeId = typeId;
    }

    public void setPublisherId(int publisherId) {
        this.chanPupblUsrId = publisherId;
    }

    public void setApproverId(int approvalId) {
        this.chanApvlId = approvalId;
    }

    public void setPublishDate(Date publishDate) {
        this.chanPublDt = publishDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.chanApvlDt = approvalDate;
    }

    public void setEditable(boolean editable) {
        this.chanEditable = editable;
    }

    public void setHasHelp(boolean hasHelp) {
        this.chanHasHelp = hasHelp;
    }

    public void setHasAbout(boolean hasAbout) {
        this.chanHasAbout = hasAbout;
    }

    public void setIsSecure(boolean isSecure) {
        this.chanIsSecure = isSecure;
    }

    public void setLocale(String locale) {
        if (locale != null) {
            this.chanLocale = locale;
        }
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void setParameters(ChannelParameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            this.parameters.put(parameters[i].getName(), parameters[i]);
        }
    }

    public void replaceParameters(ChannelParameter[] parameters) {
        this.clearParameters();
        this.setParameters(parameters);
    }

    public void putChanTitles(String locale, String chanTitle) {
        this.chanTitles.put(locale, chanTitle);
    }

    public void putChanNames(String locale, String chanName) {
        this.chanNames.put(locale, chanName);
    }

    public void putChanDescs(String locale, String chanDesc) {
        this.chanDescs.put(locale, chanDesc);
    }

    public EntityIdentifier getEntityIdentifier() {
        return new EntityIdentifier(String.valueOf(this.id), class$org$jasig$portal$ChannelDefinition == null ? (class$org$jasig$portal$ChannelDefinition = ChannelDefinition.class$("org.jasig.portal.ChannelDefinition")) : class$org$jasig$portal$ChannelDefinition);
    }

    public void addParameter(ChannelParameter parameter) {
        this.addParameter(parameter.getName(), parameter.getValue(), String.valueOf(parameter.getOverride()));
    }

    public void addParameter(String name, String value, String override) {
        this.parameters.put(name, new ChannelParameter(name, value, override));
    }

    public void removeParameter(ChannelParameter parameter) {
        this.removeParameter(parameter.getName());
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    private Element getBase(Document doc, String idTag, String chanClass, boolean editable, boolean hasHelp, boolean hasAbout) {
        Element channel = doc.createElement("channel");
        if (doc instanceof IPortalDocument) {
            ((IPortalDocument)doc).putIdentifier(idTag, channel);
        } else {
            StringBuffer msg = new StringBuffer(128);
            msg.append("ChannelDefinition::getBase() : ");
            msg.append("Document does not implement IPortalDocument, ");
            msg.append("so element caching cannot be performed.");
            LogService.log(LogService.ERROR, msg.toString());
        }
        channel.setAttribute("ID", idTag);
        channel.setAttribute("chanID", this.id + "");
        channel.setAttribute("timeout", this.chanTimeout + "");
        if (this.chanLocale != null) {
            channel.setAttribute("name", this.getName(this.chanLocale));
            channel.setAttribute("title", this.getTitle(this.chanLocale));
            channel.setAttribute("locale", this.chanLocale);
        } else {
            channel.setAttribute("name", this.chanName);
            channel.setAttribute("title", this.chanTitle);
        }
        channel.setAttribute("fname", this.chanFName);
        channel.setAttribute("class", chanClass);
        channel.setAttribute("typeID", this.chanTypeId + "");
        channel.setAttribute("editable", editable ? "true" : "false");
        channel.setAttribute("hasHelp", hasHelp ? "true" : "false");
        channel.setAttribute("hasAbout", hasAbout ? "true" : "false");
        channel.setAttribute("secure", this.chanIsSecure ? "true" : "false");
        return channel;
    }

    private final Element nodeParameter(Document doc, String name, int value) {
        return this.nodeParameter(doc, name, Integer.toString(value));
    }

    private final Element nodeParameter(Document doc, String name, String value) {
        Element parameter = doc.createElement("parameter");
        parameter.setAttribute("name", name);
        parameter.setAttribute("value", value);
        return parameter;
    }

    private final void addParameters(Document doc, Element channel) {
        if (this.parameters != null) {
            Iterator iter = this.parameters.values().iterator();
            while (iter.hasNext()) {
                ChannelParameter cp = (ChannelParameter)iter.next();
                Element parameter = this.nodeParameter(doc, cp.name, cp.value);
                if (cp.override) {
                    parameter.setAttribute("override", "yes");
                }
                channel.appendChild(parameter);
            }
        }
    }

    public Element getDocument(Document doc, String idTag, String statusMsg, int errorId) {
        Element channel = this.getBase(doc, idTag, "org.jasig.portal.channels.CError", false, false, false);
        this.addParameters(doc, channel);
        channel.appendChild(this.nodeParameter(doc, "CErrorMessage", statusMsg));
        channel.appendChild(this.nodeParameter(doc, "CErrorChanId", idTag));
        channel.appendChild(this.nodeParameter(doc, "CErrorErrorId", errorId));
        return channel;
    }

    public Element getDocument(Document doc, String idTag) {
        Element channel = this.getBase(doc, idTag, this.chanClass, this.chanEditable, this.chanHasHelp, this.chanHasAbout);
        channel.setAttribute("description", this.chanDesc);
        this.addParameters(doc, channel);
        return channel;
    }

    public boolean refreshMe() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

